// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.27.0
// source: query.sql

package binary_cache_v6

import (
	"context"
	"database/sql"
)

const insertCache = `-- name: InsertCache :one
insert into BinaryCaches(url, timestamp, storeDir, wantMassQuery, priority)
values (?1, ?2, ?3, ?4, ?5)
on conflict (url)
do update set timestamp = ?2, storeDir = ?3, wantMassQuery = ?4, priority = ?5
returning id
`

type InsertCacheParams struct {
	Url           string
	Timestamp     int64
	Storedir      string
	Wantmassquery int64
	Priority      int64
}

func (q *Queries) InsertCache(ctx context.Context, arg InsertCacheParams) (int64, error) {
	row := q.db.QueryRowContext(ctx, insertCache,
		arg.Url,
		arg.Timestamp,
		arg.Storedir,
		arg.Wantmassquery,
		arg.Priority,
	)
	var id int64
	err := row.Scan(&id)
	return id, err
}

const insertMissingNAR = `-- name: InsertMissingNAR :exec
insert or replace into NARs(cache, hashPart, timestamp, present) values (?, ?, ?, 0)
`

type InsertMissingNARParams struct {
	Cache     int64
	Hashpart  string
	Timestamp int64
}

func (q *Queries) InsertMissingNAR(ctx context.Context, arg InsertMissingNARParams) error {
	_, err := q.db.ExecContext(ctx, insertMissingNAR, arg.Cache, arg.Hashpart, arg.Timestamp)
	return err
}

const insertMissingRealisation = `-- name: InsertMissingRealisation :exec
insert or replace into Realisations(cache, outputId, timestamp)
values (?, ?, ?)
`

type InsertMissingRealisationParams struct {
	Cache     int64
	Outputid  string
	Timestamp int64
}

func (q *Queries) InsertMissingRealisation(ctx context.Context, arg InsertMissingRealisationParams) error {
	_, err := q.db.ExecContext(ctx, insertMissingRealisation, arg.Cache, arg.Outputid, arg.Timestamp)
	return err
}

const insertNar = `-- name: InsertNar :exec
insert or replace into NARs(
    cache, hashPart, namePart, url, compression, fileHash, fileSize, narHash, narSize, refs, deriver, sigs, ca,
    timestamp, present
) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1)
`

type InsertNarParams struct {
	Cache       int64
	Hashpart    string
	Namepart    sql.NullString
	Url         sql.NullString
	Compression sql.NullString
	Filehash    sql.NullString
	Filesize    sql.NullInt64
	Narhash     sql.NullString
	Narsize     sql.NullInt64
	Refs        sql.NullString
	Deriver     sql.NullString
	Sigs        sql.NullString
	Ca          sql.NullString
	Timestamp   int64
}

func (q *Queries) InsertNar(ctx context.Context, arg InsertNarParams) error {
	_, err := q.db.ExecContext(ctx, insertNar,
		arg.Cache,
		arg.Hashpart,
		arg.Namepart,
		arg.Url,
		arg.Compression,
		arg.Filehash,
		arg.Filesize,
		arg.Narhash,
		arg.Narsize,
		arg.Refs,
		arg.Deriver,
		arg.Sigs,
		arg.Ca,
		arg.Timestamp,
	)
	return err
}

const insertRealisation = `-- name: InsertRealisation :exec
insert or replace into Realisations(cache, outputId, content, timestamp)
values (?, ?, ?, ?)
`

type InsertRealisationParams struct {
	Cache     int64
	Outputid  string
	Content   []byte
	Timestamp int64
}

func (q *Queries) InsertRealisation(ctx context.Context, arg InsertRealisationParams) error {
	_, err := q.db.ExecContext(ctx, insertRealisation,
		arg.Cache,
		arg.Outputid,
		arg.Content,
		arg.Timestamp,
	)
	return err
}

const purgeNars = `-- name: PurgeNars :exec
delete from NARs where ((present = 0 and timestamp < ?) or (present = 1 and timestamp < ?))
`

type PurgeNarsParams struct {
	Timestamp   int64
	Timestamp_2 int64
}

func (q *Queries) PurgeNars(ctx context.Context, arg PurgeNarsParams) error {
	_, err := q.db.ExecContext(ctx, purgeNars, arg.Timestamp, arg.Timestamp_2)
	return err
}

const queryCache = `-- name: QueryCache :many
select id, storeDir, wantMassQuery, priority from BinaryCaches where url = ? and timestamp > ?
`

type QueryCacheParams struct {
	Url       string
	Timestamp int64
}

type QueryCacheRow struct {
	ID            int64
	Storedir      string
	Wantmassquery int64
	Priority      int64
}

func (q *Queries) QueryCache(ctx context.Context, arg QueryCacheParams) ([]QueryCacheRow, error) {
	rows, err := q.db.QueryContext(ctx, queryCache, arg.Url, arg.Timestamp)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []QueryCacheRow
	for rows.Next() {
		var i QueryCacheRow
		if err := rows.Scan(
			&i.ID,
			&i.Storedir,
			&i.Wantmassquery,
			&i.Priority,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const queryLastPurge = `-- name: QueryLastPurge :one
select value from LastPurge
`

func (q *Queries) QueryLastPurge(ctx context.Context) (sql.NullInt64, error) {
	row := q.db.QueryRowContext(ctx, queryLastPurge)
	var value sql.NullInt64
	err := row.Scan(&value)
	return value, err
}

const queryNar = `-- name: QueryNar :many
select present, namePart, url, compression, fileHash, fileSize, narHash, narSize, refs, deriver, sigs, ca from NARs
where cache = ? and hashPart = ? and ((present = 0 and timestamp > ?) or (present = 1 and timestamp > ?))
`

type QueryNarParams struct {
	Cache       int64
	Hashpart    string
	Timestamp   int64
	Timestamp_2 int64
}

type QueryNarRow struct {
	Present     int64
	Namepart    sql.NullString
	Url         sql.NullString
	Compression sql.NullString
	Filehash    sql.NullString
	Filesize    sql.NullInt64
	Narhash     sql.NullString
	Narsize     sql.NullInt64
	Refs        sql.NullString
	Deriver     sql.NullString
	Sigs        sql.NullString
	Ca          sql.NullString
}

func (q *Queries) QueryNar(ctx context.Context, arg QueryNarParams) ([]QueryNarRow, error) {
	rows, err := q.db.QueryContext(ctx, queryNar,
		arg.Cache,
		arg.Hashpart,
		arg.Timestamp,
		arg.Timestamp_2,
	)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []QueryNarRow
	for rows.Next() {
		var i QueryNarRow
		if err := rows.Scan(
			&i.Present,
			&i.Namepart,
			&i.Url,
			&i.Compression,
			&i.Filehash,
			&i.Filesize,
			&i.Narhash,
			&i.Narsize,
			&i.Refs,
			&i.Deriver,
			&i.Sigs,
			&i.Ca,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const queryRealisation = `-- name: QueryRealisation :many
select content from Realisations
where cache = ? and outputId = ?  and
(
    (content is null and timestamp > ?) or
    (content is not null and timestamp > ?)
)
`

type QueryRealisationParams struct {
	Cache       int64
	Outputid    string
	Timestamp   int64
	Timestamp_2 int64
}

func (q *Queries) QueryRealisation(ctx context.Context, arg QueryRealisationParams) ([][]byte, error) {
	rows, err := q.db.QueryContext(ctx, queryRealisation,
		arg.Cache,
		arg.Outputid,
		arg.Timestamp,
		arg.Timestamp_2,
	)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items [][]byte
	for rows.Next() {
		var content []byte
		if err := rows.Scan(&content); err != nil {
			return nil, err
		}
		items = append(items, content)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateLastPurge = `-- name: UpdateLastPurge :exec
insert or replace into LastPurge(dummy, value) values ('', ?)
`

func (q *Queries) UpdateLastPurge(ctx context.Context, value sql.NullInt64) error {
	_, err := q.db.ExecContext(ctx, updateLastPurge, value)
	return err
}
