---
layout: home
---
Relentless
==========

The `<relentless>` task will execute all of the nested tasks, regardless of whether one or more of the nested tasks fails. When `<relentless>` has completed executing the nested tasks, it will either

-   fail, if any one or more of the nested tasks failed; or
-   succeed, if all of the nested tasks succeeded.

An appropriate message will be written to the log.

Tasks are executed in the order that they appear within the `<relentless>` task. It is up to the user to ensure that relentless execution of the nested tasks is safe.

*This task only works for ant version greater than or equal to ant 1.6.0.*

Parameters
----------

| Attribute   | Description                                                                                                                                                             | Required |
|-------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| `description` | A string that will be included in the log output. This can be useful for helping to identify sections of large Ant builds.                                              | No       |
| `terse`       | Setting this to `true` will eliminate some of the progress output generated by `<relentless>`. This can reduce clutter in some cases. The default value is `false`. | No       |

Nested elements
---------------

### task list

The only nested element supported by `<relentless>` is a list of tasks to be executed. At least one task must be specified.

It is important to note that `<relentless>` only proceeds relentlessly from one task to the next - it does **not** apply recursively to any tasks that might be invoked by these nested tasks. If a nested task invokes some other list of tasks (perhaps by `<antcall>` for example), and one of those other tasks fails, then the nested task will stop at that point.

### Example

A relentless task to print out the first five canonical variable names:

```xml
<relentless description="The first five canonical variable names.">
  <echo>foo</echo>
  <echo>bar</echo>
  <echo>baz</echo>
  <echo>bat</echo>
  <echo>blah</echo>
</relentless>
```

which should produce output looking more or less like

```
[relentless] Relentlessly executing: The first five canonical variable names.
[relentless] Executing: task 1
    [echo] foo
[relentless] Executing: task 2
    [echo] bar
[relentless] Executing: task 3
    [echo] baz
[relentless] Executing: task 4
    [echo] bat
[relentless] Executing: task 5
    [echo] blah
[relentless] All tasks completed successfully.
```

If you change the first line to set the `terse` parameter,

```xml
<relentless terse="true" description="The first five canonical variable names."/>
```

the output will look more like this:

```
[relentless] Relentlessly executing: The first five canonical variable names.
    [echo] foo
    [echo] bar
    [echo] baz
    [echo] bat
    [echo] blah
[relentless] All tasks completed successfully.
```

If we change the third task to deliberately fail

```xml
<relentless terse="true" description="The first five canonical variable names.">
  <echo>foo</echo>
  <echo>bar</echo>
  <fail>baz</fail>
  <echo>bat</echo>
  <echo>blah</echo>
</relentless>
```

then the output should look something like this.

```
[relentless] Relentlessly executing: The first five canonical variable names.
    [echo] foo
    [echo] bar
[relentless] Task task 3 failed: baz
    [echo] bat
    [echo] blah

BUILD FAILED
/home/richter/firmware/sensor/build.xml:1177: Relentless execution: 1 of 5 tasks failed.
```
