/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ingest.SimulateDocumentBaseResult;
import org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.elasticsearch.action.ingest.SimulateDocumentVerboseResult;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.ingest.SimulatePipelineResponse;
import org.elasticsearch.action.ingest.SimulateProcessorResult;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.TrackingResultProcessor;
import org.elasticsearch.threadpool.ThreadPool;

class SimulateExecutionService {
    private static final String THREAD_POOL_NAME = "management";
    private final ThreadPool threadPool;

    SimulateExecutionService(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    void executeDocument(Pipeline pipeline, IngestDocument ingestDocument, boolean verbose, BiConsumer<SimulateDocumentResult, Exception> handler) {
        if (verbose) {
            CopyOnWriteArrayList<SimulateProcessorResult> processorResultList = new CopyOnWriteArrayList<SimulateProcessorResult>();
            CompoundProcessor verbosePipelineProcessor = TrackingResultProcessor.decorate(pipeline.getCompoundProcessor(), null, processorResultList);
            Pipeline verbosePipeline = new Pipeline(pipeline.getId(), pipeline.getDescription(), pipeline.getVersion(), pipeline.getMetadata(), verbosePipelineProcessor);
            ingestDocument.executePipeline(verbosePipeline, (result, e) -> handler.accept(new SimulateDocumentVerboseResult(processorResultList), (Exception)e));
        } else {
            ingestDocument.executePipeline(pipeline, (result, e) -> {
                if (e == null) {
                    handler.accept(new SimulateDocumentBaseResult((IngestDocument)result), null);
                } else {
                    handler.accept(new SimulateDocumentBaseResult((Exception)e), null);
                }
            });
        }
    }

    public void execute(SimulatePipelineRequest.Parsed request, ActionListener<SimulatePipelineResponse> listener) {
        this.threadPool.executor(THREAD_POOL_NAME).execute(ActionRunnable.wrap(listener, l -> {
            AtomicInteger counter = new AtomicInteger();
            CopyOnWriteArrayList<SimulateDocumentResult> responses = new CopyOnWriteArrayList<SimulateDocumentResult>(new SimulateDocumentBaseResult[request.getDocuments().size()]);
            if (request.getDocuments().isEmpty()) {
                l.onResponse(new SimulatePipelineResponse(request.getPipeline().getId(), request.isVerbose(), responses));
                return;
            }
            int iter = 0;
            for (IngestDocument ingestDocument : request.getDocuments()) {
                int index = iter++;
                this.executeDocument(request.getPipeline(), ingestDocument, request.isVerbose(), (response, e) -> {
                    if (response != null) {
                        responses.set(index, (SimulateDocumentResult)response);
                    }
                    if (counter.incrementAndGet() == request.getDocuments().size()) {
                        listener.onResponse(new SimulatePipelineResponse(request.getPipeline().getId(), request.isVerbose(), responses));
                    }
                });
            }
        }));
    }
}

