/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.SystemIndices;

public class IndexAbstractionResolver {
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public IndexAbstractionResolver(IndexNameExpressionResolver indexNameExpressionResolver) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public List<String> resolveIndexAbstractions(String[] indices, IndicesOptions indicesOptions, Metadata metadata, boolean includeDataStreams) {
        return this.resolveIndexAbstractions(Arrays.asList(indices), indicesOptions, metadata, includeDataStreams);
    }

    public List<String> resolveIndexAbstractions(Iterable<String> indices, IndicesOptions indicesOptions, Metadata metadata, boolean includeDataStreams) {
        boolean replaceWildcards = indicesOptions.expandWildcardsOpen() || indicesOptions.expandWildcardsClosed();
        Set<String> availableIndexAbstractions = metadata.getIndicesLookup().keySet();
        return this.resolveIndexAbstractions(indices, indicesOptions, metadata, availableIndexAbstractions, replaceWildcards, includeDataStreams);
    }

    public List<String> resolveIndexAbstractions(Iterable<String> indices, IndicesOptions indicesOptions, Metadata metadata, Collection<String> availableIndexAbstractions, boolean replaceWildcards, boolean includeDataStreams) {
        ArrayList<String> finalIndices = new ArrayList<String>();
        boolean wildcardSeen = false;
        for (String index : indices) {
            String indexAbstraction;
            boolean minus = false;
            if (index.charAt(0) == '-' && wildcardSeen) {
                indexAbstraction = index.substring(1);
                minus = true;
            } else {
                indexAbstraction = index;
            }
            String dateMathName = this.indexNameExpressionResolver.resolveDateMathExpression(indexAbstraction);
            if (dateMathName != indexAbstraction) {
                assert (!dateMathName.equals(indexAbstraction));
                if (replaceWildcards && Regex.isSimpleMatchPattern(dateMathName)) {
                    indexAbstraction = dateMathName;
                } else if (availableIndexAbstractions.contains(dateMathName) && IndexAbstractionResolver.isIndexVisible(indexAbstraction, dateMathName, indicesOptions, metadata, this.indexNameExpressionResolver, includeDataStreams, true)) {
                    if (minus) {
                        finalIndices.remove(dateMathName);
                    } else {
                        finalIndices.add(dateMathName);
                    }
                } else if (!indicesOptions.ignoreUnavailable()) {
                    throw new IndexNotFoundException(dateMathName);
                }
            }
            if (replaceWildcards && Regex.isSimpleMatchPattern(indexAbstraction)) {
                wildcardSeen = true;
                HashSet<String> resolvedIndices = new HashSet<String>();
                for (String authorizedIndex : availableIndexAbstractions) {
                    if (!Regex.simpleMatch(indexAbstraction, authorizedIndex) || !IndexAbstractionResolver.isIndexVisible(indexAbstraction, authorizedIndex, indicesOptions, metadata, this.indexNameExpressionResolver, includeDataStreams)) continue;
                    resolvedIndices.add(authorizedIndex);
                }
                if (resolvedIndices.isEmpty()) {
                    if (indicesOptions.allowNoIndices()) continue;
                    throw new IndexNotFoundException(indexAbstraction);
                }
                if (minus) {
                    finalIndices.removeAll(resolvedIndices);
                    continue;
                }
                finalIndices.addAll(resolvedIndices);
                continue;
            }
            if (!dateMathName.equals(indexAbstraction)) continue;
            if (minus) {
                finalIndices.remove(indexAbstraction);
                continue;
            }
            if (indicesOptions.ignoreUnavailable() && !availableIndexAbstractions.contains(indexAbstraction)) continue;
            finalIndices.add(indexAbstraction);
        }
        return finalIndices;
    }

    public static boolean isIndexVisible(String expression, String index, IndicesOptions indicesOptions, Metadata metadata, IndexNameExpressionResolver resolver, boolean includeDataStreams) {
        return IndexAbstractionResolver.isIndexVisible(expression, index, indicesOptions, metadata, resolver, includeDataStreams, false);
    }

    public static boolean isIndexVisible(String expression, String index, IndicesOptions indicesOptions, Metadata metadata, IndexNameExpressionResolver resolver, boolean includeDataStreams, boolean dateMathExpression) {
        IndexMetadata indexMetadata;
        boolean isVisible;
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(index);
        if (indexAbstraction == null) {
            throw new IllegalStateException("could not resolve index abstraction [" + index + "]");
        }
        boolean isHidden = indexAbstraction.isHidden();
        boolean bl = isVisible = !isHidden || indicesOptions.expandWildcardsHidden() || IndexAbstractionResolver.isVisibleDueToImplicitHidden(expression, index);
        if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
            return isVisible && !indicesOptions.ignoreAliases();
        }
        if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
            if (!includeDataStreams) {
                return false;
            }
            if (indexAbstraction.isSystem()) {
                SystemIndices.SystemIndexAccessLevel level = resolver.getSystemIndexAccessLevel();
                switch (level) {
                    case ALL: {
                        return true;
                    }
                    case NONE: {
                        return false;
                    }
                    case RESTRICTED: {
                        return resolver.getSystemIndexAccessPredicate().test(indexAbstraction.getName());
                    }
                    case BACKWARDS_COMPATIBLE_ONLY: {
                        return resolver.getNetNewSystemIndexPredicate().test(indexAbstraction.getName());
                    }
                }
                assert (false) : "unexpected system index access level [" + (Object)((Object)level) + "]";
                throw new IllegalStateException("unexpected system index access level [" + (Object)((Object)level) + "]");
            }
            return isVisible;
        }
        assert (indexAbstraction.getIndices().size() == 1) : "concrete index must point to a single index";
        if (dateMathExpression) {
            assert (IndexMetadata.State.values().length == 2) : "a new IndexMetadata.State value may need to be handled!";
            return true;
        }
        if (!isVisible) {
            return false;
        }
        if (indexAbstraction.isSystem()) {
            if (resolver.getNetNewSystemIndexPredicate().test(indexAbstraction.getName())) {
                SystemIndices.SystemIndexAccessLevel level = resolver.getSystemIndexAccessLevel();
                switch (level) {
                    case ALL: {
                        return true;
                    }
                    case NONE: {
                        return false;
                    }
                    case RESTRICTED: {
                        return resolver.getSystemIndexAccessPredicate().test(indexAbstraction.getName());
                    }
                    case BACKWARDS_COMPATIBLE_ONLY: {
                        return resolver.getNetNewSystemIndexPredicate().test(indexAbstraction.getName());
                    }
                }
                assert (false) : "unexpected system index access level [" + (Object)((Object)level) + "]";
                throw new IllegalStateException("unexpected system index access level [" + (Object)((Object)level) + "]");
            }
            if (indexAbstraction.getParentDataStream() != null) {
                if (!indexAbstraction.getParentDataStream().isSystem()) {
                    assert (false) : "system index is part of a data stream that is not a system data stream";
                    throw new IllegalStateException("system index is part of a data stream that is not a system data stream");
                }
                SystemIndices.SystemIndexAccessLevel level = resolver.getSystemIndexAccessLevel();
                switch (level) {
                    case ALL: {
                        return true;
                    }
                    case NONE: {
                        return false;
                    }
                    case RESTRICTED: {
                        return resolver.getSystemIndexAccessPredicate().test(indexAbstraction.getName());
                    }
                    case BACKWARDS_COMPATIBLE_ONLY: {
                        return resolver.getNetNewSystemIndexPredicate().test(indexAbstraction.getName());
                    }
                }
                assert (false) : "unexpected system index access level [" + (Object)((Object)level) + "]";
                throw new IllegalStateException("unexpected system index access level [" + (Object)((Object)level) + "]");
            }
        }
        if ((indexMetadata = metadata.index(indexAbstraction.getIndices().get(0))).getState() == IndexMetadata.State.CLOSE && indicesOptions.expandWildcardsClosed()) {
            return true;
        }
        return indexMetadata.getState() == IndexMetadata.State.OPEN && indicesOptions.expandWildcardsOpen();
    }

    private static boolean isVisibleDueToImplicitHidden(String expression, String index) {
        return index.startsWith(".") && expression.startsWith(".") && Regex.isSimpleMatchPattern(expression);
    }
}

