/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public final class Mapping
implements ToXContentFragment {
    public static final Mapping EMPTY = new Mapping(new RootObjectMapper.Builder("_doc").build(MapperBuilderContext.ROOT), new MetadataFieldMapper[0], null);
    private final RootObjectMapper root;
    private final Map<String, Object> meta;
    private final MetadataFieldMapper[] metadataMappers;
    private final Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappersMap;
    private final Map<String, MetadataFieldMapper> metadataMappersByName;

    public Mapping(RootObjectMapper rootObjectMapper, MetadataFieldMapper[] metadataMappers, Map<String, Object> meta) {
        this.metadataMappers = metadataMappers;
        HashMap metadataMappersMap = new HashMap();
        HashMap<String, MetadataFieldMapper> metadataMappersByName = new HashMap<String, MetadataFieldMapper>();
        for (MetadataFieldMapper metadataMapper : metadataMappers) {
            metadataMappersMap.put(metadataMapper.getClass(), metadataMapper);
            metadataMappersByName.put(metadataMapper.name(), metadataMapper);
        }
        this.root = rootObjectMapper;
        Arrays.sort(metadataMappers, new Comparator<Mapper>(){

            @Override
            public int compare(Mapper o1, Mapper o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        this.metadataMappersMap = Collections.unmodifiableMap(metadataMappersMap);
        this.metadataMappersByName = Collections.unmodifiableMap(metadataMappersByName);
        this.meta = meta;
    }

    public CompressedXContent toCompressedXContent() {
        try {
            return new CompressedXContent((ToXContent)this, XContentType.JSON, ToXContent.EMPTY_PARAMS);
        }
        catch (Exception e) {
            throw new ElasticsearchGenerationException("failed to serialize source for type [" + this.root.name() + "]", e);
        }
    }

    public String type() {
        return this.root.name();
    }

    RootObjectMapper getRoot() {
        return this.root;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    MetadataFieldMapper[] getSortedMetadataMappers() {
        return this.metadataMappers;
    }

    Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> getMetadataMappersMap() {
        return this.metadataMappersMap;
    }

    public <T extends MetadataFieldMapper> T getMetadataMapperByClass(Class<T> clazz) {
        return (T)this.metadataMappersMap.get(clazz);
    }

    MetadataFieldMapper getMetadataMapperByName(String mapperName) {
        return this.metadataMappersByName.get(mapperName);
    }

    void validate(MappingLookup mappers) {
        for (MetadataFieldMapper metadataFieldMapper : this.metadataMappers) {
            metadataFieldMapper.validate(mappers);
        }
        this.root.validate(mappers);
    }

    Mapping mappingUpdate(RootObjectMapper rootObjectMapper) {
        return new Mapping(rootObjectMapper, this.metadataMappers, this.meta);
    }

    public Mapping merge(Mapping mergeWith, MapperService.MergeReason reason) {
        Map<String, Object> mergedMeta;
        RootObjectMapper mergedRoot = this.root.merge(mergeWith.root, reason);
        HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> mergedMetadataMappers = new HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>(this.metadataMappersMap);
        for (MetadataFieldMapper metaMergeWith : mergeWith.metadataMappers) {
            MetadataFieldMapper mergeInto = (MetadataFieldMapper)mergedMetadataMappers.get(metaMergeWith.getClass());
            MetadataFieldMapper merged = mergeInto == null || reason == MapperService.MergeReason.INDEX_TEMPLATE ? metaMergeWith : (MetadataFieldMapper)mergeInto.merge(metaMergeWith);
            mergedMetadataMappers.put(merged.getClass(), merged);
        }
        if (mergeWith.meta == null) {
            mergedMeta = this.meta;
        } else if (this.meta == null || reason != MapperService.MergeReason.INDEX_TEMPLATE) {
            mergedMeta = mergeWith.meta;
        } else {
            mergedMeta = new HashMap<String, Object>(mergeWith.meta);
            XContentHelper.mergeDefaults(mergedMeta, this.meta);
        }
        return new Mapping(mergedRoot, mergedMetadataMappers.values().toArray(new MetadataFieldMapper[0]), mergedMeta);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.root.toXContent(builder, params, (b, params1) -> {
            if (this.meta != null) {
                b.field("_meta", this.meta);
            }
            for (MetadataFieldMapper mapper : this.metadataMappers) {
                mapper.toXContent(b, params1);
            }
            return b;
        });
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return Strings.toString(builder.endObject());
        }
        catch (IOException bogus) {
            throw new UncheckedIOException(bogus);
        }
    }
}

