/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class RepositoryInfo
implements Writeable,
ToXContentFragment {
    public final String ephemeralId;
    public final String name;
    public final String type;
    public final Map<String, String> location;
    public final long startedAt;
    @Nullable
    public final Long stoppedAt;

    public RepositoryInfo(String ephemeralId, String name, String type, Map<String, String> location, long startedAt) {
        this(ephemeralId, name, type, location, startedAt, null);
    }

    public RepositoryInfo(String ephemeralId, String name, String type, Map<String, String> location, long startedAt, @Nullable Long stoppedAt) {
        this.ephemeralId = ephemeralId;
        this.name = name;
        this.type = type;
        this.location = location;
        this.startedAt = startedAt;
        if (stoppedAt != null && startedAt > stoppedAt) {
            throw new IllegalArgumentException("createdAt must be before or equal to stoppedAt");
        }
        this.stoppedAt = stoppedAt;
    }

    public RepositoryInfo(StreamInput in) throws IOException {
        this.ephemeralId = in.readString();
        this.name = in.readString();
        this.type = in.readString();
        this.location = in.readMap(StreamInput::readString, StreamInput::readString);
        this.startedAt = in.readLong();
        this.stoppedAt = in.readOptionalLong();
    }

    public RepositoryInfo stopped(long stoppedAt) {
        assert (!this.isStopped()) : "The repository is already stopped";
        return new RepositoryInfo(this.ephemeralId, this.name, this.type, this.location, this.startedAt, stoppedAt);
    }

    public boolean isStopped() {
        return this.stoppedAt != null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.ephemeralId);
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeMap(this.location, StreamOutput::writeString, StreamOutput::writeString);
        out.writeLong(this.startedAt);
        out.writeOptionalLong(this.stoppedAt);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("repository_name", this.name);
        builder.field("repository_type", this.type);
        builder.field("repository_location", this.location);
        builder.field("repository_ephemeral_id", this.ephemeralId);
        builder.field("repository_started_at", this.startedAt);
        if (this.stoppedAt != null) {
            builder.field("repository_stopped_at", this.stoppedAt);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryInfo that = (RepositoryInfo)o;
        return this.ephemeralId.equals(that.ephemeralId) && this.name.equals(that.name) && this.type.equals(that.type) && this.location.equals(that.location) && this.startedAt == that.startedAt && Objects.equals(this.stoppedAt, that.stoppedAt);
    }

    public int hashCode() {
        return Objects.hash(this.ephemeralId, this.name, this.type, this.location, this.startedAt, this.stoppedAt);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

