/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.dfs.DfsSearchResult;

public class AggregatedDfs
implements Writeable {
    private ObjectObjectHashMap<Term, TermStatistics> termStatistics;
    private ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics;
    private long maxDoc;

    public AggregatedDfs(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.termStatistics = HppcMaps.newMap(size);
        for (int i = 0; i < size; ++i) {
            Term term = new Term(in.readString(), in.readBytesRef());
            BytesRef term2 = in.readBytesRef();
            long docFreq = in.readVLong();
            assert (docFreq >= 0L);
            long totalTermFreq = DfsSearchResult.subOne(in.readVLong());
            if (in.getVersion().before(Version.V_7_0_0) && totalTermFreq == -1L) {
                totalTermFreq = docFreq;
            }
            TermStatistics stats = new TermStatistics(term2, docFreq, totalTermFreq);
            this.termStatistics.put((Object)term, (Object)stats);
        }
        this.fieldStatistics = DfsSearchResult.readFieldStats(in);
        this.maxDoc = in.readVLong();
    }

    public AggregatedDfs(ObjectObjectHashMap<Term, TermStatistics> termStatistics, ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics, long maxDoc) {
        this.termStatistics = termStatistics;
        this.fieldStatistics = fieldStatistics;
        this.maxDoc = maxDoc;
    }

    public ObjectObjectHashMap<Term, TermStatistics> termStatistics() {
        return this.termStatistics;
    }

    public ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    public long maxDoc() {
        return this.maxDoc;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.termStatistics.size());
        for (ObjectObjectCursor c : this.termStatistics()) {
            Term term = (Term)c.key;
            out.writeString(term.field());
            out.writeBytesRef(term.bytes());
            TermStatistics stats = (TermStatistics)c.value;
            out.writeBytesRef(stats.term());
            out.writeVLong(stats.docFreq());
            out.writeVLong(DfsSearchResult.addOne(stats.totalTermFreq()));
        }
        DfsSearchResult.writeFieldStats(out, this.fieldStatistics);
        out.writeVLong(this.maxDoc);
    }
}

