/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.cluster.routing.allocation;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class DataTierAllocationDecider
extends AllocationDecider {
    public static final String NAME = "data_tier";
    public static final String CLUSTER_ROUTING_REQUIRE = "cluster.routing.allocation.require._tier";
    public static final String CLUSTER_ROUTING_INCLUDE = "cluster.routing.allocation.include._tier";
    public static final String CLUSTER_ROUTING_EXCLUDE = "cluster.routing.allocation.exclude._tier";
    public static final String INDEX_ROUTING_REQUIRE = "index.routing.allocation.require._tier";
    public static final String INDEX_ROUTING_INCLUDE = "index.routing.allocation.include._tier";
    public static final String INDEX_ROUTING_EXCLUDE = "index.routing.allocation.exclude._tier";
    public static final String TIER_PREFERENCE = "index.routing.allocation.include._tier_preference";
    public static final Setting<String> CLUSTER_ROUTING_REQUIRE_SETTING = Setting.simpleString((String)"cluster.routing.allocation.require._tier", DataTierAllocationDecider::validateTierSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<String> CLUSTER_ROUTING_INCLUDE_SETTING = Setting.simpleString((String)"cluster.routing.allocation.include._tier", DataTierAllocationDecider::validateTierSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<String> CLUSTER_ROUTING_EXCLUDE_SETTING = Setting.simpleString((String)"cluster.routing.allocation.exclude._tier", DataTierAllocationDecider::validateTierSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<String> INDEX_ROUTING_REQUIRE_SETTING = Setting.simpleString((String)"index.routing.allocation.require._tier", (Setting.Validator)DataTier.DATA_TIER_SETTING_VALIDATOR, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.Deprecated});
    public static final Setting<String> INDEX_ROUTING_INCLUDE_SETTING = Setting.simpleString((String)"index.routing.allocation.include._tier", (Setting.Validator)DataTier.DATA_TIER_SETTING_VALIDATOR, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.Deprecated});
    public static final Setting<String> INDEX_ROUTING_EXCLUDE_SETTING = Setting.simpleString((String)"index.routing.allocation.exclude._tier", (Setting.Validator)DataTier.DATA_TIER_SETTING_VALIDATOR, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.Deprecated});
    private volatile String clusterRequire;
    private volatile String clusterInclude;
    private volatile String clusterExclude;

    private static void validateTierSetting(String setting) {
        if (Strings.hasText((String)setting)) {
            for (String s : setting.split(",")) {
                if (DataTier.validTierName((String)s)) continue;
                throw new IllegalArgumentException("invalid tier names found in [" + setting + "] allowed values are " + DataTier.ALL_DATA_TIERS);
            }
        }
    }

    public DataTierAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.clusterRequire = (String)CLUSTER_ROUTING_REQUIRE_SETTING.get(settings);
        this.clusterInclude = (String)CLUSTER_ROUTING_INCLUDE_SETTING.get(settings);
        this.clusterExclude = (String)CLUSTER_ROUTING_EXCLUDE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_REQUIRE_SETTING, s -> {
            this.clusterRequire = s;
        });
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_INCLUDE_SETTING, s -> {
            this.clusterInclude = s;
        });
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_EXCLUDE_SETTING, s -> {
            this.clusterExclude = s;
        });
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(indexMetadata, node.node().getRoles(), allocation);
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        return this.shouldFilter(indexMetadata, node.getRoles(), allocation);
    }

    private Decision shouldFilter(ShardRouting shardRouting, DiscoveryNode node, RoutingAllocation allocation) {
        return this.shouldFilter(allocation.metadata().getIndexSafe(shardRouting.index()), node.getRoles(), allocation);
    }

    public Decision shouldFilter(IndexMetadata indexMd, Set<DiscoveryNodeRole> roles, RoutingAllocation allocation) {
        return this.shouldFilter(indexMd, roles, DataTierAllocationDecider::preferredAvailableTier, allocation);
    }

    public Decision shouldFilter(IndexMetadata indexMd, Set<DiscoveryNodeRole> roles, PreferredTierFunction preferredTierFunction, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(roles, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(indexMd, roles, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexPreferTier(indexMd, roles, preferredTierFunction, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require/prefer tier filters", new Object[0]);
    }

    private Decision shouldIndexPreferTier(IndexMetadata indexMetadata, Set<DiscoveryNodeRole> roles, PreferredTierFunction preferredTierFunction, RoutingAllocation allocation) {
        List tierPreference = indexMetadata.getTierPreference();
        if (!tierPreference.isEmpty()) {
            Optional<String> tier = preferredTierFunction.apply(tierPreference, allocation.nodes());
            if (tier.isPresent()) {
                String tierName = tier.get();
                if (DataTierAllocationDecider.allocationAllowed(tierName, roles)) {
                    if (!allocation.debugDecision()) {
                        return Decision.YES;
                    }
                    return allocation.decision(Decision.YES, NAME, "index has a preference for tiers [%s] and node has tier [%s]", new Object[]{String.join((CharSequence)",", tierPreference), tierName});
                }
                if (!allocation.debugDecision()) {
                    return Decision.NO;
                }
                return allocation.decision(Decision.NO, NAME, "index has a preference for tiers [%s] and node does not meet the required [%s] tier", new Object[]{String.join((CharSequence)",", tierPreference), tierName});
            }
            if (!allocation.debugDecision()) {
                return Decision.NO;
            }
            return allocation.decision(Decision.NO, NAME, "index has a preference for tiers [%s], but no nodes for any of those tiers are available in the cluster", new Object[]{String.join((CharSequence)",", tierPreference)});
        }
        return null;
    }

    private Decision shouldIndexFilter(IndexMetadata indexMd, Set<DiscoveryNodeRole> roles, RoutingAllocation allocation) {
        Settings indexSettings = indexMd.getSettings();
        String indexRequire = (String)INDEX_ROUTING_REQUIRE_SETTING.get(indexSettings);
        String indexInclude = (String)INDEX_ROUTING_INCLUDE_SETTING.get(indexSettings);
        String indexExclude = (String)INDEX_ROUTING_EXCLUDE_SETTING.get(indexSettings);
        if (Strings.hasText((String)indexRequire) && !DataTierAllocationDecider.allocationAllowed(OpType.AND, indexRequire, roles)) {
            return allocation.decision(Decision.NO, NAME, "node does not match all index setting [%s] tier filters [%s]", new Object[]{INDEX_ROUTING_REQUIRE, indexRequire});
        }
        if (Strings.hasText((String)indexInclude) && !DataTierAllocationDecider.allocationAllowed(OpType.OR, indexInclude, roles)) {
            return allocation.decision(Decision.NO, NAME, "node does not match any index setting [%s] tier filters [%s]", new Object[]{INDEX_ROUTING_INCLUDE, indexInclude});
        }
        if (Strings.hasText((String)indexExclude) && DataTierAllocationDecider.allocationAllowed(OpType.OR, indexExclude, roles)) {
            return allocation.decision(Decision.NO, NAME, "node matches any index setting [%s] tier filters [%s]", new Object[]{INDEX_ROUTING_EXCLUDE, indexExclude});
        }
        return null;
    }

    private Decision shouldClusterFilter(Set<DiscoveryNodeRole> roles, RoutingAllocation allocation) {
        if (Strings.hasText((String)this.clusterRequire) && !DataTierAllocationDecider.allocationAllowed(OpType.AND, this.clusterRequire, roles)) {
            return allocation.decision(Decision.NO, NAME, "node does not match all cluster setting [%s] tier filters [%s]", new Object[]{CLUSTER_ROUTING_REQUIRE, this.clusterRequire});
        }
        if (Strings.hasText((String)this.clusterInclude) && !DataTierAllocationDecider.allocationAllowed(OpType.OR, this.clusterInclude, roles)) {
            return allocation.decision(Decision.NO, NAME, "node does not match any cluster setting [%s] tier filters [%s]", new Object[]{CLUSTER_ROUTING_INCLUDE, this.clusterInclude});
        }
        if (Strings.hasText((String)this.clusterExclude) && DataTierAllocationDecider.allocationAllowed(OpType.OR, this.clusterExclude, roles)) {
            return allocation.decision(Decision.NO, NAME, "node matches any cluster setting [%s] tier filters [%s]", new Object[]{CLUSTER_ROUTING_EXCLUDE, this.clusterExclude});
        }
        return null;
    }

    public static Optional<String> preferredAvailableTier(List<String> prioritizedTiers, DiscoveryNodes nodes) {
        for (String tier : prioritizedTiers) {
            if (!DataTierAllocationDecider.tierNodesPresent(tier, nodes)) continue;
            return Optional.of(tier);
        }
        return Optional.empty();
    }

    static boolean tierNodesPresent(String singleTier, DiscoveryNodes nodes) {
        assert (singleTier.equals(DiscoveryNodeRole.DATA_ROLE.roleName()) || DataTier.validTierName((String)singleTier)) : "tier " + singleTier + " is an invalid tier name";
        for (DiscoveryNode node : nodes.getNodes().values()) {
            for (DiscoveryNodeRole discoveryNodeRole : node.getRoles()) {
                String s = discoveryNodeRole.roleName();
                if (!s.equals(DiscoveryNodeRole.DATA_ROLE.roleName()) && !s.equals(singleTier)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean allocationAllowed(OpType opType, String tierSetting, Set<DiscoveryNodeRole> roles) {
        assert (Strings.hasText((String)tierSetting)) : "tierName must be not null and non-empty, but was [" + tierSetting + "]";
        if (roles.contains(DiscoveryNodeRole.DATA_ROLE)) {
            return true;
        }
        List values = DataTier.parseTierList((String)tierSetting);
        for (String tierName : values) {
            boolean containsName = false;
            for (DiscoveryNodeRole role : roles) {
                if (!tierName.equals(role.roleName())) continue;
                containsName = true;
                break;
            }
            if (containsName) {
                if (opType != OpType.OR) continue;
                return true;
            }
            if (opType != OpType.AND) continue;
            return false;
        }
        return opType == OpType.AND;
    }

    private static boolean allocationAllowed(String tierName, Set<DiscoveryNodeRole> roles) {
        assert (Strings.hasText((String)tierName)) : "tierName must be not null and non-empty, but was [" + tierName + "]";
        if (roles.contains(DiscoveryNodeRole.DATA_ROLE)) {
            return true;
        }
        for (DiscoveryNodeRole role : roles) {
            if (!tierName.equals(role.roleName())) continue;
            return true;
        }
        return false;
    }

    public static interface PreferredTierFunction {
        public Optional<String> apply(List<String> var1, DiscoveryNodes var2);
    }

    private static enum OpType {
        AND,
        OR;

    }
}

