/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms.pivot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.script.Script;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class ScriptConfig
extends AbstractDiffable<ScriptConfig>
implements Writeable,
ToXContentObject {
    private static final Logger logger = LogManager.getLogger(ScriptConfig.class);
    private final Map<String, Object> source;
    private final Script script;

    public ScriptConfig(Map<String, Object> source, Script script) {
        this.source = source;
        this.script = script;
    }

    public ScriptConfig(StreamInput in) throws IOException {
        this.source = in.readMap();
        this.script = (Script)in.readOptionalWriteable(Script::new);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.map(this.source);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.source);
        out.writeOptionalWriteable((Writeable)this.script);
    }

    public Script getScript() {
        return this.script;
    }

    public static ScriptConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        NamedXContentRegistry registry = parser.getXContentRegistry();
        Map source = parser.mapOrdered();
        Script script = null;
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(source);
             XContentParser sourceParser = XContentType.JSON.xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)BytesReference.bytes((XContentBuilder)xContentBuilder).streamInput());){
            script = Script.parse((XContentParser)sourceParser);
        }
        catch (Exception e) {
            if (lenient) {
                logger.warn("Failed to parse script for transform", (Throwable)e);
            }
            throw e;
        }
        return new ScriptConfig(source, script);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.script);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        ScriptConfig that = (ScriptConfig)((Object)other);
        return Objects.equals(this.source, that.source) && Objects.equals(this.script, that.script);
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.script == null) {
            validationException = ValidateActions.addValidationError((String)"script must not be null", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

