/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.processor;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.processor.UnaryProcessor;

public class ChainingProcessor
extends UnaryProcessor {
    public static final String NAME = ".";
    private final Processor processor;

    public ChainingProcessor(Processor first, Processor second) {
        super(first);
        this.processor = second;
    }

    public ChainingProcessor(StreamInput in) throws IOException {
        super(in);
        this.processor = (Processor)in.readNamedWriteable(Processor.class);
    }

    @Override
    protected void doWrite(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.processor);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Object doProcess(Object input) {
        return this.processor.process(input);
    }

    Processor first() {
        return this.child();
    }

    Processor second() {
        return this.processor;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.processor);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.processor, ((ChainingProcessor)obj).processor);
    }

    @Override
    public String toString() {
        return this.processor + "(" + super.toString() + ")";
    }
}

