/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.operator.comparison;

import java.util.Set;

public final class Comparisons {
    private Comparisons() {
    }

    public static Boolean eq(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i == 0);
    }

    public static boolean nulleq(Object l, Object r) {
        if (l == null && r == null) {
            return true;
        }
        Integer i = Comparisons.compare(l, r);
        return i == null ? false : i == 0;
    }

    static Boolean neq(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i != 0);
    }

    public static Boolean lt(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i < 0);
    }

    static Boolean lte(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i <= 0);
    }

    public static Boolean gt(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i > 0);
    }

    static Boolean gte(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i >= 0);
    }

    static Boolean in(Object l, Set<Object> r) {
        return r.contains(l);
    }

    static Integer compare(Object l, Object r) {
        if (l == null || r == null) {
            return null;
        }
        if (l instanceof Number && r instanceof Number) {
            return Comparisons.compare((Number)l, (Number)r);
        }
        if (l instanceof Comparable && r instanceof Comparable) {
            try {
                return ((Comparable)l).compareTo(r);
            }
            catch (ClassCastException cce) {
                return null;
            }
        }
        return null;
    }

    private static Integer compare(Number l, Number r) {
        if (l instanceof Double || r instanceof Double) {
            return Double.compare(l.doubleValue(), r.doubleValue());
        }
        if (l instanceof Float || r instanceof Float) {
            return Float.compare(l.floatValue(), r.floatValue());
        }
        if (l instanceof Long || r instanceof Long) {
            return Long.compare(l.longValue(), r.longValue());
        }
        return Integer.compare(l.intValue(), r.intValue());
    }
}

