/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.sql.JDBCType;
import java.sql.SQLType;
import java.time.OffsetTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.sql.expression.literal.geo.GeoShape;
import org.elasticsearch.xpack.sql.expression.literal.interval.Interval;
import org.elasticsearch.xpack.sql.expression.literal.interval.Intervals;
import org.elasticsearch.xpack.sql.type.ExtTypes;

public class SqlDataTypes {
    public static final DataType DATE = new DataType("DATE", null, 8, false, false, true);
    public static final DataType TIME = new DataType("TIME", null, 8, false, false, true);
    public static final DataType INTERVAL_YEAR = new DataType("INTERVAL_YEAR", null, 4, false, false, false);
    public static final DataType INTERVAL_MONTH = new DataType("INTERVAL_MONTH", null, 4, false, false, false);
    public static final DataType INTERVAL_DAY = new DataType("INTERVAL_DAY", null, 8, false, false, false);
    public static final DataType INTERVAL_HOUR = new DataType("INTERVAL_HOUR", null, 8, false, false, false);
    public static final DataType INTERVAL_MINUTE = new DataType("INTERVAL_MINUTE", null, 8, false, false, false);
    public static final DataType INTERVAL_SECOND = new DataType("INTERVAL_SECOND", null, 8, false, false, false);
    public static final DataType INTERVAL_YEAR_TO_MONTH = new DataType("INTERVAL_YEAR_TO_MONTH", null, 4, false, false, false);
    public static final DataType INTERVAL_DAY_TO_HOUR = new DataType("INTERVAL_DAY_TO_HOUR", null, 8, false, false, false);
    public static final DataType INTERVAL_DAY_TO_MINUTE = new DataType("INTERVAL_DAY_TO_MINUTE", null, 8, false, false, false);
    public static final DataType INTERVAL_DAY_TO_SECOND = new DataType("INTERVAL_DAY_TO_SECOND", null, 8, false, false, false);
    public static final DataType INTERVAL_HOUR_TO_MINUTE = new DataType("INTERVAL_HOUR_TO_MINUTE", null, 8, false, false, false);
    public static final DataType INTERVAL_HOUR_TO_SECOND = new DataType("INTERVAL_HOUR_TO_SECOND", null, 8, false, false, false);
    public static final DataType INTERVAL_MINUTE_TO_SECOND = new DataType("INTERVAL_MINUTE_TO_SECOND", null, 8, false, false, false);
    public static final DataType GEO_SHAPE = new DataType("geo_shape", Integer.MAX_VALUE, false, false, false);
    public static final DataType GEO_POINT = new DataType("geo_point", 16, false, false, false);
    public static final DataType SHAPE = new DataType("shape", Integer.MAX_VALUE, false, false, false);
    private static final Map<String, DataType> ODBC_TO_ES = new HashMap<String, DataType>(CollectionUtils.mapSize((int)38));
    private static final Collection<DataType> TYPES;
    private static final Map<String, DataType> NAME_TO_TYPE;
    private static final Map<String, DataType> ES_TO_TYPE;
    private static final Map<String, DataType> SQL_TO_ES;

    private SqlDataTypes() {
    }

    public static Collection<DataType> types() {
        return TYPES;
    }

    public static DataType fromTypeName(String name) {
        return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
    }

    public static DataType fromEs(String name) {
        DataType type = ES_TO_TYPE.get(name);
        return type != null ? type : DataTypes.UNSUPPORTED;
    }

    public static DataType fromJava(Object value) {
        DataType type = DataTypes.fromJava((Object)value);
        if (type != null) {
            return type;
        }
        if (value instanceof OffsetTime) {
            return TIME;
        }
        if (value instanceof Interval) {
            return ((Interval)value).dataType();
        }
        if (value instanceof GeoShape) {
            return GEO_SHAPE;
        }
        return null;
    }

    public static boolean isNullOrInterval(DataType type) {
        return type == DataTypes.NULL || SqlDataTypes.isInterval(type);
    }

    public static boolean isInterval(DataType dataType) {
        return SqlDataTypes.isYearMonthInterval(dataType) || SqlDataTypes.isDayTimeInterval(dataType);
    }

    public static boolean isYearMonthInterval(DataType dataType) {
        return dataType == INTERVAL_YEAR || dataType == INTERVAL_MONTH || dataType == INTERVAL_YEAR_TO_MONTH;
    }

    public static boolean isDayTimeInterval(DataType dataType) {
        return dataType == INTERVAL_DAY || dataType == INTERVAL_HOUR || dataType == INTERVAL_MINUTE || dataType == INTERVAL_SECOND || dataType == INTERVAL_DAY_TO_HOUR || dataType == INTERVAL_DAY_TO_MINUTE || dataType == INTERVAL_DAY_TO_SECOND || dataType == INTERVAL_HOUR_TO_MINUTE || dataType == INTERVAL_HOUR_TO_SECOND || dataType == INTERVAL_MINUTE_TO_SECOND;
    }

    public static boolean isDateBased(DataType type) {
        return DataTypes.isDateTime((DataType)type) || type == DATE;
    }

    public static boolean isTimeBased(DataType type) {
        return type == TIME;
    }

    public static boolean isDateOrTimeBased(DataType type) {
        return SqlDataTypes.isDateBased(type) || SqlDataTypes.isTimeBased(type);
    }

    public static boolean isDateOrIntervalBased(DataType type) {
        return SqlDataTypes.isDateBased(type) || SqlDataTypes.isInterval(type);
    }

    public static boolean isGeo(DataType type) {
        return type == GEO_POINT || type == GEO_SHAPE || type == SHAPE;
    }

    public static String format(DataType type) {
        return SqlDataTypes.isDateOrTimeBased(type) ? "strict_date_optional_time_nanos" : null;
    }

    public static boolean isFromDocValuesOnly(DataType dataType) {
        return dataType == DataTypes.KEYWORD || dataType == DATE || dataType == DataTypes.DATETIME || dataType == DataTypes.SCALED_FLOAT || dataType == GEO_POINT || dataType == SHAPE;
    }

    public static boolean areCompatible(DataType left, DataType right) {
        if (left == right) {
            return true;
        }
        return left == DataTypes.NULL || right == DataTypes.NULL || DataTypes.isString((DataType)left) && DataTypes.isString((DataType)right) || left.isNumeric() && right.isNumeric() || SqlDataTypes.isDateBased(left) && SqlDataTypes.isDateBased(right) || SqlDataTypes.isInterval(left) && SqlDataTypes.isDateBased(right) || SqlDataTypes.isDateBased(left) && SqlDataTypes.isInterval(right) || SqlDataTypes.isInterval(left) && SqlDataTypes.isInterval(right) && Intervals.compatibleInterval(left, right) != null;
    }

    public static DataType fromOdbcType(String odbcType) {
        return ODBC_TO_ES.get(odbcType);
    }

    public static DataType fromSqlOrEsType(String typeName) {
        return SQL_TO_ES.get(typeName.toUpperCase(Locale.ROOT));
    }

    public static SQLType sqlType(DataType dataType) {
        if (dataType == DataTypes.UNSUPPORTED) {
            return JDBCType.OTHER;
        }
        if (dataType == DataTypes.NULL) {
            return JDBCType.NULL;
        }
        if (dataType == DataTypes.BOOLEAN) {
            return JDBCType.BOOLEAN;
        }
        if (dataType == DataTypes.BYTE) {
            return JDBCType.TINYINT;
        }
        if (dataType == DataTypes.SHORT) {
            return JDBCType.SMALLINT;
        }
        if (dataType == DataTypes.INTEGER) {
            return JDBCType.INTEGER;
        }
        if (dataType == DataTypes.LONG) {
            return JDBCType.BIGINT;
        }
        if (dataType == DataTypes.DOUBLE) {
            return JDBCType.DOUBLE;
        }
        if (dataType == DataTypes.FLOAT) {
            return JDBCType.REAL;
        }
        if (dataType == DataTypes.HALF_FLOAT) {
            return JDBCType.FLOAT;
        }
        if (dataType == DataTypes.SCALED_FLOAT) {
            return JDBCType.DOUBLE;
        }
        if (dataType == DataTypes.KEYWORD) {
            return JDBCType.VARCHAR;
        }
        if (dataType == DataTypes.TEXT) {
            return JDBCType.VARCHAR;
        }
        if (DataTypes.isDateTime((DataType)dataType)) {
            return JDBCType.TIMESTAMP;
        }
        if (dataType == DataTypes.IP) {
            return JDBCType.VARCHAR;
        }
        if (dataType == DataTypes.BINARY) {
            return JDBCType.BINARY;
        }
        if (dataType == DataTypes.OBJECT) {
            return JDBCType.STRUCT;
        }
        if (dataType == DataTypes.NESTED) {
            return JDBCType.STRUCT;
        }
        if (dataType == DATE) {
            return JDBCType.DATE;
        }
        if (dataType == TIME) {
            return JDBCType.TIME;
        }
        if (dataType == GEO_SHAPE) {
            return ExtTypes.GEOMETRY;
        }
        if (dataType == GEO_POINT) {
            return ExtTypes.GEOMETRY;
        }
        if (dataType == SHAPE) {
            return ExtTypes.GEOMETRY;
        }
        if (dataType == INTERVAL_YEAR) {
            return ExtTypes.INTERVAL_YEAR;
        }
        if (dataType == INTERVAL_MONTH) {
            return ExtTypes.INTERVAL_MONTH;
        }
        if (dataType == INTERVAL_DAY) {
            return ExtTypes.INTERVAL_DAY;
        }
        if (dataType == INTERVAL_HOUR) {
            return ExtTypes.INTERVAL_HOUR;
        }
        if (dataType == INTERVAL_MINUTE) {
            return ExtTypes.INTERVAL_MINUTE;
        }
        if (dataType == INTERVAL_SECOND) {
            return ExtTypes.INTERVAL_SECOND;
        }
        if (dataType == INTERVAL_YEAR_TO_MONTH) {
            return ExtTypes.INTERVAL_YEAR_TO_MONTH;
        }
        if (dataType == INTERVAL_DAY_TO_HOUR) {
            return ExtTypes.INTERVAL_DAY_TO_HOUR;
        }
        if (dataType == INTERVAL_DAY_TO_MINUTE) {
            return ExtTypes.INTERVAL_DAY_TO_MINUTE;
        }
        if (dataType == INTERVAL_DAY_TO_SECOND) {
            return ExtTypes.INTERVAL_DAY_TO_SECOND;
        }
        if (dataType == INTERVAL_HOUR_TO_MINUTE) {
            return ExtTypes.INTERVAL_HOUR_TO_MINUTE;
        }
        if (dataType == INTERVAL_HOUR_TO_SECOND) {
            return ExtTypes.INTERVAL_HOUR_TO_SECOND;
        }
        if (dataType == INTERVAL_MINUTE_TO_SECOND) {
            return ExtTypes.INTERVAL_MINUTE_TO_SECOND;
        }
        return null;
    }

    public static int defaultPrecision(DataType dataType) {
        if (dataType == DataTypes.UNSUPPORTED) {
            return dataType.size();
        }
        if (dataType == DataTypes.NULL) {
            return dataType.size();
        }
        if (dataType == DataTypes.BOOLEAN) {
            return dataType.size();
        }
        if (dataType == DataTypes.BYTE) {
            return 3;
        }
        if (dataType == DataTypes.SHORT) {
            return 5;
        }
        if (dataType == DataTypes.INTEGER) {
            return 10;
        }
        if (dataType == DataTypes.LONG) {
            return 19;
        }
        if (dataType == DataTypes.DOUBLE) {
            return 15;
        }
        if (dataType == DataTypes.FLOAT) {
            return 7;
        }
        if (dataType == DataTypes.HALF_FLOAT) {
            return 3;
        }
        if (dataType == DataTypes.SCALED_FLOAT) {
            return 15;
        }
        if (dataType == DataTypes.KEYWORD) {
            return 15;
        }
        if (dataType == DataTypes.TEXT) {
            return 32766;
        }
        if (DataTypes.isDateTime((DataType)dataType)) {
            return 9;
        }
        if (dataType == DataTypes.IP) {
            return dataType.size();
        }
        if (dataType == DataTypes.BINARY) {
            return dataType.size();
        }
        if (dataType == DataTypes.OBJECT) {
            return dataType.size();
        }
        if (dataType == DataTypes.NESTED) {
            return dataType.size();
        }
        if (dataType == DATE) {
            return 3;
        }
        if (dataType == TIME) {
            return 9;
        }
        if (dataType == GEO_SHAPE) {
            return dataType.size();
        }
        if (dataType == GEO_POINT) {
            return Integer.MAX_VALUE;
        }
        if (dataType == SHAPE) {
            return dataType.size();
        }
        if (dataType == INTERVAL_YEAR) {
            return 7;
        }
        if (dataType == INTERVAL_MONTH) {
            return 7;
        }
        if (dataType == INTERVAL_DAY) {
            return 23;
        }
        if (dataType == INTERVAL_HOUR) {
            return 23;
        }
        if (dataType == INTERVAL_MINUTE) {
            return 23;
        }
        if (dataType == INTERVAL_SECOND) {
            return 23;
        }
        if (dataType == INTERVAL_YEAR_TO_MONTH) {
            return 7;
        }
        if (dataType == INTERVAL_DAY_TO_HOUR) {
            return 23;
        }
        if (dataType == INTERVAL_DAY_TO_MINUTE) {
            return 23;
        }
        if (dataType == INTERVAL_DAY_TO_SECOND) {
            return 23;
        }
        if (dataType == INTERVAL_HOUR_TO_MINUTE) {
            return 23;
        }
        if (dataType == INTERVAL_HOUR_TO_SECOND) {
            return 23;
        }
        if (dataType == INTERVAL_MINUTE_TO_SECOND) {
            return 23;
        }
        return 0;
    }

    public static int displaySize(DataType dataType) {
        if (dataType == DataTypes.UNSUPPORTED) {
            return dataType.size();
        }
        if (dataType == DataTypes.NULL) {
            return dataType.size();
        }
        if (dataType == DataTypes.BOOLEAN) {
            return dataType.size();
        }
        if (dataType == DataTypes.BYTE) {
            return 5;
        }
        if (dataType == DataTypes.SHORT) {
            return 6;
        }
        if (dataType == DataTypes.INTEGER) {
            return 11;
        }
        if (dataType == DataTypes.LONG) {
            return 20;
        }
        if (dataType == DataTypes.DOUBLE) {
            return 25;
        }
        if (dataType == DataTypes.FLOAT) {
            return 15;
        }
        if (dataType == DataTypes.HALF_FLOAT) {
            return 25;
        }
        if (dataType == DataTypes.SCALED_FLOAT) {
            return 25;
        }
        if (dataType == DataTypes.KEYWORD) {
            return 32766;
        }
        if (dataType == DataTypes.TEXT) {
            return dataType.size();
        }
        if (DataTypes.isDateTime((DataType)dataType)) {
            return 34;
        }
        if (dataType == DataTypes.IP) {
            return dataType.size();
        }
        if (dataType == DataTypes.BINARY) {
            return dataType.size();
        }
        if (dataType == DataTypes.OBJECT) {
            return dataType.size();
        }
        if (dataType == DataTypes.NESTED) {
            return dataType.size();
        }
        if (dataType == DATE) {
            return 29;
        }
        if (dataType == TIME) {
            return 24;
        }
        if (dataType == GEO_SHAPE) {
            return dataType.size();
        }
        if (dataType == GEO_POINT) {
            return 58;
        }
        if (dataType == SHAPE) {
            return dataType.size();
        }
        if (SqlDataTypes.isInterval(dataType)) {
            return SqlDataTypes.defaultPrecision(dataType);
        }
        return 0;
    }

    public static Integer metaSqlDataType(DataType t) {
        if (DataTypes.isDateTime((DataType)t)) {
            return 9;
        }
        return SqlDataTypes.sqlType(t).getVendorTypeNumber();
    }

    public static Integer metaSqlDateTimeSub(DataType t) {
        if (DataTypes.isDateTime((DataType)t)) {
            return 3;
        }
        if (t == DATE) {
            return 1;
        }
        if (t == TIME) {
            return 2;
        }
        return 0;
    }

    public static Short metaSqlMinimumScale(DataType t) {
        return SqlDataTypes.metaSqlSameScale(t);
    }

    public static Short metaSqlMaximumScale(DataType t) {
        return SqlDataTypes.metaSqlSameScale(t);
    }

    private static Short metaSqlSameScale(DataType t) {
        if (t.isInteger()) {
            return (short)0;
        }
        if (DataTypes.isDateTime((DataType)t) || t == TIME || t.isRational()) {
            return (short)SqlDataTypes.defaultPrecision(t);
        }
        return null;
    }

    public static Integer metaSqlRadix(DataType t) {
        return t.isInteger() ? Integer.valueOf(10) : (t.isRational() ? Integer.valueOf(2) : null);
    }

    public static Integer precision(DataType t) {
        if (t.isNumeric()) {
            return SqlDataTypes.defaultPrecision(t);
        }
        return SqlDataTypes.displaySize(t);
    }

    static {
        ODBC_TO_ES.put("SQL_BIT", DataTypes.BOOLEAN);
        ODBC_TO_ES.put("SQL_TINYINT", DataTypes.BYTE);
        ODBC_TO_ES.put("SQL_SMALLINT", DataTypes.SHORT);
        ODBC_TO_ES.put("SQL_INTEGER", DataTypes.INTEGER);
        ODBC_TO_ES.put("SQL_BIGINT", DataTypes.LONG);
        ODBC_TO_ES.put("SQL_REAL", DataTypes.FLOAT);
        ODBC_TO_ES.put("SQL_FLOAT", DataTypes.DOUBLE);
        ODBC_TO_ES.put("SQL_DOUBLE", DataTypes.DOUBLE);
        ODBC_TO_ES.put("SQL_DECIMAL", DataTypes.DOUBLE);
        ODBC_TO_ES.put("SQL_NUMERIC", DataTypes.DOUBLE);
        ODBC_TO_ES.put("SQL_GUID", DataTypes.KEYWORD);
        ODBC_TO_ES.put("SQL_CHAR", DataTypes.KEYWORD);
        ODBC_TO_ES.put("SQL_WCHAR", DataTypes.KEYWORD);
        ODBC_TO_ES.put("SQL_VARCHAR", DataTypes.TEXT);
        ODBC_TO_ES.put("SQL_WVARCHAR", DataTypes.TEXT);
        ODBC_TO_ES.put("SQL_LONGVARCHAR", DataTypes.TEXT);
        ODBC_TO_ES.put("SQL_WLONGVARCHAR", DataTypes.TEXT);
        ODBC_TO_ES.put("SQL_BINARY", DataTypes.BINARY);
        ODBC_TO_ES.put("SQL_VARBINARY", DataTypes.BINARY);
        ODBC_TO_ES.put("SQL_LONGVARBINARY", DataTypes.BINARY);
        ODBC_TO_ES.put("SQL_DATE", DATE);
        ODBC_TO_ES.put("SQL_TIME", TIME);
        ODBC_TO_ES.put("SQL_TIMESTAMP", DataTypes.DATETIME);
        ODBC_TO_ES.put("SQL_INTERVAL_YEAR", INTERVAL_YEAR);
        ODBC_TO_ES.put("SQL_INTERVAL_MONTH", INTERVAL_MONTH);
        ODBC_TO_ES.put("SQL_INTERVAL_DAY", INTERVAL_DAY);
        ODBC_TO_ES.put("SQL_INTERVAL_HOUR", INTERVAL_HOUR);
        ODBC_TO_ES.put("SQL_INTERVAL_MINUTE", INTERVAL_MINUTE);
        ODBC_TO_ES.put("SQL_INTERVAL_SECOND", INTERVAL_SECOND);
        ODBC_TO_ES.put("SQL_INTERVAL_YEAR_TO_MONTH", INTERVAL_YEAR_TO_MONTH);
        ODBC_TO_ES.put("SQL_INTERVAL_DAY_TO_HOUR", INTERVAL_DAY_TO_HOUR);
        ODBC_TO_ES.put("SQL_INTERVAL_DAY_TO_MINUTE", INTERVAL_DAY_TO_MINUTE);
        ODBC_TO_ES.put("SQL_INTERVAL_DAY_TO_SECOND", INTERVAL_DAY_TO_SECOND);
        ODBC_TO_ES.put("SQL_INTERVAL_HOUR_TO_MINUTE", INTERVAL_HOUR_TO_MINUTE);
        ODBC_TO_ES.put("SQL_INTERVAL_HOUR_TO_SECOND", INTERVAL_HOUR_TO_SECOND);
        ODBC_TO_ES.put("SQL_INTERVAL_MINUTE_TO_SECOND", INTERVAL_MINUTE_TO_SECOND);
        TYPES = Collections.unmodifiableList(Stream.concat(DataTypes.types().stream(), Stream.of(DATE, TIME, INTERVAL_YEAR, INTERVAL_MONTH, INTERVAL_DAY, INTERVAL_HOUR, INTERVAL_MINUTE, INTERVAL_SECOND, INTERVAL_YEAR_TO_MONTH, INTERVAL_DAY_TO_HOUR, INTERVAL_DAY_TO_MINUTE, INTERVAL_DAY_TO_SECOND, INTERVAL_HOUR_TO_MINUTE, INTERVAL_HOUR_TO_SECOND, INTERVAL_MINUTE_TO_SECOND, GEO_SHAPE, GEO_POINT, SHAPE)).sorted(Comparator.comparing(DataType::typeName)).collect(Collectors.toList()));
        NAME_TO_TYPE = Collections.unmodifiableMap(TYPES.stream().collect(Collectors.toMap(DataType::typeName, t -> t)));
        Map<String, DataType> map = TYPES.stream().filter(e -> e.esType() != null).collect(Collectors.toMap(DataType::esType, t -> t));
        map.put("date_nanos", DataTypes.DATETIME);
        ES_TO_TYPE = Collections.unmodifiableMap(map);
        HashMap<String, DataType> sqlToEs = new HashMap<String, DataType>(CollectionUtils.mapSize((int)45));
        for (DataType dataType : SqlDataTypes.types()) {
            if (dataType == DataTypes.OBJECT || dataType == DataTypes.NESTED) continue;
            sqlToEs.put(dataType.typeName().toUpperCase(Locale.ROOT), dataType);
        }
        for (Map.Entry entry : ODBC_TO_ES.entrySet()) {
            sqlToEs.put(((String)entry.getKey()).substring(4), (DataType)entry.getValue());
        }
        sqlToEs.put("BOOL", DataTypes.BOOLEAN);
        sqlToEs.put("INT", DataTypes.INTEGER);
        sqlToEs.put("STRING", DataTypes.KEYWORD);
        SQL_TO_ES = Collections.unmodifiableMap(sqlToEs);
    }
}

