/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum FailedDependencyAction {
    PROCESS("process"),
    CANCEL("cancel"),
    DISABLE("disable");

    private final String name;

    private FailedDependencyAction(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static FailedDependencyAction forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "process": {
                return PROCESS;
            }
            case "cancel": {
                return CANCEL;
            }
            case "disable": {
                return DISABLE;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

