/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetModelSnapshotsAction
extends HandledTransportAction<GetModelSnapshotsAction.Request, GetModelSnapshotsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetModelSnapshotsAction.class);
    private final JobResultsProvider jobResultsProvider;
    private final JobManager jobManager;

    @Inject
    public TransportGetModelSnapshotsAction(TransportService transportService, ActionFilters actionFilters, JobResultsProvider jobResultsProvider, JobManager jobManager) {
        super("cluster:monitor/xpack/ml/job/model_snapshots/get", transportService, actionFilters, GetModelSnapshotsAction.Request::new);
        this.jobResultsProvider = jobResultsProvider;
        this.jobManager = jobManager;
    }

    protected void doExecute(Task task, GetModelSnapshotsAction.Request request, ActionListener<GetModelSnapshotsAction.Response> listener) {
        logger.debug(() -> new ParameterizedMessage("Get model snapshots for job {} snapshot ID {}. from = {}, size = {} start = '{}', end='{}', sort={} descending={}", new Object[]{request.getJobId(), request.getSnapshotId(), request.getPageParams().getFrom(), request.getPageParams().getSize(), request.getStart(), request.getEnd(), request.getSort(), request.getDescOrder()}));
        if (Strings.isAllOrWildcard((String)request.getJobId())) {
            this.getModelSnapshots(request, listener);
            return;
        }
        this.jobManager.jobExists(request.getJobId(), (ActionListener<Boolean>)ActionListener.wrap(ok -> this.getModelSnapshots(request, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void getModelSnapshots(GetModelSnapshotsAction.Request request, ActionListener<GetModelSnapshotsAction.Response> listener) {
        this.jobResultsProvider.modelSnapshots(request.getJobId(), request.getPageParams().getFrom(), request.getPageParams().getSize(), request.getStart(), request.getEnd(), request.getSort(), request.getDescOrder(), request.getSnapshotId(), page -> listener.onResponse((Object)new GetModelSnapshotsAction.Response(page)), arg_0 -> listener.onFailure(arg_0));
    }
}

