/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process.results;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RowResults
implements ToXContentObject {
    public static final ParseField TYPE = new ParseField("row_results", new String[0]);
    public static final ParseField CHECKSUM = new ParseField("checksum", new String[0]);
    public static final ParseField RESULTS = new ParseField("results", new String[0]);
    public static final ConstructingObjectParser<RowResults, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), a -> new RowResults((Integer)a[0], (Map)a[1]));
    private final int checksum;
    private final Map<String, Object> results;

    public RowResults(int checksum, Map<String, Object> results) {
        this.checksum = Objects.requireNonNull(checksum);
        this.results = Objects.requireNonNull(results);
    }

    public int getChecksum() {
        return this.checksum;
    }

    public Map<String, Object> getResults() {
        return this.results;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CHECKSUM.getPreferredName(), this.checksum);
        builder.field(RESULTS.getPreferredName(), this.results);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RowResults that = (RowResults)other;
        return this.checksum == that.checksum && Objects.equals(this.results, that.results);
    }

    public int hashCode() {
        return Objects.hash(this.checksum, this.results);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), CHECKSUM);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, context) -> p.map(), RESULTS);
    }
}

