/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.utils.Intervals;
import org.elasticsearch.xpack.ml.job.categorization.CategorizationAnalyzer;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.CannotParseTimestampException;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DataToProcessWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DateFormatDateTransformer;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DateTransformer;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DoubleDateTransformer;
import org.supercsv.encoder.DefaultCsvEncoder;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;

public abstract class AbstractDataToProcessWriter
implements DataToProcessWriter {
    private static final int TIME_FIELD_OUT_INDEX = 0;
    private static final long MS_IN_SECOND = 1000L;
    private final boolean includeControlField;
    private final boolean includeTokensField;
    protected final AutodetectProcess autodetectProcess;
    protected final DataDescription dataDescription;
    protected final AnalysisConfig analysisConfig;
    protected final DataCountsReporter dataCountsReporter;
    private final Logger logger;
    private final DateTransformer dateTransformer;
    private final long bucketSpanMs;
    private final long latencySeconds;
    protected Map<String, Integer> inFieldIndexes;
    protected List<InputOutputMap> inputOutputMap;
    private long latestEpochMs;
    private long latestEpochMsThisUpload;
    private Set<String> termFields;

    protected AbstractDataToProcessWriter(boolean includeControlField, boolean includeTokensField, AutodetectProcess autodetectProcess, DataDescription dataDescription, AnalysisConfig analysisConfig, DataCountsReporter dataCountsReporter, Logger logger) {
        this.includeControlField = includeControlField;
        this.includeTokensField = includeTokensField;
        this.autodetectProcess = Objects.requireNonNull(autodetectProcess);
        this.dataDescription = Objects.requireNonNull(dataDescription);
        this.analysisConfig = Objects.requireNonNull(analysisConfig);
        this.dataCountsReporter = Objects.requireNonNull(dataCountsReporter);
        this.logger = Objects.requireNonNull(logger);
        this.latencySeconds = analysisConfig.getLatency() == null ? 0L : analysisConfig.getLatency().seconds();
        this.bucketSpanMs = analysisConfig.getBucketSpan().getMillis();
        this.termFields = analysisConfig.termFields();
        Date date = dataCountsReporter.getLatestRecordTime();
        this.latestEpochMsThisUpload = 0L;
        this.latestEpochMs = 0L;
        if (date != null) {
            this.latestEpochMs = date.getTime();
        }
        boolean isDateFormatString = dataDescription.isTransformTime() && !dataDescription.isEpochMs();
        this.dateTransformer = isDateFormatString ? new DateFormatDateTransformer(dataDescription.getTimeFormat()) : new DoubleDateTransformer(dataDescription.isEpochMs());
    }

    public String maybeTruncateCatgeorizationField(String categorizationField) {
        if (!this.termFields.contains(this.analysisConfig.getCategorizationFieldName())) {
            return categorizationField.substring(0, Math.min(categorizationField.length(), 1001));
        }
        return categorizationField;
    }

    void buildFieldIndexMapping(String[] header) {
        Collection<String> inputFields = this.inputFields();
        this.inFieldIndexes = this.inputFieldIndexes(header, inputFields);
        this.checkForMissingFields(inputFields, this.inFieldIndexes, header);
        this.inputOutputMap = this.createInputOutputMap(this.inFieldIndexes);
        this.dataCountsReporter.setAnalysedFieldsPerRecord(this.inputFields().size() - 1);
    }

    @Override
    public void writeHeader() throws IOException {
        Map<String, Integer> outFieldIndexes = this.outputFieldIndexes();
        int numFields = outFieldIndexes.size();
        String[] record = new String[numFields];
        for (Map.Entry<String, Integer> entry : outFieldIndexes.entrySet()) {
            record[entry.getValue().intValue()] = entry.getKey();
        }
        this.autodetectProcess.writeRecord(record);
    }

    protected void tokenizeForCategorization(CategorizationAnalyzer categorizationAnalyzer, String categorizationFieldValue, String[] record) {
        assert (this.includeTokensField);
        record[record.length - 2] = AbstractDataToProcessWriter.tokenizeForCategorization(categorizationAnalyzer, this.analysisConfig.getCategorizationFieldName(), categorizationFieldValue);
    }

    static String tokenizeForCategorization(CategorizationAnalyzer categorizationAnalyzer, String categorizationFieldName, String categorizationFieldValue) {
        StringBuilder builder = new StringBuilder();
        CsvContext context = new CsvContext(0, 0, 0);
        DefaultCsvEncoder encoder = new DefaultCsvEncoder();
        boolean first = true;
        for (String token : categorizationAnalyzer.tokenizeField(categorizationFieldName, categorizationFieldValue)) {
            if (first) {
                first = false;
            } else {
                builder.appendCodePoint(CsvPreference.STANDARD_PREFERENCE.getDelimiterChar());
            }
            builder.append(encoder.encode(token, context, CsvPreference.STANDARD_PREFERENCE));
        }
        return builder.toString();
    }

    protected boolean transformTimeAndWrite(String[] record, long numberOfFieldsRead) throws IOException {
        long epochMs;
        try {
            epochMs = this.dateTransformer.transform(record[0]);
        }
        catch (CannotParseTimestampException e) {
            this.dataCountsReporter.reportDateParseError(numberOfFieldsRead);
            this.logger.error(e.getMessage());
            return false;
        }
        record[0] = Long.toString(epochMs / 1000L);
        long latestBucketFloor = Intervals.alignToFloor((long)this.latestEpochMs, (long)this.bucketSpanMs);
        if (epochMs / 1000L < latestBucketFloor / 1000L - this.latencySeconds) {
            this.dataCountsReporter.reportOutOfOrderRecord(numberOfFieldsRead);
            if (epochMs > this.latestEpochMsThisUpload) {
                this.latestEpochMsThisUpload = epochMs;
                this.dataCountsReporter.reportLatestTimeIncrementalStats(this.latestEpochMsThisUpload);
            }
            return false;
        }
        this.latestEpochMsThisUpload = this.latestEpochMs = Math.max(this.latestEpochMs, epochMs);
        this.autodetectProcess.writeRecord(record);
        this.dataCountsReporter.reportRecordWritten(numberOfFieldsRead, epochMs, this.latestEpochMs);
        return true;
    }

    @Override
    public void flushStream() throws IOException {
        this.autodetectProcess.flushStream();
    }

    final Collection<String> inputFields() {
        Set requiredFields = this.analysisConfig.analysisFields();
        requiredFields.add(this.dataDescription.getTimeField());
        requiredFields.remove("mlcategory");
        return requiredFields;
    }

    protected final Map<String, Integer> inputFieldIndexes(String[] header, Collection<String> inputFields) {
        List<String> headerList = Arrays.asList(header);
        HashMap<String, Integer> fieldIndexes = new HashMap<String, Integer>();
        for (String field : inputFields) {
            int index = headerList.indexOf(field);
            if (index < 0) continue;
            fieldIndexes.put(field, index);
        }
        return fieldIndexes;
    }

    Map<String, Integer> getInputFieldIndexes() {
        return this.inFieldIndexes;
    }

    protected final Map<String, Integer> outputFieldIndexes() {
        HashMap<String, Integer> fieldIndexes = new HashMap<String, Integer>();
        fieldIndexes.put(this.dataDescription.getTimeField(), 0);
        int index = 1;
        for (String field : this.analysisConfig.analysisFields()) {
            if ("mlcategory".equals(field)) continue;
            fieldIndexes.put(field, index++);
        }
        if (this.includeTokensField) {
            fieldIndexes.put("...", index++);
        }
        if (this.includeControlField) {
            fieldIndexes.put(".", index++);
        }
        return fieldIndexes;
    }

    protected int outputFieldCount() {
        return this.inputFields().size() + (this.includeControlField ? 1 : 0) + (this.includeTokensField ? 1 : 0);
    }

    private List<InputOutputMap> createInputOutputMap(Map<String, Integer> inFieldIndexes) {
        ArrayList<InputOutputMap> inputOutputMap = new ArrayList<InputOutputMap>();
        int outIndex = 0;
        Integer inIndex = inFieldIndexes.get(this.dataDescription.getTimeField());
        if (inIndex == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Input time field '%s' not found", this.dataDescription.getTimeField()));
        }
        inputOutputMap.add(new InputOutputMap(inIndex, outIndex));
        for (String field : this.analysisConfig.analysisFields()) {
            if ("mlcategory".equals(field)) continue;
            ++outIndex;
            inIndex = inFieldIndexes.get(field);
            if (inIndex == null) continue;
            inputOutputMap.add(new InputOutputMap(inIndex, outIndex));
        }
        return inputOutputMap;
    }

    protected List<InputOutputMap> getInputOutputMap() {
        return this.inputOutputMap;
    }

    protected abstract boolean checkForMissingFields(Collection<String> var1, Map<String, Integer> var2, String[] var3);

    protected static class InputOutputMap {
        int inputIndex;
        int outputIndex;

        public InputOutputMap(int in, int out) {
            this.inputIndex = in;
            this.outputIndex = out;
        }
    }
}

