/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.categorization.CategorizationAnalyzer;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.AbstractDataToProcessWriter;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

class CsvDataToProcessWriter
extends AbstractDataToProcessWriter {
    private static final Logger LOGGER = LogManager.getLogger(CsvDataToProcessWriter.class);
    private static final int MAX_LINES_PER_RECORD = 10000;

    CsvDataToProcessWriter(boolean includeControlField, boolean includeTokensField, AutodetectProcess autodetectProcess, DataDescription dataDescription, AnalysisConfig analysisConfig, DataCountsReporter dataCountsReporter) {
        super(includeControlField, includeTokensField, autodetectProcess, dataDescription, analysisConfig, dataCountsReporter, LOGGER);
    }

    @Override
    public void write(InputStream inputStream, CategorizationAnalyzer categorizationAnalyzer, XContentType xContentType, BiConsumer<DataCounts, Exception> handler) throws IOException {
        CsvPreference csvPref = new CsvPreference.Builder(this.dataDescription.getQuoteCharacter().charValue(), (int)this.dataDescription.getFieldDelimiter().charValue(), new String(new char[]{'\n'})).maxLinesPerRow(10000).build();
        this.dataCountsReporter.startNewIncrementalCount();
        try (CsvListReader csvReader = new CsvListReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), csvPref);){
            List line;
            String[] header = csvReader.getHeader(true);
            if (header == null) {
                handler.accept(this.dataCountsReporter.incrementalStats(), null);
                return;
            }
            long inputFieldCount = Math.max(header.length - 1, 0);
            this.buildFieldIndexMapping(header);
            int maxIndex = 0;
            for (Integer index : this.inFieldIndexes.values()) {
                maxIndex = Math.max(index, maxIndex);
            }
            Integer categorizationFieldIndex = (Integer)this.inFieldIndexes.get(this.analysisConfig.getCategorizationFieldName());
            int numFields = this.outputFieldCount();
            Object[] record = new String[numFields];
            while ((line = csvReader.read()) != null) {
                String field;
                Arrays.fill(record, "");
                if (maxIndex >= line.size()) {
                    LOGGER.warn("Not enough fields in csv record, expected at least " + maxIndex + ". " + line);
                    for (AbstractDataToProcessWriter.InputOutputMap inOut : this.inputOutputMap) {
                        if (inOut.inputIndex >= line.size()) {
                            this.dataCountsReporter.reportMissingField();
                            continue;
                        }
                        field = (String)line.get(inOut.inputIndex);
                        record[inOut.outputIndex] = field == null ? "" : field;
                    }
                } else {
                    for (AbstractDataToProcessWriter.InputOutputMap inOut : this.inputOutputMap) {
                        field = (String)line.get(inOut.inputIndex);
                        record[inOut.outputIndex] = field == null ? "" : field;
                    }
                }
                if (categorizationAnalyzer != null && categorizationFieldIndex != null && categorizationFieldIndex < line.size()) {
                    this.tokenizeForCategorization(categorizationAnalyzer, (String)line.get(categorizationFieldIndex), (String[])record);
                }
                this.transformTimeAndWrite((String[])record, inputFieldCount);
            }
            this.dataCountsReporter.finishReporting();
            handler.accept(this.dataCountsReporter.incrementalStats(), null);
        }
    }

    @Override
    protected boolean checkForMissingFields(Collection<String> inputFields, Map<String, Integer> inputFieldIndexes, String[] header) {
        for (String field : inputFields) {
            Integer index;
            if (AnalysisConfig.AUTO_CREATED_FIELDS.contains(field) || (index = inputFieldIndexes.get(field)) != null) continue;
            String msg = String.format(Locale.ROOT, "Field configured for analysis '%s' is not in the CSV header '%s'", field, Arrays.toString(header));
            LOGGER.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return true;
    }
}

