/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.util.Date;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.process.normalizer.Renormalizer;
import org.elasticsearch.xpack.ml.job.process.normalizer.ScoresUpdater;

public class ShortCircuitingRenormalizer
implements Renormalizer {
    private static final Logger logger = LogManager.getLogger(ShortCircuitingRenormalizer.class);
    private final String jobId;
    private final ScoresUpdater scoresUpdater;
    private final ExecutorService executorService;
    private final Semaphore semaphore = new Semaphore(1);
    private AugmentedQuantiles latestQuantilesHolder;
    private Future<?> latestTask;

    public ShortCircuitingRenormalizer(String jobId, ScoresUpdater scoresUpdater, ExecutorService executorService) {
        this.jobId = jobId;
        this.scoresUpdater = scoresUpdater;
        this.executorService = executorService;
    }

    @Override
    public boolean isEnabled() {
        return this.scoresUpdater.getNormalizationWindow() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renormalize(Quantiles quantiles) {
        if (!this.isEnabled()) {
            return;
        }
        ShortCircuitingRenormalizer shortCircuitingRenormalizer = this;
        synchronized (shortCircuitingRenormalizer) {
            this.latestQuantilesHolder = this.latestQuantilesHolder == null ? new AugmentedQuantiles(quantiles, null, new CountDownLatch(1)) : new AugmentedQuantiles(quantiles, this.latestQuantilesHolder.getEvictedTimestamp(), this.latestQuantilesHolder.getLatch());
            this.tryStartWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilIdle() throws InterruptedException {
        Future<?> taskToWaitFor;
        CountDownLatch latch;
        do {
            ShortCircuitingRenormalizer shortCircuitingRenormalizer = this;
            synchronized (shortCircuitingRenormalizer) {
                latch = this.latestQuantilesHolder != null ? this.latestQuantilesHolder.getLatch() : null;
            }
            if (latch != null) {
                latch.await();
            }
            shortCircuitingRenormalizer = this;
            synchronized (shortCircuitingRenormalizer) {
                taskToWaitFor = this.latestTask;
            }
            if (taskToWaitFor == null) continue;
            try {
                taskToWaitFor.get();
            }
            catch (ExecutionException e) {
                logger.error("[" + this.jobId + "] Error propagated from normalization", (Throwable)e);
            }
            catch (CancellationException e) {
                throw new InterruptedException("Normalization cancelled");
            }
        } while (latch != null || taskToWaitFor != null);
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.scoresUpdater.shutdown();
        this.waitUntilIdle();
    }

    private synchronized AugmentedQuantiles getLatestAugmentedQuantilesAndClear() {
        AugmentedQuantiles latest = this.latestQuantilesHolder;
        this.latestQuantilesHolder = null;
        return latest;
    }

    private synchronized boolean tryStartWork() {
        if (this.latestQuantilesHolder == null) {
            return false;
        }
        if (this.semaphore.tryAcquire()) {
            try {
                this.latestTask = this.executorService.submit(this::doRenormalizations);
            }
            catch (RejectedExecutionException e) {
                this.latestQuantilesHolder.getLatch().countDown();
                this.latestQuantilesHolder = null;
                this.latestTask = null;
                this.semaphore.release();
                logger.warn("[{}] Normalization discarded as threadpool is shutting down", (Object)this.jobId);
                return false;
            }
            return true;
        }
        return false;
    }

    private synchronized boolean tryFinishWork() {
        if (this.latestQuantilesHolder != null) {
            return false;
        }
        this.semaphore.release();
        this.latestTask = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRenormalizations() {
        do {
            AugmentedQuantiles latestAugmentedQuantiles = this.getLatestAugmentedQuantilesAndClear();
            assert (latestAugmentedQuantiles != null);
            if (latestAugmentedQuantiles != null) {
                Quantiles latestQuantiles = latestAugmentedQuantiles.getQuantiles();
                CountDownLatch latch = latestAugmentedQuantiles.getLatch();
                try {
                    this.scoresUpdater.update(latestQuantiles.getQuantileState(), latestQuantiles.getTimestamp().getTime(), latestAugmentedQuantiles.getWindowExtensionMs());
                }
                catch (Exception e) {
                    logger.error("[" + this.jobId + "] Normalization failed", (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
            } else {
                logger.warn("[{}] request to normalize null quantiles", (Object)this.jobId);
            }
        } while (!this.tryFinishWork());
    }

    private class AugmentedQuantiles {
        private final Quantiles quantiles;
        private final Date earliestEvictedTimestamp;
        private final CountDownLatch latch;

        AugmentedQuantiles(Quantiles quantiles, Date earliestEvictedTimestamp, CountDownLatch latch) {
            this.quantiles = Objects.requireNonNull(quantiles);
            this.earliestEvictedTimestamp = earliestEvictedTimestamp;
            this.latch = Objects.requireNonNull(latch);
        }

        Quantiles getQuantiles() {
            return this.quantiles;
        }

        Date getEvictedTimestamp() {
            return this.earliestEvictedTimestamp != null ? this.earliestEvictedTimestamp : this.quantiles.getTimestamp();
        }

        long getWindowExtensionMs() {
            if (this.earliestEvictedTimestamp == null) {
                return 0L;
            }
            long earliestTimeMs = this.earliestEvictedTimestamp.getTime();
            long latestTimeMs = this.quantiles.getTimestamp().getTime();
            long windowExtensionMs = latestTimeMs - earliestTimeMs;
            if (windowExtensionMs < 0L) {
                logger.warn("[{}] Quantiles not supplied in time order - {} after {}", (Object)ShortCircuitingRenormalizer.this.jobId, (Object)latestTimeMs, (Object)earliestTimeMs);
                return 0L;
            }
            return windowExtensionMs;
        }

        CountDownLatch getLatch() {
            return this.latch;
        }
    }
}

