/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.snapshot.upgrader;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.license.LicensedAllocatedPersistentTask;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.job.process.autodetect.JobModelSnapshotUpgrader;

public class SnapshotUpgradeTask
extends LicensedAllocatedPersistentTask {
    private static final Logger logger = LogManager.getLogger(SnapshotUpgradeTask.class);
    private final String jobId;
    private final String snapshotId;
    private JobModelSnapshotUpgrader jobModelSnapshotUpgrader;

    public SnapshotUpgradeTask(String jobId, String snapshotId, long id, String type, String action, TaskId parentTask, Map<String, String> headers, XPackLicenseState licenseState) {
        super(id, type, action, MlTasks.snapshotUpgradeTaskId((String)jobId, (String)snapshotId), parentTask, headers, MachineLearning.ML_ANOMALY_JOBS_FEATURE, MlTasks.snapshotUpgradeTaskId((String)jobId, (String)snapshotId), licenseState);
        this.jobId = jobId;
        this.snapshotId = snapshotId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    protected synchronized void onCancelled() {
        if (this.jobModelSnapshotUpgrader != null) {
            String reason = this.getReasonCancelled();
            logger.trace("[{}] Cancelling snapshot upgrade [{}] task because: {}", (Object)this.jobId, (Object)this.snapshotId, (Object)reason);
            this.jobModelSnapshotUpgrader.killProcess(reason);
            this.jobModelSnapshotUpgrader = null;
        }
    }

    public synchronized void setJobModelSnapshotUpgrader(JobModelSnapshotUpgrader jobModelSnapshotUpgrader) {
        this.jobModelSnapshotUpgrader = jobModelSnapshotUpgrader;
    }
}

