/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.calendar;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.List;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestGetCalendarEventsAction
extends BaseRestHandler {
    public java.util.List<RestHandler.Route> routes() {
        return List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/calendars/{" + Calendar.ID + "}/events")).replaces(RestRequest.Method.GET, "/_xpack/ml/calendars/{" + Calendar.ID + "}/events", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_get_calendar_events_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetCalendarEventsAction.Request request;
        String calendarId = restRequest.param(Calendar.ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            try (XContentParser parser = restRequest.contentOrSourceParamParser();){
                request = GetCalendarEventsAction.Request.parseRequest((String)calendarId, (XContentParser)parser);
            }
        } else {
            request = new GetCalendarEventsAction.Request(calendarId);
            request.setStart(restRequest.param(GetCalendarEventsAction.Request.START.getPreferredName(), null));
            request.setEnd(restRequest.param(GetCalendarEventsAction.Request.END.getPreferredName(), null));
            request.setJobId(restRequest.param(Job.ID.getPreferredName(), null));
            if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
                request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
            }
        }
        return channel -> client.execute((ActionType)GetCalendarEventsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

