/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import java.util.List;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.spatial.search.aggregations.InternalGeoLine;

final class MergedGeoLines {
    private final List<InternalGeoLine> geoLines;
    private final int capacity;
    private final SortOrder sortOrder;
    private final int[] lineIndices;
    private final int[] idxsWithinLine;
    private int size;
    private final long[] finalPoints;
    private final double[] finalSortValues;

    MergedGeoLines(List<InternalGeoLine> geoLines, int finalLength, SortOrder sortOrder) {
        this.geoLines = geoLines;
        this.capacity = geoLines.size();
        this.sortOrder = sortOrder;
        this.lineIndices = new int[this.capacity];
        this.idxsWithinLine = new int[this.capacity];
        this.size = 0;
        this.finalPoints = new long[finalLength];
        this.finalSortValues = new double[finalLength];
    }

    public long[] getFinalPoints() {
        return this.finalPoints;
    }

    public double[] getFinalSortValues() {
        return this.finalSortValues;
    }

    public void merge() {
        int i;
        for (i = 0; i < this.geoLines.size(); ++i) {
            if (this.geoLines.get(i).length() <= 0) continue;
            this.add(i, 0);
        }
        for (i = 0; i < this.finalPoints.length && this.size > 0; ++i) {
            int lineIdx = this.lineIndices[0];
            int idxInLine = this.idxsWithinLine[0];
            this.finalPoints[i] = this.getTopPoint();
            this.finalSortValues[i] = this.getTopSortValue();
            this.removeTop();
            InternalGeoLine lineChosen = this.geoLines.get(lineIdx);
            if (idxInLine + 1 >= lineChosen.length()) continue;
            this.add(lineIdx, idxInLine + 1);
        }
    }

    private long getTopPoint() {
        InternalGeoLine line = this.geoLines.get(this.lineIndices[0]);
        return line.line()[this.idxsWithinLine[0]];
    }

    private double getTopSortValue() {
        InternalGeoLine line = this.geoLines.get(this.lineIndices[0]);
        return line.sortVals()[this.idxsWithinLine[0]];
    }

    private void removeTop() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        this.lineIndices[0] = this.lineIndices[this.size - 1];
        this.idxsWithinLine[0] = this.idxsWithinLine[this.size - 1];
        --this.size;
        this.heapifyDown();
    }

    private void add(int lineIndex, int idxWithinLine) {
        if (this.size >= this.capacity) {
            throw new IllegalStateException();
        }
        this.lineIndices[this.size] = lineIndex;
        this.idxsWithinLine[this.size] = idxWithinLine;
        ++this.size;
        this.heapifyUp();
    }

    private boolean correctOrdering(int i, int j) {
        InternalGeoLine lineI = this.geoLines.get(this.lineIndices[i]);
        InternalGeoLine lineJ = this.geoLines.get(this.lineIndices[j]);
        double valI = lineI.sortVals()[this.idxsWithinLine[i]];
        double valJ = lineJ.sortVals()[this.idxsWithinLine[j]];
        if (SortOrder.ASC.equals((Object)this.sortOrder)) {
            return valI > valJ;
        }
        return valI < valJ;
    }

    private int getParentIndex(int i) {
        return (i - 1) / 2;
    }

    private int getLeftChildIndex(int i) {
        return 2 * i + 1;
    }

    private int getRightChildIndex(int i) {
        return 2 * i + 2;
    }

    private boolean hasParent(int i) {
        return i > 0;
    }

    private boolean hasLeftChild(int i) {
        return this.getLeftChildIndex(i) < this.size;
    }

    private boolean hasRightChild(int i) {
        return this.getRightChildIndex(i) < this.size;
    }

    private void heapifyUp() {
        int i = this.size - 1;
        while (this.hasParent(i) && this.correctOrdering(this.getParentIndex(i), i)) {
            int parentIndex = this.getParentIndex(i);
            this.swap(parentIndex, i);
            i = parentIndex;
        }
    }

    private void heapifyDown() {
        int i = 0;
        while (this.hasLeftChild(i)) {
            int childIndex = this.getLeftChildIndex(i);
            if (this.hasRightChild(i) && !this.correctOrdering(this.getRightChildIndex(i), childIndex)) {
                childIndex = this.getRightChildIndex(i);
            }
            if (this.correctOrdering(childIndex, i)) break;
            this.swap(childIndex, i);
            i = childIndex;
        }
    }

    private void swap(int i, int j) {
        int tmpLineIndex = this.lineIndices[i];
        int tmpIdxWithinLine = this.idxsWithinLine[i];
        this.lineIndices[i] = this.lineIndices[j];
        this.idxsWithinLine[i] = this.idxsWithinLine[j];
        this.lineIndices[j] = tmpLineIndex;
        this.idxsWithinLine[j] = tmpIdxWithinLine;
    }
}

