/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.ExecutorNames;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.action.DeleteDataStreamAction;
import org.elasticsearch.xpack.core.template.TemplateUtils;
import org.elasticsearch.xpack.fleet.FleetTemplateRegistry;
import org.elasticsearch.xpack.fleet.action.GetGlobalCheckpointsAction;
import org.elasticsearch.xpack.fleet.action.GetGlobalCheckpointsShardAction;
import org.elasticsearch.xpack.fleet.rest.RestFleetMultiSearchAction;
import org.elasticsearch.xpack.fleet.rest.RestFleetSearchAction;
import org.elasticsearch.xpack.fleet.rest.RestGetGlobalCheckpointsAction;

public class Fleet
extends Plugin
implements SystemIndexPlugin {
    private static final int CURRENT_INDEX_VERSION = 7;
    private static final String VERSION_KEY = "version";
    private static final String MAPPING_VERSION_VARIABLE = "fleet.version";
    private static final List<String> ALLOWED_PRODUCTS = Collections.unmodifiableList(Arrays.asList("kibana", "fleet"));

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        FleetTemplateRegistry registry = new FleetTemplateRegistry(environment.settings(), clusterService, threadPool, client, xContentRegistry);
        registry.initialize();
        return Collections.emptyList();
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return Collections.unmodifiableList(Arrays.asList(this.fleetActionsSystemIndexDescriptor(), this.fleetAgentsSystemIndexDescriptor(), this.fleetEnrollmentApiKeysSystemIndexDescriptor(), this.fleetPoliciesSystemIndexDescriptor(), this.fleetPoliciesLeaderSystemIndexDescriptor(), this.fleetServersSystemIndexDescriptors(), this.fleetArtifactsSystemIndexDescriptors()));
    }

    public Collection<SystemDataStreamDescriptor> getSystemDataStreamDescriptors() {
        return Collections.singletonList(this.fleetActionsResultsDescriptor());
    }

    public String getFeatureName() {
        return "fleet";
    }

    public String getFeatureDescription() {
        return "Manages configuration for Fleet";
    }

    private SystemIndexDescriptor fleetActionsSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(this.loadTemplateSource("/fleet-actions.json"), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings((String)request.mappings().get("_doc")).setSettings(request.settings()).setPrimaryIndex(".fleet-actions-7").setIndexPattern(".fleet-actions~(-results*)").setAliasName(".fleet-actions").setDescription("Fleet agents").build();
    }

    private SystemIndexDescriptor fleetAgentsSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(this.loadTemplateSource("/fleet-agents.json"), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings((String)request.mappings().get("_doc")).setSettings(request.settings()).setPrimaryIndex(".fleet-agents-7").setIndexPattern(".fleet-agents*").setAliasName(".fleet-agents").setDescription("Configuration of fleet servers").build();
    }

    private SystemIndexDescriptor fleetEnrollmentApiKeysSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(this.loadTemplateSource("/fleet-enrollment-api-keys.json"), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings((String)request.mappings().get("_doc")).setSettings(request.settings()).setPrimaryIndex(".fleet-enrollment-api-keys-7").setIndexPattern(".fleet-enrollment-api-keys*").setAliasName(".fleet-enrollment-api-keys").setDescription("Fleet API Keys for enrollment").build();
    }

    private SystemIndexDescriptor fleetPoliciesSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(this.loadTemplateSource("/fleet-policies.json"), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings((String)request.mappings().get("_doc")).setSettings(request.settings()).setPrimaryIndex(".fleet-policies-7").setIndexPattern(".fleet-policies-[0-9]+*").setAliasName(".fleet-policies").setDescription("Fleet Policies").build();
    }

    private SystemIndexDescriptor fleetPoliciesLeaderSystemIndexDescriptor() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(this.loadTemplateSource("/fleet-policies-leader.json"), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings((String)request.mappings().get("_doc")).setSettings(request.settings()).setPrimaryIndex(".fleet-policies-leader-7").setIndexPattern(".fleet-policies-leader*").setAliasName(".fleet-policies-leader").setDescription("Fleet Policies leader").build();
    }

    private SystemIndexDescriptor fleetServersSystemIndexDescriptors() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(this.loadTemplateSource("/fleet-servers.json"), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings((String)request.mappings().get("_doc")).setSettings(request.settings()).setPrimaryIndex(".fleet-servers-7").setIndexPattern(".fleet-servers*").setAliasName(".fleet-servers").setDescription("Fleet servers").build();
    }

    private SystemIndexDescriptor fleetArtifactsSystemIndexDescriptors() {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest();
        request.source(this.loadTemplateSource("/fleet-artifacts.json"), XContentType.JSON);
        return SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setAllowedElasticProductOrigins(ALLOWED_PRODUCTS).setOrigin("fleet").setVersionMetaKey(VERSION_KEY).setMappings((String)request.mappings().get("_doc")).setSettings(request.settings()).setPrimaryIndex(".fleet-artifacts-7").setIndexPattern(".fleet-artifacts*").setAliasName(".fleet-artifacts").setDescription("Fleet artifacts").build();
    }

    private SystemDataStreamDescriptor fleetActionsResultsDescriptor() {
        SystemDataStreamDescriptor systemDataStreamDescriptor;
        block8: {
            String source = this.loadTemplateSource("/fleet-actions-results.json");
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, source);
            try {
                ComposableIndexTemplate composableIndexTemplate = ComposableIndexTemplate.parse((XContentParser)parser);
                systemDataStreamDescriptor = new SystemDataStreamDescriptor(".fleet-actions-results", "Result history of fleet actions", SystemDataStreamDescriptor.Type.EXTERNAL, composableIndexTemplate, Collections.emptyMap(), ALLOWED_PRODUCTS, ExecutorNames.DEFAULT_SYSTEM_DATA_STREAM_THREAD_POOLS);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            parser.close();
        }
        return systemDataStreamDescriptor;
    }

    public void cleanUpFeature(ClusterService clusterService, Client client, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus> listener) {
        block5: {
            Collection<SystemDataStreamDescriptor> dataStreamDescriptors = this.getSystemDataStreamDescriptors();
            if (!dataStreamDescriptors.isEmpty()) {
                try {
                    DeleteDataStreamAction.Request request = new DeleteDataStreamAction.Request(dataStreamDescriptors.stream().map(SystemDataStreamDescriptor::getDataStreamName).collect(Collectors.toList()).toArray(Strings.EMPTY_ARRAY));
                    EnumSet options = request.indicesOptions().getOptions();
                    options.add(IndicesOptions.Option.IGNORE_UNAVAILABLE);
                    options.add(IndicesOptions.Option.ALLOW_NO_INDICES);
                    request.indicesOptions(new IndicesOptions(options, request.indicesOptions().getExpandWildcards()));
                    client.execute((ActionType)DeleteDataStreamAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> super.cleanUpFeature(clusterService, client, listener), e -> {
                        Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e);
                        if (unwrapped instanceof ResourceNotFoundException) {
                            super.cleanUpFeature(clusterService, client, listener);
                        } else {
                            listener.onFailure(e);
                        }
                    }));
                }
                catch (Exception e2) {
                    Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e2);
                    if (unwrapped instanceof ResourceNotFoundException) {
                        super.cleanUpFeature(clusterService, client, listener);
                        break block5;
                    }
                    listener.onFailure(e2);
                }
            } else {
                super.cleanUpFeature(clusterService, client, listener);
            }
        }
    }

    private String loadTemplateSource(String resource) {
        return TemplateUtils.loadTemplate((String)resource, (String)Version.CURRENT.toString(), (String)MAPPING_VERSION_VARIABLE);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)GetGlobalCheckpointsAction.INSTANCE, GetGlobalCheckpointsAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetGlobalCheckpointsShardAction.INSTANCE, GetGlobalCheckpointsShardAction.TransportAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestGetGlobalCheckpointsAction(), new RestFleetSearchAction(), new RestFleetMultiSearchAction(settings)});
    }
}

