/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;

public class StemmerOverrideTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final StemmerOverrideFilter.StemmerOverrideMap overrideMap;

    StemmerOverrideTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) throws IOException {
        super(indexSettings, name, settings);
        List rules = Analysis.getWordList((Environment)env, (Settings)settings, (String)"rules");
        if (rules == null) {
            throw new IllegalArgumentException("stemmer override filter requires either `rules` or `rules_path` to be configured");
        }
        StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(false);
        StemmerOverrideTokenFilterFactory.parseRules(rules, builder, "=>");
        this.overrideMap = builder.build();
    }

    public TokenStream create(TokenStream tokenStream) {
        return new StemmerOverrideFilter(tokenStream, this.overrideMap);
    }

    static void parseRules(List<String> rules, StemmerOverrideFilter.Builder builder, String mappingSep) {
        for (String rule : rules) {
            String[] sides = rule.split(mappingSep, -1);
            if (sides.length != 2) {
                throw new RuntimeException("Invalid Keyword override Rule:" + rule);
            }
            String[] keys = sides[0].split(",", -1);
            String override = sides[1].trim();
            if (override.isEmpty() || override.indexOf(44) != -1) {
                throw new RuntimeException("Invalid Keyword override Rule:" + rule);
            }
            for (String key : keys) {
                String trimmedKey = key.trim();
                if (trimmedKey.isEmpty()) {
                    throw new RuntimeException("Invalid Keyword override Rule:" + rule);
                }
                builder.add((CharSequence)trimmedKey, (CharSequence)override);
            }
        }
    }
}

