/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation.decider;

import java.util.List;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;

public class SearchableSnapshotRepositoryExistsAllocationDecider
extends AllocationDecider {
    private static final String NAME = "searchable_snapshot_repository_exists";
    private static final Decision YES_INAPPLICABLE = Decision.single((Decision.Type)Decision.Type.YES, (String)"searchable_snapshot_repository_exists", (String)"this decider only applies to indices backed by searchable snapshots", (Object[])new Object[0]);
    private static final Decision YES_REPOSITORY_EXISTS = Decision.single((Decision.Type)Decision.Type.YES, (String)"searchable_snapshot_repository_exists", (String)"the repository containing the data for this index exists", (Object[])new Object[0]);

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return SearchableSnapshotRepositoryExistsAllocationDecider.allowAllocation(allocation.metadata().getIndexSafe(shardRouting.index()), allocation);
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        return SearchableSnapshotRepositoryExistsAllocationDecider.allowAllocation(allocation.metadata().getIndexSafe(shardRouting.index()), allocation);
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return SearchableSnapshotRepositoryExistsAllocationDecider.allowAllocation(indexMetadata, allocation);
    }

    private static Decision allowAllocation(IndexMetadata indexMetadata, RoutingAllocation allocation) {
        Settings settings = indexMetadata.getSettings();
        if (SearchableSnapshotsSettings.isSearchableSnapshotStore((Settings)settings)) {
            RepositoriesMetadata repositoriesMetadata = (RepositoriesMetadata)allocation.metadata().custom("repositories");
            if (repositoriesMetadata == null || repositoriesMetadata.repositories().isEmpty()) {
                return allocation.decision(Decision.NO, NAME, "there are no repositories registered in this cluster", new Object[0]);
            }
            String repositoryUuid = (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_UUID_SETTING.get(settings);
            if (Strings.hasLength((String)repositoryUuid)) {
                List repositories = repositoriesMetadata.repositories();
                if (repositories.stream().anyMatch(r -> repositoryUuid.equals(r.uuid()))) {
                    return YES_REPOSITORY_EXISTS;
                }
                return allocation.decision(Decision.NO, NAME, "this index is backed by a searchable snapshot in a repository with UUID [%s] but no such repository is registered with this cluster; the required repository was originally named [%s]", new Object[]{repositoryUuid, SearchableSnapshots.SNAPSHOT_REPOSITORY_NAME_SETTING.get(settings)});
            }
            String repositoryName = (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_NAME_SETTING.get(settings);
            if (repositoriesMetadata.repository(repositoryName) != null) {
                return YES_REPOSITORY_EXISTS;
            }
            return allocation.decision(Decision.NO, NAME, "this index is backed by a searchable snapshot in a repository named [%s] but no such repository is registered with this cluster", new Object[]{repositoryName});
        }
        return YES_INAPPLICABLE;
    }
}

