/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache.full;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractAsyncTask;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsUtils;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.ByteRange;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheFile;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheKey;
import org.elasticsearch.xpack.searchablesnapshots.cache.full.PersistentCache;

public class CacheService
extends AbstractLifecycleComponent {
    private static final String SETTINGS_PREFIX = "xpack.searchable.snapshot.cache.";
    public static final ByteSizeValue MIN_SNAPSHOT_CACHE_RANGE_SIZE = new ByteSizeValue(4L, ByteSizeUnit.KB);
    public static final ByteSizeValue MAX_SNAPSHOT_CACHE_RANGE_SIZE = new ByteSizeValue(Integer.MAX_VALUE, ByteSizeUnit.BYTES);
    public static final Setting<ByteSizeValue> SNAPSHOT_CACHE_RANGE_SIZE_SETTING = Setting.byteSizeSetting((String)"xpack.searchable.snapshot.cache.range_size", (ByteSizeValue)new ByteSizeValue(32L, ByteSizeUnit.MB), (ByteSizeValue)MIN_SNAPSHOT_CACHE_RANGE_SIZE, (ByteSizeValue)MAX_SNAPSHOT_CACHE_RANGE_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SNAPSHOT_CACHE_RECOVERY_RANGE_SIZE_SETTING = Setting.byteSizeSetting((String)"xpack.searchable.snapshot.cache.recovery_range_size", (ByteSizeValue)new ByteSizeValue(128L, ByteSizeUnit.KB), (ByteSizeValue)MIN_SNAPSHOT_CACHE_RANGE_SIZE, (ByteSizeValue)MAX_SNAPSHOT_CACHE_RANGE_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final TimeValue MIN_SNAPSHOT_CACHE_SYNC_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    public static final Setting<TimeValue> SNAPSHOT_CACHE_SYNC_INTERVAL_SETTING = Setting.timeSetting((String)"xpack.searchable.snapshot.cache.sync.interval", (TimeValue)TimeValue.timeValueSeconds((long)60L), (TimeValue)MIN_SNAPSHOT_CACHE_SYNC_INTERVAL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> SNAPSHOT_CACHE_MAX_FILES_TO_SYNC_AT_ONCE_SETTING = Setting.intSetting((String)"xpack.searchable.snapshot.cache.sync.max_files", (int)10000, (int)0, (int)Integer.MAX_VALUE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> SNAPSHOT_CACHE_SYNC_SHUTDOWN_TIMEOUT = Setting.timeSetting((String)"xpack.searchable.snapshot.cache.sync.shutdown_timeout", (TimeValue)TimeValue.timeValueSeconds((long)10L), (TimeValue)TimeValue.ZERO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(CacheService.class);
    private final ThreadPool threadPool;
    private final ConcurrentLinkedQueue<CacheFileEvent> cacheFilesEventsQueue;
    private final CacheFile.ModificationListener cacheFilesListener;
    private final Map<Path, Long> cacheFilesSyncExceptionsLogs;
    private final Map<Path, Long> cacheDirsSyncExceptionsLogs;
    private final AtomicLong numberOfCacheFilesEvents;
    private final CacheSynchronizationTask cacheSyncTask;
    private final TimeValue cacheSyncStopTimeout;
    private final ReentrantLock cacheSyncLock;
    private final PersistentCache persistentCache;
    private final Cache<CacheKey, CacheFile> cache;
    private final ByteSizeValue rangeSize;
    private final ByteSizeValue recoveryRangeSize;
    private final Map<ShardEviction, Future<?>> pendingShardsEvictions;
    private final ReadWriteLock shardsEvictionsLock;
    private final Object shardsEvictionsMutex;
    private volatile int maxCacheFilesToSyncAtOnce;
    private boolean allowShardsEvictions;

    public CacheService(Settings settings, ClusterService clusterService, ThreadPool threadPool, PersistentCache persistentCache) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.rangeSize = (ByteSizeValue)SNAPSHOT_CACHE_RANGE_SIZE_SETTING.get(settings);
        this.recoveryRangeSize = (ByteSizeValue)SNAPSHOT_CACHE_RECOVERY_RANGE_SIZE_SETTING.get(settings);
        this.cache = CacheBuilder.builder().weigher((key, entry) -> entry.getLength()).removalListener(notification -> this.onCacheFileEviction((CacheFile)notification.getValue())).build();
        this.persistentCache = Objects.requireNonNull(persistentCache);
        this.cacheSyncLock = new ReentrantLock();
        this.numberOfCacheFilesEvents = new AtomicLong();
        this.cacheFilesEventsQueue = new ConcurrentLinkedQueue();
        this.cacheFilesListener = new CacheFileModificationListener();
        this.cacheFilesSyncExceptionsLogs = new HashMap<Path, Long>();
        this.cacheDirsSyncExceptionsLogs = new HashMap<Path, Long>();
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        this.maxCacheFilesToSyncAtOnce = (Integer)SNAPSHOT_CACHE_MAX_FILES_TO_SYNC_AT_ONCE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SNAPSHOT_CACHE_MAX_FILES_TO_SYNC_AT_ONCE_SETTING, this::setMaxCacheFilesToSyncAtOnce);
        this.cacheSyncTask = new CacheSynchronizationTask(threadPool, (TimeValue)SNAPSHOT_CACHE_SYNC_INTERVAL_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(SNAPSHOT_CACHE_SYNC_INTERVAL_SETTING, this::setCacheSyncInterval);
        this.cacheSyncStopTimeout = (TimeValue)SNAPSHOT_CACHE_SYNC_SHUTDOWN_TIMEOUT.get(settings);
        this.shardsEvictionsLock = new ReentrantReadWriteLock();
        this.pendingShardsEvictions = new HashMap();
        this.shardsEvictionsMutex = new Object();
        this.allowShardsEvictions = true;
    }

    public static Path getShardCachePath(ShardPath shardPath) {
        return CacheService.resolveSnapshotCache(shardPath.getDataPath());
    }

    public static Path resolveSnapshotCache(Path path) {
        return path.resolve("snapshot_cache");
    }

    protected void doStart() {
        this.persistentCache.repopulateCache(this);
        this.cacheSyncTask.rescheduleIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doStop() {
        boolean acquired = false;
        try {
            try {
                acquired = this.cacheSyncLock.tryLock(this.cacheSyncStopTimeout.duration(), this.cacheSyncStopTimeout.timeUnit());
                if (!acquired) {
                    logger.warn("failed to acquire cache sync lock in [{}], cache might be partially persisted", (Object)this.cacheSyncStopTimeout);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("interrupted while waiting for cache sync lock", (Throwable)e);
            }
            this.cacheSyncTask.close();
            return;
        }
        finally {
            try {
                this.waitForAllPendingShardsEvictions();
            }
            finally {
                try {
                    this.persistentCache.close();
                }
                catch (Exception e) {
                    logger.warn("failed to close persistent cache", (Throwable)e);
                }
                finally {
                    this.cacheFilesSyncExceptionsLogs.clear();
                    this.cacheDirsSyncExceptionsLogs.clear();
                    if (acquired) {
                        this.cacheSyncLock.unlock();
                    }
                }
            }
        }
    }

    protected void doClose() {
    }

    private void ensureLifecycleInitializing() {
        Lifecycle.State state = this.lifecycleState();
        assert (state == Lifecycle.State.INITIALIZED) : state;
        if (state != Lifecycle.State.INITIALIZED) {
            throw new IllegalStateException("Failed to read data from cache: cache service is not initializing [" + state + "]");
        }
    }

    private void ensureLifecycleStarted() {
        Lifecycle.State state = this.lifecycleState();
        assert (state != Lifecycle.State.INITIALIZED) : state;
        if (state != Lifecycle.State.STARTED) {
            throw new IllegalStateException("Failed to read data from cache: cache service is not started [" + state + "]");
        }
    }

    public int getRangeSize() {
        return SearchableSnapshotsUtils.toIntBytes(this.rangeSize.getBytes());
    }

    public int getRecoveryRangeSize() {
        return SearchableSnapshotsUtils.toIntBytes(this.recoveryRangeSize.getBytes());
    }

    public CacheFile get(CacheKey cacheKey, long fileLength, Path cacheDir) throws Exception {
        this.ensureLifecycleStarted();
        return (CacheFile)this.cache.computeIfAbsent((Object)cacheKey, key -> {
            this.ensureLifecycleStarted();
            String uuid = UUIDs.randomBase64UUID();
            Path path = cacheDir.resolve(uuid);
            assert (Files.notExists(path, new LinkOption[0])) : "cache file already exists " + path;
            return new CacheFile((CacheKey)key, fileLength, path, this.cacheFilesListener);
        });
    }

    public long getCachedSize(ShardId shardId, SnapshotId snapshotId) {
        return this.persistentCache.getCacheSize(shardId, snapshotId);
    }

    void put(CacheKey cacheKey, long fileLength, Path cacheDir, String cacheFileUuid, SortedSet<ByteRange> cacheFileRanges) throws Exception {
        this.ensureLifecycleInitializing();
        Path path = cacheDir.resolve(cacheFileUuid);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Cache file [" + path + "] not found");
        }
        this.cache.put((Object)cacheKey, (Object)new CacheFile(cacheKey, fileLength, path, cacheFileRanges, this.cacheFilesListener));
    }

    public void removeFromCache(CacheKey cacheKey) {
        this.cache.invalidate((Object)cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markShardAsEvictedInCache(String snapshotUUID, String snapshotIndexName, ShardId shardId) {
        Object object = this.shardsEvictionsMutex;
        synchronized (object) {
            if (this.allowShardsEvictions) {
                final ShardEviction shardEviction = new ShardEviction(snapshotUUID, snapshotIndexName, shardId);
                this.pendingShardsEvictions.computeIfAbsent(shardEviction, shard -> this.threadPool.generic().submit((Runnable)new AbstractRunnable(){

                    protected void doRun() {
                        CacheService.this.processShardEviction(shardEviction);
                    }

                    public void onFailure(Exception e) {
                        logger.warn(() -> new ParameterizedMessage("failed to evict cache files associated with shard {}", (Object)shardEviction), (Throwable)e);
                        assert (false) : e;
                    }
                }));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCacheFilesEvictionIfNeeded(String snapshotUUID, String snapshotIndexName, ShardId shardId) {
        Future<?> future;
        assert (CacheService.assertGenericThreadPool());
        Object object = this.shardsEvictionsMutex;
        synchronized (object) {
            if (!this.allowShardsEvictions) {
                throw new AlreadyClosedException("Cannot wait for shard eviction to be processed, cache is stopping");
            }
            future = this.pendingShardsEvictions.get(new ShardEviction(snapshotUUID, snapshotIndexName, shardId));
            if (future == null) {
                return;
            }
        }
        FutureUtils.get(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processShardEviction(ShardEviction shardEviction) {
        assert (this.isPendingShardEviction(shardEviction)) : "shard is not marked as evicted: " + shardEviction;
        assert (CacheService.assertGenericThreadPool());
        this.shardsEvictionsLock.readLock().lock();
        try {
            try {
                boolean canEvict;
                Object object = this.shardsEvictionsMutex;
                synchronized (object) {
                    canEvict = this.allowShardsEvictions;
                }
                if (canEvict) {
                    ArrayList cacheFilesToEvict = new ArrayList();
                    this.cache.forEach((cacheKey, cacheFile) -> {
                        if (shardEviction.matches((CacheKey)cacheKey)) {
                            cacheFilesToEvict.add(cacheFile);
                        }
                    });
                    for (CacheFile cacheFile2 : cacheFilesToEvict) {
                        try {
                            this.cache.invalidate((Object)cacheFile2.getCacheKey(), (Object)cacheFile2);
                        }
                        catch (RuntimeException e) {
                            logger.warn(() -> new ParameterizedMessage("failed to evict cache file {}", (Object)cacheFile2.getCacheKey()), (Throwable)e);
                            assert (false) : e;
                        }
                    }
                    logger.debug("shard eviction [{}] processed with [{}] cache files invalidated", (Object)shardEviction, (Object)cacheFilesToEvict.size());
                }
            }
            finally {
                Object object = this.shardsEvictionsMutex;
                synchronized (object) {
                    Future<?> removedFuture = this.pendingShardsEvictions.remove(shardEviction);
                    assert (removedFuture != null);
                }
            }
        }
        finally {
            this.shardsEvictionsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAllPendingShardsEvictions() {
        Object object = this.shardsEvictionsMutex;
        synchronized (object) {
            this.allowShardsEvictions = false;
        }
        boolean success = false;
        try {
            if (!this.shardsEvictionsLock.writeLock().tryLock(10L, TimeUnit.SECONDS)) {
                logger.warn("waiting for shards evictions to be processed");
                this.shardsEvictionsLock.writeLock().lock();
            }
            success = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("interrupted while waiting shards evictions to be processed", (Throwable)e);
        }
        finally {
            if (success) {
                this.shardsEvictionsLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPendingShardEviction(ShardEviction shardEviction) {
        Object object = this.shardsEvictionsMutex;
        synchronized (object) {
            return this.pendingShardsEvictions.get(shardEviction) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<ShardEviction, Future<?>> pendingShardsEvictions() {
        Object object = this.shardsEvictionsMutex;
        synchronized (object) {
            return org.elasticsearch.core.Map.copyOf(this.pendingShardsEvictions);
        }
    }

    void setCacheSyncInterval(TimeValue interval) {
        this.cacheSyncTask.setInterval(interval);
    }

    private void setMaxCacheFilesToSyncAtOnce(int maxCacheFilesToSyncAtOnce) {
        this.maxCacheFilesToSyncAtOnce = maxCacheFilesToSyncAtOnce;
    }

    private void onCacheFileEviction(CacheFile cacheFile) {
        IOUtils.closeWhileHandlingException(cacheFile::startEviction);
    }

    boolean isCacheFileToSync(CacheFile cacheFile) {
        return this.cacheFilesEventsQueue.stream().filter(event -> event.type == CacheFileEventType.NEEDS_FSYNC).anyMatch(event -> event.value == cacheFile);
    }

    PersistentCache getPersistentCache() {
        return this.persistentCache;
    }

    long getNumberOfCacheFilesEvents() {
        return this.numberOfCacheFilesEvents.get();
    }

    long getCacheFilesEventsQueueSize() {
        return this.cacheFilesEventsQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeCache() {
        this.cacheSyncLock.lock();
        try {
            HashSet<Path> cacheDirs = new HashSet<Path>();
            long startTimeNanos = this.threadPool.relativeTimeInNanos();
            long maxCacheFilesToSync = Math.min(this.numberOfCacheFilesEvents.get(), (long)this.maxCacheFilesToSyncAtOnce);
            if (!this.cacheFilesSyncExceptionsLogs.isEmpty() || !this.cacheDirsSyncExceptionsLogs.isEmpty()) {
                long expiredTimeNanos = Math.min(0L, startTimeNanos - TimeUnit.MINUTES.toNanos(10L));
                this.cacheFilesSyncExceptionsLogs.values().removeIf(lastLogTimeNanos -> expiredTimeNanos >= lastLogTimeNanos);
                this.cacheDirsSyncExceptionsLogs.values().removeIf(lastLogTimeNanos -> expiredTimeNanos >= lastLogTimeNanos);
            }
            long updates = 0L;
            long deletes = 0L;
            long errors = 0L;
            block13: while (updates + errors < maxCacheFilesToSync) {
                if (this.lifecycleState() != Lifecycle.State.STARTED) {
                    logger.debug("stopping cache synchronization (cache service is closing)");
                    break;
                }
                CacheFileEvent event = this.cacheFilesEventsQueue.poll();
                if (event == null) {
                    logger.debug("stopping cache synchronization (no more events to synchronize)");
                    break;
                }
                long numberOfEvents = this.numberOfCacheFilesEvents.decrementAndGet();
                assert (numberOfEvents >= 0L) : numberOfEvents;
                CacheFile cacheFile = event.value;
                Path cacheDir = cacheFile.getFile().toAbsolutePath().getParent();
                try {
                    switch (event.type) {
                        case DELETE: {
                            logger.trace("deleting cache file [{}] from persistent cache", (Object)cacheFile.getFile().getFileName());
                            this.persistentCache.removeCacheFile(cacheFile);
                            ++deletes;
                            break;
                        }
                        case NEEDS_FSYNC: {
                            SortedSet<ByteRange> ranges = cacheFile.fsync();
                            logger.trace("cache file [{}] synchronized with [{}] completed range(s)", (Object)cacheFile.getFile().getFileName(), (Object)ranges.size());
                            if (ranges.isEmpty()) continue block13;
                            boolean shouldPersist = cacheDirs.contains(cacheDir);
                            if (!shouldPersist) {
                                try {
                                    IOUtils.fsync((Path)cacheDir, (boolean)true, (boolean)false);
                                    logger.trace("cache directory [{}] synchronized", (Object)cacheDir);
                                    cacheDirs.add(cacheDir);
                                    shouldPersist = true;
                                }
                                catch (Exception e) {
                                    if (this.cacheDirsSyncExceptionsLogs.putIfAbsent(cacheDir, startTimeNanos) == null) {
                                        logger.warn(() -> new ParameterizedMessage("failed to synchronize cache directory [{}]", (Object)cacheDir), (Throwable)e);
                                    }
                                    assert (e instanceof IOException) : e;
                                    shouldPersist = false;
                                }
                            }
                            if (!shouldPersist) continue block13;
                            this.persistentCache.addCacheFile(cacheFile, ranges);
                            ++updates;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown cache file event [" + event + ']');
                        }
                    }
                }
                catch (Exception e) {
                    if (this.cacheFilesSyncExceptionsLogs.putIfAbsent(cacheDir, startTimeNanos) == null) {
                        logger.warn(() -> new ParameterizedMessage("failed to process [{}] for cache file [{}]", (Object)event.type, (Object)cacheFile.getFile().getFileName()), (Throwable)e);
                    }
                    assert (e instanceof IOException) : e;
                    ++errors;
                }
            }
            if (updates > 0L || deletes > 0L) {
                try {
                    this.persistentCache.commit();
                }
                catch (IOException e) {
                    logger.error("failed to commit persistent cache after synchronization", (Throwable)e);
                }
            }
            if (logger.isDebugEnabled()) {
                long elapsedNanos = this.threadPool.relativeTimeInNanos() - startTimeNanos;
                logger.debug("cache files synchronization is done ([{}] cache files synchronized in [{}])", (Object)updates, (Object)TimeValue.timeValueNanos((long)elapsedNanos));
            }
        }
        finally {
            this.cacheSyncLock.unlock();
        }
    }

    private static boolean assertGenericThreadPool() {
        String threadName = Thread.currentThread().getName();
        assert (threadName.contains("[generic]") || threadName.startsWith("TEST-")) : "expected generic thread pool but got " + threadName;
        return true;
    }

    static class ShardEviction {
        private final String snapshotUUID;
        private final String snapshotIndexName;
        private final ShardId shardId;

        ShardEviction(String snapshotUUID, String snapshotIndexName, ShardId shardId) {
            this.snapshotUUID = snapshotUUID;
            this.snapshotIndexName = snapshotIndexName;
            this.shardId = shardId;
        }

        public String getSnapshotUUID() {
            return this.snapshotUUID;
        }

        public String getSnapshotIndexName() {
            return this.snapshotIndexName;
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardEviction that = (ShardEviction)o;
            return Objects.equals(this.snapshotUUID, that.snapshotUUID) && Objects.equals(this.snapshotIndexName, that.snapshotIndexName) && Objects.equals(this.shardId, that.shardId);
        }

        public int hashCode() {
            return Objects.hash(this.snapshotUUID, this.snapshotIndexName, this.shardId);
        }

        public String toString() {
            return "[snapshotUUID=" + this.snapshotUUID + ", snapshotIndexName=" + this.snapshotIndexName + ", shardId=" + this.shardId + ']';
        }

        boolean matches(CacheKey cacheKey) {
            return Objects.equals(this.snapshotUUID, cacheKey.getSnapshotUUID()) && Objects.equals(this.snapshotIndexName, cacheKey.getSnapshotIndexName()) && Objects.equals(this.shardId, cacheKey.getShardId());
        }
    }

    private class CacheFileModificationListener
    implements CacheFile.ModificationListener {
        private CacheFileModificationListener() {
        }

        @Override
        public void onCacheFileNeedsFsync(CacheFile cacheFile) {
            CacheService.this.cacheFilesEventsQueue.offer(new CacheFileEvent(CacheFileEventType.NEEDS_FSYNC, cacheFile));
            CacheService.this.numberOfCacheFilesEvents.incrementAndGet();
        }

        @Override
        public void onCacheFileDelete(CacheFile cacheFile) {
            CacheService.this.cacheFilesEventsQueue.offer(new CacheFileEvent(CacheFileEventType.DELETE, cacheFile));
            CacheService.this.numberOfCacheFilesEvents.incrementAndGet();
        }
    }

    class CacheSynchronizationTask
    extends AbstractAsyncTask {
        CacheSynchronizationTask(ThreadPool threadPool, TimeValue interval) {
            super(logger, Objects.requireNonNull(threadPool), Objects.requireNonNull(interval), true);
        }

        protected boolean mustReschedule() {
            return true;
        }

        public void runInternal() {
            CacheService.this.synchronizeCache();
        }

        protected String getThreadPool() {
            return "generic";
        }

        public String toString() {
            return "cache_synchronization_task";
        }
    }

    public static class CacheFileEvent {
        public final CacheFileEventType type;
        public final CacheFile value;

        private CacheFileEvent(CacheFileEventType type, CacheFile value) {
            assert (type != null);
            this.type = type;
            assert (value != null);
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheFileEvent event = (CacheFileEvent)o;
            return this.type == event.type && this.value == event.value;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.value});
        }

        public String toString() {
            return "cache file event [type=" + (Object)((Object)this.type) + ", value=" + this.value + ']';
        }
    }

    private static enum CacheFileEventType {
        NEEDS_FSYNC,
        DELETE;

    }
}

