/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.rest.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.idp.action.SamlValidateAuthnRequestAction;
import org.elasticsearch.xpack.idp.action.SamlValidateAuthnRequestRequest;
import org.elasticsearch.xpack.idp.action.SamlValidateAuthnRequestResponse;
import org.elasticsearch.xpack.idp.saml.rest.action.IdpBaseRestHandler;

public class RestSamlValidateAuthenticationRequestAction
extends IdpBaseRestHandler {
    static final ObjectParser<SamlValidateAuthnRequestRequest, Void> PARSER = new ObjectParser("idp_validate_authn_request", SamlValidateAuthnRequestRequest::new);

    public RestSamlValidateAuthenticationRequestAction(XPackLicenseState licenseState) {
        super(licenseState);
    }

    public String getName() {
        return "saml_idp_validate_authn_request_action";
    }

    public List<RestHandler.Route> routes() {
        return org.elasticsearch.core.List.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/_idp/saml/validate"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            SamlValidateAuthnRequestRequest validateRequest = (SamlValidateAuthnRequestRequest)((Object)PARSER.parse(parser, null));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)SamlValidateAuthnRequestAction.INSTANCE, (ActionRequest)validateRequest, (ActionListener)new RestBuilderListener<SamlValidateAuthnRequestResponse>(channel){

                public RestResponse buildResponse(SamlValidateAuthnRequestResponse response, XContentBuilder builder) throws Exception {
                    builder.startObject();
                    builder.startObject("service_provider");
                    builder.field("entity_id", response.getSpEntityId());
                    builder.field("acs", response.getAssertionConsumerService());
                    builder.endObject();
                    builder.field("force_authn", response.isForceAuthn());
                    builder.field("authn_state", response.getAuthnState());
                    builder.endObject();
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareString(SamlValidateAuthnRequestRequest::setQueryString, new ParseField("authn_request_query", new String[0]));
    }
}

