/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalMax;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.aggregatemetric.aggregations.support.AggregateMetricsValuesSource;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateDoubleMetricFieldMapper;

class AggregateMetricBackedMaxAggregator
extends NumericMetricsAggregator.SingleValue {
    private final AggregateMetricsValuesSource.AggregateDoubleMetric valuesSource;
    final DocValueFormat formatter;
    DoubleArray maxes;

    AggregateMetricBackedMaxAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        AggregateMetricsValuesSource.AggregateDoubleMetric aggregateDoubleMetric = this.valuesSource = config.hasValues() ? (AggregateMetricsValuesSource.AggregateDoubleMetric)config.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.maxes = context.bigArrays().newDoubleArray(1L, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }
        this.formatter = config.format();
    }

    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.bigArrays();
        SortedNumericDoubleValues allValues = this.valuesSource.getAggregateMetricValues(ctx, AggregateDoubleMetricFieldMapper.Metric.max);
        final NumericDoubleValues values = MultiValueMode.MAX.select(allValues);
        return new LeafBucketCollectorBase(sub, allValues){

            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= AggregateMetricBackedMaxAggregator.this.maxes.size()) {
                    long from = AggregateMetricBackedMaxAggregator.this.maxes.size();
                    AggregateMetricBackedMaxAggregator.this.maxes = bigArrays.grow(AggregateMetricBackedMaxAggregator.this.maxes, bucket + 1L);
                    AggregateMetricBackedMaxAggregator.this.maxes.fill(from, AggregateMetricBackedMaxAggregator.this.maxes.size(), Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    double value = values.doubleValue();
                    double max = AggregateMetricBackedMaxAggregator.this.maxes.get(bucket);
                    max = Math.max(max, value);
                    AggregateMetricBackedMaxAggregator.this.maxes.set(bucket, max);
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.maxes.size()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.maxes.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.maxes.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalMax(this.name, this.maxes.get(bucket), this.formatter, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalMax(this.name, Double.NEGATIVE_INFINITY, this.formatter, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable)this.maxes);
    }
}

