/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.Timer;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

class Benchmark {
    protected Benchmark() {
        throw new RuntimeException("Non instantiable");
    }

    public static void benchmark(int n, int n2, String string, boolean bl, int n3, double d2, double d3, double d4) {
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer timer4 = new Timer();
        Timer timer5 = new Timer();
        Timer timer6 = new Timer();
        DoubleMatrix2D doubleMatrix2D = null;
        if (string.equals("sparse")) {
            doubleMatrix2D = new SparseDoubleMatrix2D(n2, n2, n3, d2, d3);
        } else if (string.equals("dense")) {
            doubleMatrix2D = DoubleFactory2D.dense.make(n2, n2);
        } else {
            throw new RuntimeException("unknown kind");
        }
        System.out.println("\nNow initializing...");
        double d5 = 2.0;
        DoubleMatrix2D doubleMatrix2D2 = DoubleFactory2D.dense.sample(doubleMatrix2D.rows(), doubleMatrix2D.columns(), d5, d4);
        doubleMatrix2D.assign(doubleMatrix2D2);
        doubleMatrix2D2 = null;
        System.out.println("\ntesting...");
        if (bl) {
            System.out.println(doubleMatrix2D);
        }
        DoubleMatrix2D doubleMatrix2D3 = DoubleFactory2D.dense.make(n2, n2);
        doubleMatrix2D3.assign(doubleMatrix2D);
        if (!doubleMatrix2D3.equals(doubleMatrix2D)) {
            throw new InternalError();
        }
        DoubleMatrix2D doubleMatrix2D4 = doubleMatrix2D3.copy();
        DoubleMatrix2D doubleMatrix2D5 = doubleMatrix2D3.copy();
        DoubleMatrix2D doubleMatrix2D6 = doubleMatrix2D3.copy();
        doubleMatrix2D4.zMult(doubleMatrix2D5, doubleMatrix2D6);
        System.out.println("\nNext testing...");
        DoubleMatrix2D doubleMatrix2D7 = doubleMatrix2D.copy();
        DoubleMatrix2D doubleMatrix2D8 = doubleMatrix2D.copy();
        DoubleMatrix2D doubleMatrix2D9 = doubleMatrix2D.copy();
        doubleMatrix2D7.zMult(doubleMatrix2D8, doubleMatrix2D9);
        if (!doubleMatrix2D9.equals(doubleMatrix2D6)) {
            throw new InternalError();
        }
        doubleMatrix2D9.assign(doubleMatrix2D);
        System.out.println("\nNow benchmarking...");
        timer3.start();
        int n4 = 0;
        while (n4 < n) {
            doubleMatrix2D7.zMult(doubleMatrix2D8, doubleMatrix2D9);
            ++n4;
        }
        timer3.stop();
        timer3.display();
        int n5 = doubleMatrix2D7.rows();
        int n6 = doubleMatrix2D7.columns();
        int n7 = doubleMatrix2D8.rows();
        int n8 = n;
        double d6 = 0.001 * (2.0 * (double)n5 * (double)n6 * (double)n7 * (double)n8) / (double)timer3.millis();
        System.out.println("mflops: " + d6);
        if (bl) {
            System.out.println(doubleMatrix2D);
        }
        System.out.println("bye bye.");
    }

    protected static double cubicLoop(int n, int n2) {
        double d2 = 1.123;
        double d3 = 1.000000000012345;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2;
            while (--n4 >= 0) {
                int n5 = n2;
                while (--n5 >= 0) {
                    int n6 = n2;
                    while (--n6 >= 0) {
                        d2 *= d3;
                    }
                }
            }
            ++n3;
        }
        return d2;
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        String string = stringArray[3];
        int n4 = Integer.parseInt(stringArray[4]);
        double d2 = new Double(stringArray[5]);
        double d3 = new Double(stringArray[6]);
        boolean bl = stringArray[7].equals("print");
        double d4 = new Double(stringArray[8]);
        int n5 = n2;
        Benchmark.benchmark(n, n5, string, bl, n4, d2, d3, d4);
    }
}

