/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.Double27Function;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SelectedDenseDoubleMatrix3D;

public class DenseDoubleMatrix3D
extends DoubleMatrix3D {
    protected double[] elements;

    public DenseDoubleMatrix3D(double[][][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length, dArray.length == 0 ? 0 : (dArray[0].length == 0 ? 0 : dArray[0][0].length));
        this.assign(dArray);
    }

    public DenseDoubleMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = new double[n * n2 * n3];
    }

    protected DenseDoubleMatrix3D(int n, int n2, int n3, double[] dArray, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = dArray;
        this.isNoView = false;
    }

    public DoubleMatrix3D assign(double[][][] dArray) {
        if (this.isNoView) {
            if (dArray.length != this.slices) {
                throw new IllegalArgumentException("Must have same number of slices: slices=" + dArray.length + "slices()=" + this.slices());
            }
            int n = this.slices * this.rows * this.columns - this.columns;
            int n2 = this.slices;
            while (--n2 >= 0) {
                double[][] dArray2 = dArray[n2];
                if (dArray2.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray2.length + "rows()=" + this.rows());
                }
                int n3 = this.rows;
                while (--n3 >= 0) {
                    double[] dArray3 = dArray2[n3];
                    if (dArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray3.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(dArray3, 0, this.elements, n, this.columns);
                    n -= this.columns;
                }
            }
        } else {
            super.assign(dArray);
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleMatrix3D doubleMatrix3D) {
        if (!(doubleMatrix3D instanceof DenseDoubleMatrix3D)) {
            return super.assign(doubleMatrix3D);
        }
        DenseDoubleMatrix3D denseDoubleMatrix3D = (DenseDoubleMatrix3D)doubleMatrix3D;
        if (denseDoubleMatrix3D == this) {
            return this;
        }
        this.checkShape(denseDoubleMatrix3D);
        if (this.haveSharedCells(denseDoubleMatrix3D)) {
            DoubleMatrix3D doubleMatrix3D2 = denseDoubleMatrix3D.copy();
            if (!(doubleMatrix3D2 instanceof DenseDoubleMatrix3D)) {
                return super.assign(doubleMatrix3D);
            }
            denseDoubleMatrix3D = (DenseDoubleMatrix3D)doubleMatrix3D2;
        }
        if (this.isNoView && denseDoubleMatrix3D.isNoView) {
            System.arraycopy(denseDoubleMatrix3D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(denseDoubleMatrix3D);
    }

    public double getQuick(int n, int n2, int n3) {
        return this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride];
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D instanceof SelectedDenseDoubleMatrix3D) {
            SelectedDenseDoubleMatrix3D selectedDenseDoubleMatrix3D = (SelectedDenseDoubleMatrix3D)doubleMatrix3D;
            return this.elements == selectedDenseDoubleMatrix3D.elements;
        }
        if (doubleMatrix3D instanceof DenseDoubleMatrix3D) {
            DenseDoubleMatrix3D denseDoubleMatrix3D = (DenseDoubleMatrix3D)doubleMatrix3D;
            return this.elements == denseDoubleMatrix3D.elements;
        }
        return false;
    }

    protected int index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    public DoubleMatrix3D like(int n, int n2, int n3) {
        return new DenseDoubleMatrix3D(n, n2, n3);
    }

    protected DoubleMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseDoubleMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    public void setQuick(int n, int n2, int n3, double d2) {
        this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride] = d2;
    }

    protected DoubleMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseDoubleMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }

    public void zAssign27Neighbors(DoubleMatrix3D doubleMatrix3D, Double27Function double27Function) {
        if (!(doubleMatrix3D instanceof DenseDoubleMatrix3D)) {
            super.zAssign27Neighbors(doubleMatrix3D, double27Function);
            return;
        }
        if (double27Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(doubleMatrix3D);
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        DenseDoubleMatrix3D denseDoubleMatrix3D = (DenseDoubleMatrix3D)doubleMatrix3D;
        int n3 = this.sliceStride;
        int n4 = this.rowStride;
        int n5 = denseDoubleMatrix3D.rowStride;
        int n6 = this.columnStride;
        int n7 = denseDoubleMatrix3D.columnStride;
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix3D.elements;
        if (dArray == null || dArray2 == null) {
            throw new InternalError();
        }
        int n8 = 1;
        while (n8 < this.slices - 1) {
            int n9 = this.index(n8, 1, 1);
            int n10 = denseDoubleMatrix3D.index(n8, 1, 1);
            int n11 = 1;
            while (n11 < n) {
                int n12 = n9 - n3 - n4 - n6;
                int n13 = n12 + n4;
                int n14 = n13 + n4;
                int n15 = n12 + n3;
                int n16 = n15 + n4;
                int n17 = n16 + n4;
                int n18 = n15 + n3;
                int n19 = n18 + n4;
                int n20 = n19 + n4;
                double d2 = dArray[n12];
                double d3 = dArray[n12 += n6];
                double d4 = dArray[n13];
                double d5 = dArray[n13 += n6];
                double d6 = dArray[n14];
                double d7 = dArray[n14 += n6];
                double d8 = dArray[n15];
                double d9 = dArray[n15 += n6];
                double d10 = dArray[n16];
                double d11 = dArray[n16 += n6];
                double d12 = dArray[n17];
                double d13 = dArray[n17 += n6];
                double d14 = dArray[n18];
                double d15 = dArray[n18 += n6];
                double d16 = dArray[n19];
                double d17 = dArray[n19 += n6];
                double d18 = dArray[n20];
                double d19 = dArray[n20 += n6];
                int n21 = n10;
                int n22 = 1;
                while (n22 < n2) {
                    double d20 = dArray[n12 += n6];
                    double d21 = dArray[n13 += n6];
                    double d22 = dArray[n14 += n6];
                    double d23 = dArray[n15 += n6];
                    double d24 = dArray[n16 += n6];
                    double d25 = dArray[n17 += n6];
                    double d26 = dArray[n18 += n6];
                    double d27 = dArray[n19 += n6];
                    double d28 = dArray[n20 += n6];
                    dArray2[n21] = double27Function.apply(d2, d3, d20, d4, d5, d21, d6, d7, d22, d8, d9, d23, d10, d11, d24, d12, d13, d25, d14, d15, d26, d16, d17, d27, d18, d19, d28);
                    n21 += n7;
                    d2 = d3;
                    d3 = d20;
                    d4 = d5;
                    d5 = d21;
                    d6 = d7;
                    d7 = d22;
                    d8 = d9;
                    d9 = d23;
                    d10 = d11;
                    d11 = d24;
                    d12 = d13;
                    d13 = d25;
                    d14 = d15;
                    d15 = d26;
                    d16 = d17;
                    d17 = d27;
                    d18 = d19;
                    d19 = d28;
                    ++n22;
                }
                n9 += n4;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }
}

