/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.math.Arithmetic;
import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.AbstractDistribution;
import cern.jet.stat.Probability;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Binomial
extends AbstractDiscreteDistribution {
    protected int n;
    protected double p;
    private int n_last = -1;
    private int n_prev = -1;
    private double par;
    private double np;
    private double p0;
    private double q;
    private double p_last = -1.0;
    private double p_prev = -1.0;
    private int b;
    private int m;
    private int nm;
    private double pq;
    private double rc;
    private double ss;
    private double xm;
    private double xl;
    private double xr;
    private double ll;
    private double lr;
    private double c;
    private double p1;
    private double p2;
    private double p3;
    private double p4;
    private double ch;
    private double log_p;
    private double log_q;
    private double log_n;
    protected static Binomial shared = new Binomial(1, 0.5, AbstractDistribution.makeDefaultGenerator());

    public Binomial(int n, double d2, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setNandP(n, d2);
    }

    public double cdf(int n) {
        return Probability.binomial(n, this.n, this.p);
    }

    private double cdfSlow(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        double d2 = 0.0;
        int n2 = 0;
        while (n2 <= n) {
            d2 += this.pdf(n2);
            ++n2;
        }
        return d2;
    }

    protected int generateBinomial(int n, double d2) {
        int n2;
        double d3;
        int n3;
        if (n != this.n_last || d2 != this.p_last) {
            this.n_last = n;
            this.p_last = d2;
            this.par = Math.min(d2, 1.0 - d2);
            this.q = 1.0 - this.par;
            this.np = (double)n * this.par;
            if (this.np <= 0.0) {
                return -1;
            }
            double d4 = this.np + this.par;
            this.m = (int)d4;
            if (this.np < 10.0) {
                this.p0 = Math.exp((double)n * Math.log(this.q));
                int n4 = (int)(this.np + 10.0 * Math.sqrt(this.np * this.q));
                this.b = Math.min(n, n4);
            } else {
                this.pq = this.par / this.q;
                this.rc = ((double)n + 1.0) * this.pq;
                this.ss = this.np * this.q;
                n3 = (int)(2.195 * Math.sqrt(this.ss) - 4.6 * this.q);
                this.xm = (double)this.m + 0.5;
                this.xl = this.m - n3;
                this.xr = (long)(this.m + n3) + 1L;
                d3 = (d4 - this.xl) / (d4 - this.xl * this.par);
                this.ll = d3 * (1.0 + 0.5 * d3);
                d3 = (this.xr - d4) / (this.xr * this.q);
                this.lr = d3 * (1.0 + 0.5 * d3);
                this.c = 0.134 + 20.5 / (15.3 + (double)this.m);
                this.p1 = (double)n3 + 0.5;
                this.p2 = this.p1 * (1.0 + this.c + this.c);
                this.p3 = this.p2 + this.c / this.ll;
                this.p4 = this.p3 + this.c / this.lr;
            }
        }
        if (this.np < 10.0) {
            int n5 = 0;
            double d5 = this.p0;
            double d6 = this.randomGenerator.raw();
            while (d6 > d5) {
                if (++n5 > this.b) {
                    d6 = this.randomGenerator.raw();
                    n5 = 0;
                    d5 = this.p0;
                    continue;
                }
                d6 -= d5;
                d5 = (double)(n - n5 + 1) * this.par * d5 / ((double)n5 * this.q);
            }
            return d2 > 0.5 ? n - n5 : n5;
        }
        while (true) {
            int n6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11 = this.randomGenerator.raw();
            double d12 = this.randomGenerator.raw() * this.p4;
            if (d10 <= this.p1) {
                n2 = (int)(this.xm - d12 + this.p1 * d11);
                return d2 > 0.5 ? n - n2 : n2;
            }
            if (d12 <= this.p2) {
                double d13;
                d9 = this.xl + (d12 - this.p1) / this.c;
                d11 = d11 * this.c + 1.0 - Math.abs(this.xm - d9) / this.p1;
                if (d13 >= 1.0) continue;
                n2 = (int)d9;
            } else if (d12 <= this.p3) {
                double d14;
                d9 = this.xl + Math.log(d11) / this.ll;
                if (d14 < 0.0) continue;
                n2 = (int)d9;
                d11 *= (d12 - this.p2) * this.ll;
            } else {
                n2 = (int)(this.xr - Math.log(d11) / this.lr);
                if (n2 > n) continue;
                d11 *= (d12 - this.p3) * this.lr;
            }
            int n7 = Math.abs(n2 - this.m);
            if (n7 <= 20 || (double)((long)(n7 + n7) + 2L) >= this.ss) {
                d3 = 1.0;
                if (this.m < n2) {
                    n3 = this.m;
                    while (n3 < n2) {
                        double d15;
                        d3 *= this.rc / (double)(++n3) - this.pq;
                        if (!(d15 < d11)) {
                            continue;
                        }
                        break;
                    }
                } else {
                    n3 = n2;
                    while (n3 < this.m) {
                        double d16;
                        d11 *= this.rc / (double)(++n3) - this.pq;
                        if (!(d16 > d3)) {
                            continue;
                        }
                        break;
                    }
                }
                if (!(d11 <= d3)) continue;
                break;
            }
            if ((d11 = Math.log(d11)) <= (d8 = (double)(-n7 * n7) / (this.ss + this.ss)) - (d7 = (double)n7 / this.ss * (((double)n7 * ((double)n7 * 0.3333333333333333 + 0.625) + 0.16666666666666666) / this.ss + 0.5))) break;
            if (!(d11 <= d8 + d7)) continue;
            if (n != this.n_prev || this.par != this.p_prev) {
                this.n_prev = n;
                this.p_prev = this.par;
                this.nm = n - this.m + 1;
                this.ch = this.xm * Math.log(((double)this.m + 1.0) / (this.pq * (double)this.nm)) + Arithmetic.stirlingCorrection(this.m + 1) + Arithmetic.stirlingCorrection(this.nm);
            }
            if (d11 <= this.ch + ((double)n + 1.0) * Math.log((double)this.nm / (double)(n6 = n - n2 + 1)) + ((double)n2 + 0.5) * Math.log((double)n6 * this.pq / ((double)n2 + 1.0)) - Arithmetic.stirlingCorrection(n2 + 1) - Arithmetic.stirlingCorrection(n6)) break;
        }
        return d2 > 0.5 ? n - n2 : n2;
    }

    public int nextInt() {
        return this.generateBinomial(this.n, this.p);
    }

    public int nextInt(int n, double d2) {
        if ((double)n * Math.min(d2, 1.0 - d2) <= 0.0) {
            throw new IllegalArgumentException();
        }
        return this.generateBinomial(n, d2);
    }

    public double pdf(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.n - n;
        return Math.exp(this.log_n - Arithmetic.logFactorial(n) - Arithmetic.logFactorial(n2) + this.log_p * (double)n + this.log_q * (double)n2);
    }

    public void setNandP(int n, double d2) {
        if ((double)n * Math.min(d2, 1.0 - d2) <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.n = n;
        this.p = d2;
        this.log_p = Math.log(d2);
        this.log_q = Math.log(1.0 - d2);
        this.log_n = Arithmetic.logFactorial(n);
    }

    public static int staticNextInt(int n, double d2) {
        Binomial binomial = shared;
        synchronized (binomial) {
            int n2 = shared.nextInt(n, d2);
            return n2;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.n + "," + this.p + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        Binomial binomial = shared;
        synchronized (binomial) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

