/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import cern.jet.random.Fun;
import cern.jet.stat.Probability;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Gamma
extends AbstractContinousDistribution {
    protected double alpha;
    protected double lambda;
    protected static Gamma shared = new Gamma(1.0, 1.0, AbstractDistribution.makeDefaultGenerator());

    public Gamma(double d2, double d3, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d2, d3);
    }

    public double cdf(double d2) {
        return Probability.gamma(this.alpha, this.lambda, d2);
    }

    public double nextDouble() {
        return this.nextDouble(this.alpha, this.lambda);
    }

    public double nextDouble(double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12 = d2;
        double d13 = -1.0;
        double d14 = -1.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        double d22 = 0.0416666664;
        double d23 = 0.0208333723;
        double d24 = 0.0079849875;
        double d25 = 0.0015746717;
        double d26 = -3.349403E-4;
        double d27 = 3.340332E-4;
        double d28 = 6.053049E-4;
        double d29 = -4.701849E-4;
        double d30 = 1.71032E-4;
        double d31 = 0.333333333;
        double d32 = -0.249999949;
        double d33 = 0.199999867;
        double d34 = -0.166677482;
        double d35 = 0.142873973;
        double d36 = -0.124385581;
        double d37 = 0.11036831;
        double d38 = -0.112750886;
        double d39 = 0.104089866;
        double d40 = 1.0;
        double d41 = 0.499999994;
        double d42 = 0.166666848;
        double d43 = 0.041664508;
        double d44 = 0.008345522;
        double d45 = 0.001353826;
        double d46 = 2.47453E-4;
        if (d12 <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (d3 <= 0.0) {
            new IllegalArgumentException();
        }
        if (d12 < 1.0) {
            double d47;
            d15 = 1.0 + 0.36788794412 * d12;
            while (true) {
                double d48;
                if ((d48 = d15 * this.randomGenerator.raw()) <= 1.0) {
                    d47 = Math.exp(Math.log(d48) / d12);
                    if (!(Math.log(this.randomGenerator.raw()) <= -d47)) continue;
                    return d47 / d3;
                }
                d47 = -Math.log((d15 - d48) / d12);
                if (Math.log(this.randomGenerator.raw()) <= (d12 - 1.0) * Math.log(d47)) break;
            }
            return d47 / d3;
        }
        if (d12 != d13) {
            d13 = d12;
            d20 = d12 - 0.5;
            d18 = Math.sqrt(d20);
            d17 = 5.656854249 - 12.0 * d18;
        }
        while ((d11 = (d10 = 2.0 * this.randomGenerator.raw() - 1.0) * d10 + (d9 = 2.0 * this.randomGenerator.raw() - 1.0) * d9) > 1.0) {
        }
        double d49 = d10 * Math.sqrt(-2.0 * Math.log(d11) / d11);
        double d50 = d18 + 0.5 * d49;
        double d51 = d50 * d50;
        if (d49 >= 0.0) {
            return d51 / d3;
        }
        double d52 = this.randomGenerator.raw();
        if (d17 * d52 <= d49 * d49 * d49) {
            return d51 / d3;
        }
        if (d12 != d14) {
            d14 = d12;
            double d53 = 1.0 / d12;
            d21 = ((((((((d30 * d53 + d29) * d53 + d28) * d53 + d27) * d53 + d26) * d53 + d25) * d53 + d24) * d53 + d23) * d53 + d22) * d53;
            if (d12 > 3.686) {
                if (d12 > 13.022) {
                    d15 = 1.77;
                    d19 = 0.75;
                    d16 = 0.1515 / d18;
                } else {
                    d15 = 1.654 + 0.0076 * d20;
                    d19 = 1.68 / d18 + 0.275;
                    d16 = 0.062 / d18 + 0.024;
                }
            } else {
                d15 = 0.463 + d18 - 0.178 * d20;
                d19 = 1.235;
                d16 = 0.195 / d18 - 0.079 + 0.016 * d18;
            }
        }
        if (d50 > 0.0) {
            d8 = d49 / (d18 + d18);
            d7 = Math.abs(d8) > 0.25 ? d21 - d18 * d49 + 0.25 * d49 * d49 + (d20 + d20) * Math.log(1.0 + d8) : d21 + 0.5 * d49 * d49 * ((((((((d39 * d8 + d38) * d8 + d37) * d8 + d36) * d8 + d35) * d8 + d34) * d8 + d33) * d8 + d32) * d8 + d31) * d8;
            if (Math.log(1.0 - d52) <= d7) {
                return d51 / d3;
            }
        }
        do {
            d6 = -Math.log(this.randomGenerator.raw());
            d52 = this.randomGenerator.raw();
        } while ((d49 = d15 + d6 * d19 * (d5 = (d52 = d52 + d52 - 1.0) > 0.0 ? 1.0 : -1.0)) <= -0.71874483771719 || (d7 = Math.abs(d8 = d49 / (d18 + d18)) > 0.25 ? d21 - d18 * d49 + 0.25 * d49 * d49 + (d20 + d20) * Math.log(1.0 + d8) : d21 + 0.5 * d49 * d49 * ((((((((d39 * d8 + d38) * d8 + d37) * d8 + d36) * d8 + d35) * d8 + d34) * d8 + d33) * d8 + d32) * d8 + d31) * d8) <= 0.0 || !(d16 * d52 * d5 <= (d4 = d7 > 0.5 ? Math.exp(d7) - 1.0 : ((((((d46 * d7 + d45) * d7 + d44) * d7 + d43) * d7 + d42) * d7 + d41) * d7 + d40) * d7) * Math.exp(d6 - 0.5 * d49 * d49)));
        d50 = d18 + 0.5 * d49;
        return d50 * d50 / d3;
    }

    public double pdf(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException();
        }
        if (d2 == 0.0) {
            if (this.alpha == 1.0) {
                return 1.0 / this.lambda;
            }
            return 0.0;
        }
        if (this.alpha == 1.0) {
            return Math.exp(-d2 / this.lambda) / this.lambda;
        }
        return Math.exp((this.alpha - 1.0) * Math.log(d2 / this.lambda) - d2 / this.lambda - Fun.logGamma(this.alpha)) / this.lambda;
    }

    public void setState(double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.alpha = d2;
        this.lambda = d3;
    }

    public static double staticNextDouble(double d2, double d3) {
        Gamma gamma = shared;
        synchronized (gamma) {
            double d4 = shared.nextDouble(d2, d3);
            return d4;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.alpha + "," + this.lambda + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        Gamma gamma = shared;
        synchronized (gamma) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

