/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.PersistentObject;
import cern.colt.function.DoubleProcedure;
import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import cern.jet.stat.quantile.DoubleQuantileFinder;

class ExactDoubleQuantileFinder
extends PersistentObject
implements DoubleQuantileFinder {
    protected DoubleArrayList buffer = new DoubleArrayList(0);
    protected boolean isSorted;

    public ExactDoubleQuantileFinder() {
        this.clear();
    }

    public void add(double d2) {
        this.buffer.add(d2);
        this.isSorted = false;
    }

    public void addAllOf(DoubleArrayList doubleArrayList) {
        this.addAllOfFromTo(doubleArrayList, 0, doubleArrayList.size() - 1);
    }

    public void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        this.buffer.addAllOfFromTo(doubleArrayList, n, n2);
        this.isSorted = false;
    }

    public void clear() {
        this.buffer.clear();
        this.buffer.trimToSize();
        this.isSorted = false;
    }

    public Object clone() {
        ExactDoubleQuantileFinder exactDoubleQuantileFinder = (ExactDoubleQuantileFinder)super.clone();
        if (this.buffer != null) {
            exactDoubleQuantileFinder.buffer = exactDoubleQuantileFinder.buffer.copy();
        }
        return exactDoubleQuantileFinder;
    }

    public boolean contains(double d2) {
        this.sort();
        return this.buffer.binarySearch(d2) >= 0;
    }

    public boolean forEach(DoubleProcedure doubleProcedure) {
        double[] dArray = this.buffer.elements();
        int n = (int)this.size();
        int n2 = 0;
        while (n2 < n) {
            if (doubleProcedure.apply(dArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public long memory() {
        return this.buffer.elements().length;
    }

    public double phi(double d2) {
        this.sort();
        return Descriptive.rankInterpolated(this.buffer, d2) / (double)this.size();
    }

    public DoubleArrayList quantileElements(DoubleArrayList doubleArrayList) {
        this.sort();
        return Descriptive.quantiles(this.buffer, doubleArrayList);
    }

    public long size() {
        return this.buffer.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            this.buffer.sort();
            this.isSorted = true;
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "(mem=" + this.memory() + ", size=" + this.size() + ")";
    }

    public long totalMemory() {
        return this.memory();
    }
}

