/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.ObjectArrayList;
import cern.jet.random.sampling.WeightedRandomSampler;
import cern.jet.stat.quantile.DoubleBuffer;
import cern.jet.stat.quantile.DoubleQuantileEstimator;
import cern.jet.stat.quantile.Utils;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import java.util.Comparator;

class UnknownDoubleQuantileEstimator
extends DoubleQuantileEstimator {
    protected int currentTreeHeight;
    protected final int treeHeightStartingSampling;
    protected WeightedRandomSampler sampler;
    protected double precomputeEpsilon;

    public UnknownDoubleQuantileEstimator(int n, int n2, int n3, double d2, RandomElement randomElement) {
        this.sampler = new WeightedRandomSampler(1, randomElement);
        this.setUp(n, n2);
        this.treeHeightStartingSampling = n3;
        this.precomputeEpsilon = d2;
        this.clear();
    }

    protected DoubleBuffer[] buffersToCollapse() {
        DoubleBuffer[] doubleBufferArray = this.bufferSet._getFullOrPartialBuffers();
        UnknownDoubleQuantileEstimator.sortAscendingByLevel(doubleBufferArray);
        int n = doubleBufferArray[1].level();
        if (doubleBufferArray[0].level() < n) {
            doubleBufferArray[0].level(n);
        }
        return this.bufferSet._getFullOrPartialBuffersWithLevel(n);
    }

    public synchronized void clear() {
        super.clear();
        this.currentTreeHeight = 1;
        this.sampler.setWeight(1);
    }

    public Object clone() {
        UnknownDoubleQuantileEstimator unknownDoubleQuantileEstimator = (UnknownDoubleQuantileEstimator)super.clone();
        if (this.sampler != null) {
            unknownDoubleQuantileEstimator.sampler = (WeightedRandomSampler)unknownDoubleQuantileEstimator.sampler.clone();
        }
        return unknownDoubleQuantileEstimator;
    }

    protected void newBuffer() {
        this.currentBufferToFill = this.bufferSet._getFirstEmptyBuffer();
        if (this.currentBufferToFill == null) {
            throw new RuntimeException("Oops, no empty buffer.");
        }
        this.currentBufferToFill.level(this.currentTreeHeight - 1);
        this.currentBufferToFill.weight(this.sampler.getWeight());
    }

    protected void postCollapse(DoubleBuffer[] doubleBufferArray) {
        if (doubleBufferArray.length == this.bufferSet.b()) {
            ++this.currentTreeHeight;
            if (this.currentTreeHeight >= this.treeHeightStartingSampling) {
                this.sampler.setWeight(this.sampler.getWeight() * 2);
            }
        }
    }

    public DoubleArrayList quantileElements(DoubleArrayList doubleArrayList) {
        if (this.precomputeEpsilon <= 0.0) {
            return super.quantileElements(doubleArrayList);
        }
        int n = (int)Utils.epsilonCeiling(1.0 / this.precomputeEpsilon);
        doubleArrayList = doubleArrayList.copy();
        double d2 = this.precomputeEpsilon;
        int n2 = doubleArrayList.size();
        while (--n2 >= 0) {
            double d3 = doubleArrayList.get(n2);
            int n3 = (int)Math.round((2.0 * d3 / d2 - 1.0) / 2.0);
            n3 = Math.min(n - 1, Math.max(0, n3));
            double d4 = d2 / 2.0 * (double)(1 + 2 * n3);
            doubleArrayList.set(n2, d4);
        }
        return super.quantileElements(doubleArrayList);
    }

    protected boolean sampleNextElement() {
        return this.sampler.sampleNextElement();
    }

    protected static void sortAscendingByLevel(DoubleBuffer[] doubleBufferArray) {
        new ObjectArrayList(doubleBufferArray).quickSortFromTo(0, doubleBufferArray.length - 1, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((DoubleBuffer)object).level();
                return n2 < (n = ((DoubleBuffer)object2).level()) ? -1 : (n2 == n ? 0 : 1);
            }
        });
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer + ", h=" + this.currentTreeHeight + ", hStartSampling=" + this.treeHeightStartingSampling + ", precomputeEpsilon=" + this.precomputeEpsilon + ")";
    }
}

