/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import edu.oswego.cs.dl.util.concurrent.Channel;
import edu.oswego.cs.dl.util.concurrent.Executor;
import edu.oswego.cs.dl.util.concurrent.SynchronousChannel;
import edu.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PooledExecutor
extends ThreadFactoryUser
implements Executor {
    public static final int DEFAULT_MAXIMUMPOOLSIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 1;
    public static final long DEFAULT_KEEPALIVETIME = 60000L;
    protected int maximumPoolSize_ = Integer.MAX_VALUE;
    protected int minimumPoolSize_ = 1;
    protected int poolSize_ = 0;
    protected long keepAliveTime_ = 60000L;
    protected boolean shutdown_ = false;
    protected final Channel handOff_;
    protected final Map threads_;
    protected BlockedExecutionHandler blockedExecutionHandler_;

    public PooledExecutor() {
        this(new SynchronousChannel(), Integer.MAX_VALUE);
    }

    public PooledExecutor(int n) {
        this(new SynchronousChannel(), n);
    }

    public PooledExecutor(Channel channel) {
        this(channel, Integer.MAX_VALUE);
    }

    public PooledExecutor(Channel channel, int n) {
        this.maximumPoolSize_ = n;
        this.handOff_ = channel;
        this.runWhenBlocked();
        this.threads_ = new HashMap();
    }

    public synchronized int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public synchronized void setMaximumPoolSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = n;
    }

    public synchronized int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public synchronized void setMinimumPoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = n;
    }

    public synchronized int getPoolSize() {
        return this.poolSize_;
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public synchronized void setKeepAliveTime(long l) {
        this.keepAliveTime_ = l;
    }

    protected synchronized BlockedExecutionHandler getBlockedExecutionHandler() {
        return this.blockedExecutionHandler_;
    }

    protected synchronized void setBlockedExecutionHandler(BlockedExecutionHandler blockedExecutionHandler) {
        this.blockedExecutionHandler_ = blockedExecutionHandler;
    }

    protected void addThread(Runnable runnable) {
        Worker worker = new Worker(runnable);
        Thread thread = this.getThreadFactory().newThread(worker);
        this.threads_.put(worker, thread);
        ++this.poolSize_;
        thread.start();
    }

    public int createThreads(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            PooledExecutor pooledExecutor = this;
            synchronized (pooledExecutor) {
                if (this.poolSize_ < this.maximumPoolSize_) {
                    this.addThread(null);
                    ++n2;
                } else {
                    break;
                }
            }
            ++n3;
        }
        return n2;
    }

    public synchronized void interruptAll() {
        Iterator iterator = this.threads_.values().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            thread.interrupt();
        }
    }

    public void shutdownNow() {
        this.shutdownNow(new DiscardWhenBlocked());
    }

    public synchronized void shutdownNow(BlockedExecutionHandler blockedExecutionHandler) {
        this.setBlockedExecutionHandler(blockedExecutionHandler);
        this.shutdown_ = true;
        this.maximumPoolSize_ = 0;
        this.minimumPoolSize_ = 0;
        this.interruptAll();
    }

    public void shutdownAfterProcessingCurrentlyQueuedTasks() {
        this.shutdownAfterProcessingCurrentlyQueuedTasks(new DiscardWhenBlocked());
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks(BlockedExecutionHandler blockedExecutionHandler) {
        this.setBlockedExecutionHandler(blockedExecutionHandler);
        this.shutdown_ = true;
        if (this.poolSize_ == 0) {
            this.maximumPoolSize_ = 0;
            this.minimumPoolSize_ = 0;
        }
    }

    public synchronized boolean isTerminatedAfterShutdown() {
        return this.shutdown_ && this.poolSize_ == 0;
    }

    public synchronized boolean awaitTerminationAfterShutdown(long l) throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        if (this.poolSize_ == 0) {
            return true;
        }
        long l2 = l;
        if (l2 <= 0L) {
            return false;
        }
        long l3 = System.currentTimeMillis();
        do {
            this.wait(l2);
            if (this.poolSize_ != 0) continue;
            return true;
        } while ((l2 = l - (System.currentTimeMillis() - l3)) > 0L);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void awaitTerminationAfterShutdown() throws InterruptedException {
        if (this.shutdown_) ** GOTO lbl4
        throw new IllegalStateException();
lbl-1000:
        // 1 sources

        {
            this.wait();
lbl4:
            // 2 sources

            ** while (this.poolSize_ > 0)
        }
lbl5:
        // 1 sources

    }

    public List drain() {
        boolean bl = false;
        Vector<Object> vector = new Vector<Object>();
        while (true) {
            try {
                Object object;
                while ((object = this.handOff_.poll(0L)) != null) {
                    vector.addElement(object);
                }
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return vector;
    }

    protected synchronized void workerDone(Worker worker) {
        this.threads_.remove(worker);
        if (--this.poolSize_ == 0 && this.shutdown_) {
            this.minimumPoolSize_ = 0;
            this.maximumPoolSize_ = 0;
            this.notifyAll();
        }
    }

    protected Runnable getTask() throws InterruptedException {
        long l;
        PooledExecutor pooledExecutor = this;
        synchronized (pooledExecutor) {
            if (this.poolSize_ > this.maximumPoolSize_) {
                Runnable runnable = null;
                return runnable;
            }
            l = this.shutdown_ ? 0L : this.keepAliveTime_;
        }
        if (l >= 0L) {
            return (Runnable)this.handOff_.poll(l);
        }
        return (Runnable)this.handOff_.take();
    }

    public void runWhenBlocked() {
        this.setBlockedExecutionHandler(new RunWhenBlocked());
    }

    public void waitWhenBlocked() {
        this.setBlockedExecutionHandler(new WaitWhenBlocked());
    }

    public void discardWhenBlocked() {
        this.setBlockedExecutionHandler(new DiscardWhenBlocked());
    }

    public void abortWhenBlocked() {
        this.setBlockedExecutionHandler(new AbortWhenBlocked());
    }

    public void discardOldestWhenBlocked() {
        this.setBlockedExecutionHandler(new DiscardOldestWhenBlocked());
    }

    public void execute(Runnable runnable) throws InterruptedException {
        do {
            PooledExecutor pooledExecutor = this;
            synchronized (pooledExecutor) {
                if (!this.shutdown_) {
                    int n = this.poolSize_;
                    if (n < this.minimumPoolSize_) {
                        this.addThread(runnable);
                        return;
                    }
                    if (this.handOff_.offer(runnable, 0L)) {
                        return;
                    }
                    if (n < this.maximumPoolSize_) {
                        this.addThread(runnable);
                        return;
                    }
                }
            }
        } while (!this.getBlockedExecutionHandler().blockedAction(runnable));
    }

    protected class DiscardOldestWhenBlocked
    implements BlockedExecutionHandler {
        protected DiscardOldestWhenBlocked() {
        }

        public boolean blockedAction(Runnable runnable) throws InterruptedException {
            PooledExecutor.this.handOff_.poll(0L);
            if (!PooledExecutor.this.handOff_.offer(runnable, 0L)) {
                runnable.run();
            }
            return true;
        }
    }

    protected class AbortWhenBlocked
    implements BlockedExecutionHandler {
        protected AbortWhenBlocked() {
        }

        public boolean blockedAction(Runnable runnable) {
            throw new RuntimeException("Pool is blocked");
        }
    }

    protected class DiscardWhenBlocked
    implements BlockedExecutionHandler {
        protected DiscardWhenBlocked() {
        }

        public boolean blockedAction(Runnable runnable) {
            return true;
        }
    }

    protected class WaitWhenBlocked
    implements BlockedExecutionHandler {
        protected WaitWhenBlocked() {
        }

        public boolean blockedAction(Runnable runnable) throws InterruptedException {
            PooledExecutor.this.handOff_.put(runnable);
            return true;
        }
    }

    protected class RunWhenBlocked
    implements BlockedExecutionHandler {
        protected RunWhenBlocked() {
        }

        public boolean blockedAction(Runnable runnable) {
            runnable.run();
            return true;
        }
    }

    protected static interface BlockedExecutionHandler {
        public boolean blockedAction(Runnable var1) throws InterruptedException;
    }

    protected class Worker
    implements Runnable {
        protected Runnable firstTask_;

        protected Worker(Runnable runnable) {
            this.firstTask_ = runnable;
        }

        public void run() {
            try {
                try {
                    Runnable runnable = this.firstTask_;
                    this.firstTask_ = null;
                    if (runnable != null) {
                        runnable.run();
                    }
                    while ((runnable = PooledExecutor.this.getTask()) != null) {
                        runnable.run();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Object var3_4 = null;
                    PooledExecutor.this.workerDone(this);
                }
                Object var3_3 = null;
                PooledExecutor.this.workerDone(this);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                PooledExecutor.this.workerDone(this);
                throw throwable;
            }
        }
    }
}

