/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import nom.tam.fits.Data;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.HeaderOrder;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.Cursor;
import nom.tam.util.HashedList;
import nom.tam.util.RandomAccess;

public class Header
implements FitsElement {
    private HashedList cards = new HashedList();
    private Cursor iter = this.cards.iterator(0);
    private long fileOffset = -1L;
    private List<HeaderCard> duplicates;
    private ArrayDataInput input;
    private int originalCardCount = 0;
    private static boolean longStringsEnabled = false;

    public Header() {
    }

    public static void setLongStringsEnabled(boolean flag) {
        longStringsEnabled = flag;
    }

    public static boolean getLongStringsEnabled() {
        return longStringsEnabled;
    }

    public Header(ArrayDataInput is) throws TruncatedFileException, IOException {
        this.read(is);
    }

    public Header(String[] newCards) {
        int i = 0;
        while (i < newCards.length) {
            HeaderCard card = new HeaderCard(newCards[i]);
            if (card.getValue() == null) {
                this.cards.add(card);
            } else {
                this.cards.add(card.getKey(), card);
            }
            ++i;
        }
    }

    public Header(Data o) throws FitsException {
        o.fillHeader(this);
    }

    public Data makeData() throws FitsException {
        return FitsFactory.dataFactory(this);
    }

    public long getOriginalSize() {
        return FitsUtil.addPadding(this.originalCardCount * 80);
    }

    public void resetOriginalSize() {
        this.originalCardCount = this.cards.size();
    }

    public void updateLine(String key, HeaderCard card) throws HeaderCardException {
        this.removeCard(key);
        this.iter.add(key, card);
    }

    public void updateLines(Header newHdr) throws HeaderCardException {
        Cursor j = newHdr.iterator();
        while (j.hasNext()) {
            HeaderCard nextHCard = (HeaderCard)j.next();
            if (nextHCard.getKey().startsWith("COMMENT")) {
                this.insertComment(nextHCard.getComment());
                continue;
            }
            this.updateLine(nextHCard.getKey(), nextHCard);
        }
    }

    public int getNumberOfCards() {
        return this.cards.size();
    }

    public Cursor iterator() {
        return this.cards.iterator(0);
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    int trueDataSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        int naxis = this.getIntValue("NAXIS", 0);
        int bitpix = this.getIntValue("BITPIX");
        int[] axes = new int[naxis];
        int axis = 1;
        while (axis <= naxis) {
            axes[axis - 1] = this.getIntValue("NAXIS" + axis, 0);
            ++axis;
        }
        boolean isGroup = this.getBooleanValue("GROUPS", false);
        int pcount = this.getIntValue("PCOUNT", 0);
        int gcount = this.getIntValue("GCOUNT", 1);
        int startAxis = 0;
        if (isGroup && naxis > 1 && axes[0] == 0) {
            startAxis = 1;
        }
        int size = 1;
        int i = startAxis;
        while (i < naxis) {
            size *= axes[i];
            ++i;
        }
        size += pcount;
        size *= gcount;
        return size *= Math.abs(this.getIntValue("BITPIX", 0)) / 8;
    }

    public long getDataSize() {
        return FitsUtil.addPadding(this.trueDataSize());
    }

    @Override
    public long getSize() {
        return this.headerSize();
    }

    int headerSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        return FitsUtil.addPadding(this.cards.size() * 80);
    }

    /*
     * Unable to fully structure code
     */
    boolean isValidHeader() {
        if (this.getNumberOfCards() < 4) {
            return false;
        }
        this.iter = this.iterator();
        key = ((HeaderCard)this.iter.next()).getKey();
        if (!key.equals("SIMPLE") && !key.equals("XTENSION")) {
            return false;
        }
        key = ((HeaderCard)this.iter.next()).getKey();
        if (!key.equals("BITPIX")) {
            return false;
        }
        key = ((HeaderCard)this.iter.next()).getKey();
        if (key.equals("NAXIS")) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            key = ((HeaderCard)this.iter.next()).getKey();
lbl14:
            // 2 sources

            ** while (this.iter.hasNext())
        }
lbl15:
        // 1 sources

        return key.equals("END") != false;
    }

    public HeaderCard findCard(String key) {
        HeaderCard card = (HeaderCard)this.cards.get(key);
        if (card != null) {
            this.iter.setKey(key);
        }
        return card;
    }

    public int getIntValue(String key, int dft) {
        return (int)this.getLongValue(key, dft);
    }

    public int getIntValue(String key) {
        return (int)this.getLongValue(key);
    }

    public long getLongValue(String key) {
        return this.getLongValue(key, 0L);
    }

    public long getLongValue(String key, long dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        try {
            String v = fcard.getValue();
            if (v != null) {
                return Long.parseLong(v);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return dft;
    }

    public float getFloatValue(String key, float dft) {
        return (float)this.getDoubleValue(key, dft);
    }

    public float getFloatValue(String key) {
        return (float)this.getDoubleValue(key);
    }

    public double getDoubleValue(String key) {
        return this.getDoubleValue(key, 0.0);
    }

    public double getDoubleValue(String key, double dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        try {
            String v = fcard.getValue();
            if (v != null) {
                return new Double(v);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return dft;
    }

    public boolean getBooleanValue(String key) {
        return this.getBooleanValue(key, false);
    }

    public boolean getBooleanValue(String key, boolean dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        String val = fcard.getValue();
        if (val == null) {
            return dft;
        }
        if (val.equals("T")) {
            return true;
        }
        if (val.equals("F")) {
            return false;
        }
        return dft;
    }

    public String getStringValue(String key) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null || !fcard.isStringValue()) {
            return null;
        }
        String val = fcard.getValue();
        boolean append = longStringsEnabled && val != null && val.endsWith("&");
        this.iter.next();
        while (append) {
            HeaderCard nxt = (HeaderCard)this.iter.next();
            if (nxt == null) {
                append = false;
                continue;
            }
            key = nxt.getKey();
            String comm = nxt.getComment();
            if (key == null || comm == null || !key.equals("CONTINUE")) {
                append = false;
                continue;
            }
            if ((comm = this.continueString(comm)) == null) continue;
            comm = comm.substring(1, comm.length() - 1);
            val = String.valueOf(val.substring(0, val.length() - 1)) + comm;
            append = comm.endsWith("&");
        }
        return val;
    }

    public void addLine(HeaderCard fcard) {
        if (fcard != null) {
            if (fcard.isKeyValuePair()) {
                this.iter.add(fcard.getKey(), fcard);
            } else {
                this.iter.add(fcard);
            }
        }
    }

    public void addLine(String card) throws HeaderCardException {
        this.addLine(new HeaderCard(card));
    }

    public static Header readHeader(ArrayDataInput dis) throws TruncatedFileException, IOException {
        Header myHeader = new Header();
        try {
            myHeader.read(dis);
        }
        catch (EOFException e2) {
            return null;
        }
        return myHeader;
    }

    @Override
    public void read(ArrayDataInput dis) throws TruncatedFileException, IOException {
        int count;
        block17: {
            this.fileOffset = dis instanceof RandomAccess ? FitsUtil.findOffset(dis) : -1L;
            byte[] buffer = new byte[80];
            boolean firstCard = true;
            count = 0;
            try {
                String cbuf;
                do {
                    String key;
                    int need = 80;
                    try {
                        while (need > 0) {
                            int len = dis.read(buffer, 80 - need, need);
                            ++count;
                            if (len == 0) {
                                throw new TruncatedFileException();
                            }
                            need -= len;
                        }
                    }
                    catch (EOFException e2) {
                        if (firstCard && (need == 80 || this.fileOffset > 0L && FitsFactory.getAllowTerminalJunk())) {
                            throw e2;
                        }
                        throw new TruncatedFileException(e2.getMessage());
                    }
                    cbuf = AsciiFuncs.asciiString(buffer);
                    HeaderCard fcard = new HeaderCard(cbuf);
                    if (firstCard) {
                        key = fcard.getKey();
                        if (key == null || !key.equals("SIMPLE") && !key.equals("XTENSION")) {
                            if (this.fileOffset > 0L && FitsFactory.getAllowTerminalJunk()) {
                                throw new EOFException("Not FITS format at " + this.fileOffset + ":" + cbuf);
                            }
                            throw new IOException("Not FITS format at " + this.fileOffset + ":" + cbuf);
                        }
                        firstCard = false;
                    }
                    if ((key = fcard.getKey()) != null && this.cards.containsKey(key)) {
                        System.err.println("Warning: multiple occurrences of key:" + key);
                        this.addDuplicate((HeaderCard)this.cards.get(key));
                    }
                    if (key.equals("LONGSTRN")) {
                        longStringsEnabled = true;
                    }
                    ++this.originalCardCount;
                    this.addLine(fcard);
                } while (!cbuf.substring(0, 8).equals("END     "));
            }
            catch (EOFException e3) {
                throw e3;
            }
            catch (Exception e4) {
                if (e4 instanceof EOFException) break block17;
                throw new IOException("Invalid FITS Header:" + e4);
            }
        }
        if (this.fileOffset >= 0L) {
            this.input = dis;
        }
        try {
            dis.skipBytes(FitsUtil.padding(count * 80));
        }
        catch (IOException e5) {
            throw new TruncatedFileException(e5.getMessage());
        }
    }

    private void addDuplicate(HeaderCard dup) {
        if (this.duplicates == null) {
            this.duplicates = new ArrayList<HeaderCard>();
        }
        this.duplicates.add(dup);
    }

    public boolean hadDuplicates() {
        return this.duplicates != null;
    }

    public List<HeaderCard> getDuplicates() {
        return this.duplicates;
    }

    public String findKey(String key) {
        HeaderCard card = this.findCard(key);
        if (card == null) {
            return null;
        }
        return card.toString();
    }

    boolean replaceKey(String oldKey, String newKey) throws HeaderCardException {
        HeaderCard oldCard = this.findCard(oldKey);
        if (oldCard == null) {
            return false;
        }
        if (!this.cards.replaceKey(oldKey, newKey)) {
            throw new HeaderCardException("Duplicate key in replace");
        }
        oldCard.setKey(newKey);
        return true;
    }

    @Override
    public void write(ArrayDataOutput dos) throws FitsException {
        this.fileOffset = FitsUtil.findOffset(dos);
        this.cards.sort(new HeaderOrder());
        this.checkBeginning();
        this.checkEnd();
        if (this.cards.size() <= 0) {
            return;
        }
        HashedList.HashedListIterator iter = this.cards.iterator(0);
        try {
            while (iter.hasNext()) {
                HeaderCard card = (HeaderCard)iter.next();
                byte[] b2 = AsciiFuncs.getBytes(card.toString());
                dos.write(b2);
            }
            FitsUtil.pad(dos, this.getNumberOfCards() * 80, (byte)32);
        }
        catch (IOException e2) {
            throw new FitsException("IO Error writing header: " + e2);
        }
        try {
            dos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void rewrite() throws FitsException, IOException {
        ArrayDataOutput dos = (ArrayDataOutput)((Object)this.input);
        if (!this.rewriteable()) {
            throw new FitsException("Invalid attempt to rewrite Header.");
        }
        FitsUtil.reposition(dos, this.fileOffset);
        this.write(dos);
        dos.flush();
    }

    @Override
    public boolean reset() {
        try {
            FitsUtil.reposition(this.input, this.fileOffset);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    @Override
    public boolean rewriteable() {
        return this.fileOffset >= 0L && this.input instanceof ArrayDataOutput && (this.cards.size() + 35) / 36 == (this.originalCardCount + 35) / 36;
    }

    public void addValue(String key, boolean val, String comment) throws HeaderCardException {
        this.removeCard(key);
        this.iter.add(key, new HeaderCard(key, val, comment));
    }

    public void addValue(String key, double val, String comment) throws HeaderCardException {
        this.removeCard(key);
        this.iter.add(key, new HeaderCard(key, val, comment));
    }

    public void addValue(String key, String val, String comment) throws HeaderCardException {
        this.removeCard(key);
        if (longStringsEnabled && val.replace("'", "''").length() > 68) {
            this.addLongString(key, val, comment);
        } else {
            this.iter.add(key, new HeaderCard(key, val, comment));
        }
    }

    public void addValue(String key, long val, String comment) throws HeaderCardException {
        this.removeCard(key);
        this.iter.add(key, new HeaderCard(key, val, comment));
    }

    private int getAdjustedLength(String in, int max) {
        int size = 0;
        int i = 0;
        while (i < in.length() && size < max) {
            if (in.charAt(i) == '\'') {
                if ((size += 2) > max) {
                    break;
                }
            } else {
                ++size;
            }
            ++i;
        }
        return i;
    }

    protected void addLongString(String key, String val, String comment) throws HeaderCardException {
        int off = this.getAdjustedLength(val, 67);
        String curr = String.valueOf(val.substring(0, off)) + '&';
        this.addValue(key, curr, null);
        val = val.substring(off);
        while (val != null && val.length() > 0) {
            off = this.getAdjustedLength(val, 67);
            if (off < val.length()) {
                curr = "'" + val.substring(0, off).replace("'", "''") + "&'";
                val = val.substring(off);
            } else {
                curr = "'" + val.replace("'", "''") + "' / " + comment;
                val = null;
            }
            this.iter.add(new HeaderCard("CONTINUE", null, curr));
        }
    }

    public void removeCard(String key) throws HeaderCardException {
        if (this.cards.containsKey(key)) {
            this.iter.setKey(key);
            if (this.iter.hasNext()) {
                HeaderCard hc = (HeaderCard)this.iter.next();
                String val = hc.getValue();
                boolean delExtensions = longStringsEnabled && val != null && val.endsWith("&");
                this.iter.remove();
                while (delExtensions) {
                    hc = (HeaderCard)this.iter.next();
                    if (hc == null) {
                        delExtensions = false;
                        continue;
                    }
                    if (hc.getKey().equals("CONTINUE")) {
                        String more = hc.getComment();
                        if ((more = this.continueString(more)) != null) {
                            this.iter.remove();
                            delExtensions = more.endsWith("&'");
                            continue;
                        }
                        delExtensions = false;
                        continue;
                    }
                    delExtensions = false;
                }
            }
        }
    }

    private String continueString(String input) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() < 2 || input.charAt(0) != '\'') {
            return null;
        }
        int i = 1;
        while (i < input.length()) {
            char c2 = input.charAt(i);
            if (c2 == '\'') {
                if (i < input.length() - 1 && input.charAt(i + 1) == c2) {
                    input = String.valueOf(input.substring(0, i)) + input.substring(i + 1);
                } else {
                    return input.substring(0, i + 1);
                }
            }
            ++i;
        }
        return null;
    }

    public void insertCommentStyle(String header, String value) {
        try {
            this.iter.add(new HeaderCard(header, null, value));
        }
        catch (HeaderCardException e2) {
            System.err.println("Impossible Exception for comment style:" + header + ":" + value);
        }
    }

    public void insertComment(String value) throws HeaderCardException {
        this.insertCommentStyle("COMMENT", value);
    }

    public void insertHistory(String value) throws HeaderCardException {
        this.insertCommentStyle("HISTORY", value);
    }

    public void deleteKey(String key) {
        this.iter.setKey(key);
        if (this.iter.hasNext()) {
            this.iter.next();
            this.iter.remove();
        }
    }

    public final boolean containsKey(String key) {
        return this.cards.containsKey(key);
    }

    void nullImage() {
        this.iter = this.iterator();
        try {
            this.addValue("SIMPLE", true, "ntf::header:simple:2");
            this.addValue("BITPIX", 8L, "ntf::header:bitpix:2");
            this.addValue("NAXIS", 0L, "ntf::header:naxis:2");
            this.addValue("EXTEND", true, "ntf::header:extend:2");
        }
        catch (HeaderCardException headerCardException) {
            // empty catch block
        }
    }

    public void setSimple(boolean val) {
        this.deleteKey("SIMPLE");
        this.deleteKey("XTENSION");
        if (this.findCard("NAXIS") != null) {
            int nax = this.getIntValue("NAXIS");
            this.iter = this.iterator();
            if (this.findCard("NAXIS" + nax) != null) {
                HeaderCard hc = (HeaderCard)this.iter.next();
                try {
                    this.removeCard("EXTEND");
                    this.iter.add("EXTEND", new HeaderCard("EXTEND", true, "ntf::header:extend:1"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.iter = this.iterator();
        try {
            this.iter.add("SIMPLE", new HeaderCard("SIMPLE", val, "ntf::header:simple:1"));
        }
        catch (HeaderCardException e2) {
            System.err.println("Impossible exception at setSimple " + e2);
        }
    }

    public void setXtension(String val) {
        this.deleteKey("SIMPLE");
        this.deleteKey("XTENSION");
        this.deleteKey("EXTEND");
        this.iter = this.iterator();
        try {
            this.iter.add("XTENSION", new HeaderCard("XTENSION", val, "ntf::header:xtension:1"));
        }
        catch (HeaderCardException e2) {
            System.err.println("Impossible exception at setXtension " + e2);
        }
    }

    public void setBitpix(int val) {
        this.iter = this.iterator();
        this.iter.next();
        try {
            this.iter.add("BITPIX", new HeaderCard("BITPIX", val, "ntf::header:bitpix:1"));
        }
        catch (HeaderCardException e2) {
            System.err.println("Impossible exception at setBitpix " + e2);
        }
    }

    public void setNaxes(int val) {
        this.iter.setKey("BITPIX");
        if (this.iter.hasNext()) {
            this.iter.next();
        }
        try {
            this.iter.add("NAXIS", new HeaderCard("NAXIS", val, "ntf::header:naxis:1"));
        }
        catch (HeaderCardException e2) {
            System.err.println("Impossible exception at setNaxes " + e2);
        }
    }

    public void setNaxis(int axis, int dim) {
        if (axis <= 0) {
            return;
        }
        if (axis == 1) {
            this.iter.setKey("NAXIS");
        } else if (axis > 1) {
            this.iter.setKey("NAXIS" + (axis - 1));
        }
        if (this.iter.hasNext()) {
            this.iter.next();
        }
        try {
            this.iter.add("NAXIS" + axis, new HeaderCard("NAXIS" + axis, dim, "ntf::header:naxisN:1"));
        }
        catch (HeaderCardException e2) {
            System.err.println("Impossible exception at setNaxis " + e2);
        }
    }

    void checkBeginning() throws FitsException {
        this.iter = this.iterator();
        if (!this.iter.hasNext()) {
            throw new FitsException("Empty Header");
        }
        HeaderCard card = (HeaderCard)this.iter.next();
        String key = card.getKey();
        if (!key.equals("SIMPLE") && !key.equals("XTENSION")) {
            throw new FitsException("No SIMPLE or XTENSION at beginning of Header");
        }
        boolean isTable = false;
        boolean isExtension = false;
        if (key.equals("XTENSION")) {
            String value = card.getValue();
            if (value == null) {
                throw new FitsException("Empty XTENSION keyword");
            }
            isExtension = true;
            if (value.equals("BINTABLE") || value.equals("A3DTABLE") || value.equals("TABLE")) {
                isTable = true;
            }
        }
        this.cardCheck("BITPIX");
        this.cardCheck("NAXIS");
        int nax = this.getIntValue("NAXIS");
        this.iter.next();
        int i = 1;
        while (i <= nax) {
            this.cardCheck("NAXIS" + i);
            ++i;
        }
        if (isExtension) {
            this.cardCheck("PCOUNT");
            this.cardCheck("GCOUNT");
            if (isTable) {
                this.cardCheck("TFIELDS");
            }
        }
    }

    private void cardCheck(String key) throws FitsException {
        if (!this.iter.hasNext()) {
            throw new FitsException("Header terminates before " + key);
        }
        HeaderCard card = (HeaderCard)this.iter.next();
        if (!card.getKey().equals(key)) {
            throw new FitsException("Key " + key + " not found where expected." + "Found " + card.getKey());
        }
    }

    void checkEnd() {
        this.iter = this.iterator();
        while (this.iter.hasNext()) {
            HeaderCard card = (HeaderCard)this.iter.next();
            if (card.isKeyValuePair() || !card.getKey().equals("END")) continue;
            this.iter.remove();
        }
        try {
            this.iter.add(new HeaderCard("END", null, null));
        }
        catch (HeaderCardException headerCardException) {
            // empty catch block
        }
    }

    public void dumpHeader(PrintStream ps) {
        this.iter = this.iterator();
        while (this.iter.hasNext()) {
            ps.println(this.iter.next());
        }
    }

    public int size() {
        return this.cards.size();
    }

    public String getCard(int n) {
        if (n >= 0 && n < this.cards.size()) {
            this.iter = this.cards.iterator(n);
            HeaderCard c2 = (HeaderCard)this.iter.next();
            return c2.toString();
        }
        return null;
    }

    public String getKey(int n) {
        String card = this.getCard(n);
        if (card == null) {
            return null;
        }
        String key = card.substring(0, 8);
        if (key.charAt(0) == ' ') {
            return "";
        }
        if (key.indexOf(32) >= 1) {
            key = key.substring(0, key.indexOf(32));
        }
        return key;
    }

    public void pointToData(Data o) throws FitsException {
        o.fillHeader(this);
    }

    Cursor positionAfterIndex(String prefix, int col) {
        String colnum = "" + col;
        this.iter.setKey(String.valueOf(prefix) + colnum);
        if (this.iter.hasNext()) {
            boolean forward = false;
            while (this.iter.hasNext()) {
                String key = ((HeaderCard)this.iter.next()).getKey().trim();
                if (key != null && key.length() > colnum.length() && key.substring(key.length() - colnum.length()).equals(colnum)) continue;
                forward = true;
                break;
            }
            if (forward) {
                this.iter.prev();
            }
        }
        return this.iter;
    }

    public HeaderCard nextCard() {
        if (this.iter == null) {
            return null;
        }
        if (this.iter.hasNext()) {
            return (HeaderCard)this.iter.next();
        }
        return null;
    }

    void afterExtend() {
        if (this.findCard("EXTEND") != null) {
            this.nextCard();
        }
    }
}

