/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.annotation.Immutable;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.conn.HttpRoutedConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;

@Immutable
public class RequestProxyAuthentication
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        block11: {
            if (request == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            if (request.containsHeader("Proxy-Authorization")) {
                return;
            }
            HttpRoutedConnection conn = (HttpRoutedConnection)context.getAttribute("http.connection");
            if (conn == null) {
                this.log.debug("HTTP connection not set in the context");
                return;
            }
            HttpRoute route = conn.getRoute();
            if (route.isTunnelled()) {
                return;
            }
            AuthState authState = (AuthState)context.getAttribute("http.auth.proxy-scope");
            if (authState == null) {
                this.log.debug("Proxy auth state not set in the context");
                return;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            if (authScheme == null) {
                return;
            }
            Credentials creds = authState.getCredentials();
            if (creds == null) {
                this.log.debug("User credentials not available");
                return;
            }
            if (authState.getAuthScope() != null || !authScheme.isConnectionBased()) {
                try {
                    Header header = authScheme instanceof ContextAwareAuthScheme ? ((ContextAwareAuthScheme)authScheme).authenticate(creds, request, context) : authScheme.authenticate(creds, request);
                    request.addHeader(header);
                }
                catch (AuthenticationException ex) {
                    if (!this.log.isErrorEnabled()) break block11;
                    this.log.error("Proxy authentication error: " + ex.getMessage());
                }
            }
        }
    }
}

