/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eso.dfs.gui.SwingFileChooser;

public class DirectorySelector
extends JPanel {
    private final JFileChooser chooser_;
    private final JTextField dirField_ = new JTextField();
    private Action browseAction_;
    private static File defaultDirectory_;

    public DirectorySelector(String labelText, File initial) {
        this(labelText);
        if (initial == null) {
            return;
        }
        try {
            if (initial.isDirectory()) {
                this.setDirectory(initial);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DirectorySelector(String labelText) {
        String cwd;
        this.setLayout(new BoxLayout(this, 0));
        this.chooser_ = new SwingFileChooser();
        this.chooser_.setFileSelectionMode(1);
        this.browseAction_ = new AbstractAction("Browse"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int result;
                File dir = DirectorySelector.this.getDirectory();
                if (dir != null && dir.exists() && dir.isDirectory()) {
                    DirectorySelector.this.chooser_.setSelectedFile(DirectorySelector.this.getDirectory());
                }
                if ((result = DirectorySelector.this.chooser_.showDialog(DirectorySelector.this, "Select Directory")) == 0) {
                    DirectorySelector.this.setDirectory(DirectorySelector.this.chooser_.getSelectedFile());
                }
            }
        };
        if (defaultDirectory_ == null && (cwd = System.getProperty("user.dir")) != null && cwd.length() > 0) {
            defaultDirectory_ = new File(cwd);
        }
        this.dirField_.setText(defaultDirectory_.getPath());
        this.add(new JLabel(labelText + ":"));
        this.add(Box.createHorizontalStrut(5));
        this.add(this.dirField_);
        this.add(Box.createHorizontalStrut(5));
        this.add(new JButton(this.browseAction_));
        this.dirField_.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.textChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
            }

            void textChanged() {
                defaultDirectory_ = DirectorySelector.this.getDirectory();
            }
        });
    }

    public File getDirectory() {
        String dir = this.dirField_.getText();
        return dir == null || dir.length() == 0 ? null : new File(dir);
    }

    public void setDirectory(File dir) {
        this.dirField_.setText(dir == null ? defaultDirectory_.getPath() : dir.getPath());
        if (dir != null) {
            defaultDirectory_ = dir;
        }
    }

    @Override
    public void setEnabled(boolean b2) {
        super.setEnabled(b2);
        this.dirField_.setEnabled(b2);
        this.browseAction_.setEnabled(b2);
    }

    public JTextField getDirField() {
        return this.dirField_;
    }

    public static File getDefaultDirectory() {
        return defaultDirectory_;
    }

    public static void setDefaultDirectory(File defaultDirectory) {
        defaultDirectory_ = defaultDirectory;
    }
}

