/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.jni;

import java.io.File;
import org.eso.cpl.Recipe;
import org.eso.cpl.RecipeLibrary;
import org.eso.cpl.jni.CPLControl;
import org.eso.cpl.jni.JNIRecipe;
import org.eso.cpl.jni.LTDLException;
import org.eso.cpl.jni.OtherPlugin;

public class PluginLibrary
implements RecipeLibrary {
    private final byte[] nativeState_;
    private final String location_;
    private final String name_;
    private final JNIRecipe[] recipes_;
    private final OtherPlugin[] otherPlugins_;
    private int nReg_ = 0;

    private PluginLibrary(byte[] nativeState, String location, JNIRecipe[] recipes, OtherPlugin[] otherPlugins) {
        this.nativeState_ = nativeState;
        this.location_ = location;
        this.recipes_ = recipes;
        this.otherPlugins_ = otherPlugins;
        this.name_ = new File(location).getName();
    }

    @Override
    public Recipe[] getRecipes() {
        return this.recipes_;
    }

    @Override
    public Object[] getOtherItems() {
        return this.otherPlugins_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getLocation() {
        return this.location_;
    }

    public String toString() {
        return this.name_;
    }

    void register() {
        ++this.nReg_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregister() throws LTDLException {
        --this.nReg_;
        if (this.nReg_ <= 0) {
            Object object = CPLControl.LOCK;
            synchronized (object) {
                this.nativeUnload();
            }
        }
    }

    private native void nativeUnload() throws LTDLException;
}

