/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.test;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eso.cpl.CPLException;
import org.eso.cpl.Recipe;
import org.eso.cpl.jni.JNIRecipe;
import org.eso.cpl.jni.LTDLException;
import org.eso.cpl.jni.LibraryLoader;
import org.eso.cpl.jni.OtherPlugin;
import org.eso.cpl.jni.PluginLibrary;

public class PluginLibraryTest
extends TestCase {
    public static final String DLL_NAME = "libtestplugins.so";
    private PluginLibrary pluglib;
    private Recipe[] recipes;
    private OtherPlugin[] others;

    public PluginLibraryTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws LTDLException, CPLException {
        this.pluglib = PluginLibraryTest.getTestLibrary();
        this.recipes = this.pluglib.getRecipes();
        this.others = (OtherPlugin[])this.pluglib.getOtherItems();
    }

    public static PluginLibrary getTestLibrary() throws LTDLException, CPLException {
        LibraryLoader loader = new LibraryLoader();
        loader.getPath().add(".");
        return loader.getLibrary(DLL_NAME);
    }

    public void testLibrary() {
        PluginLibraryTest.assertEquals(JNIRecipe.class, this.recipes.getClass().getComponentType());
    }

    public void testPlugins() {
        PluginLibraryTest.assertEquals("Fails without a patched cpl_parameterlist.c", 2, this.recipes.length);
        PluginLibraryTest.assertEquals(4, this.others.length);
        PluginLibraryTest.assertTrue(this.others[0].getClass().getName().endsWith("NonRecipePlugin"));
        PluginLibraryTest.assertTrue(this.others[1].getClass().getName().endsWith("NonRecipePlugin"));
        PluginLibraryTest.assertTrue(this.others[2].getClass().getName().endsWith("BadAPIPlugin"));
        PluginLibraryTest.assertTrue(this.others[3].getClass().getName().endsWith("BadAPIPlugin"));
    }

    public static TestSuite suite() {
        return new TestSuite(PluginLibraryTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(PluginLibraryTest.suite());
    }
}

