/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eso.cpl.CPLException;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameList;
import org.eso.cpl.MarkedFrameList;
import org.eso.cpl.NamingScheme;
import org.eso.cpl.Parameter;
import org.eso.cpl.ParameterType;
import org.eso.cpl.ParameterValueException;
import org.eso.cpl.Recipe;
import org.eso.cpl.Request;
import org.eso.cpl.jni.LTDLException;
import org.eso.cpl.jni.LibraryLoader;
import org.eso.cpl.jni.PluginLibrary;
import org.eso.cpl.test.JNICPLTest;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RequestTest
extends TestCase {
    public RequestTest(String name) {
        super(name);
    }

    static Request getRequest() throws LTDLException, CPLException {
        PluginLibrary pluglib = JNICPLTest.getGiraffeLibrary();
        Recipe mbRecipe = pluglib.getRecipes()[0];
        MarkedFrameList inFrames = JNICPLTest.getMasterBiasInputFrames();
        return new Request(mbRecipe, mbRecipe.getDefaultParameters(), inFrames, new File("."), NamingScheme.OVERWRITE);
    }

    public void testXMLSerialization() throws LTDLException, CPLException, ParameterValueException, IOException, SAXException {
        Request req1 = RequestTest.getRequest();
        req1.getRecipe();
        req1.setNamingScheme(NamingScheme.NUMERIC);
        req1.setProductRoot(new File("/some/dir"));
        Parameter par = req1.getParameters()[3];
        RequestTest.assertEquals(ParameterType.INT, par.getType());
        par.setValue(new Integer(9999));
        Request req2 = this.serializeDeserialize(req1);
        this.assertRequestEquals(req1, req2);
        Parameter p2 = req2.getParameters()[1];
        RequestTest.assertEquals(ParameterType.DOUBLE, p2.getType());
        p2.setValue(new Double((Double)p2.getValue() + 1.0));
        this.assertRequestNotEquals(req1, req2);
        p2.setValue(p2.getDefault());
        this.assertRequestEquals(req1, req2);
        MarkedFrameList fl2 = req2.getInputFrames();
        fl2.getFrame(0).setGroup(FrameGroup.PRODUCT);
        this.assertRequestNotEquals(req1, req2);
        fl2.getFrame(0).setGroup(FrameGroup.RAW);
        this.assertRequestEquals(req1, req2);
        Frame frm = (Frame)((FrameList)fl2).remove(fl2.size() - 1);
        this.assertRequestNotEquals(req1, req2);
        fl2.add(frm);
        this.assertRequestEquals(req1, req2);
        req2.setNamingScheme(NamingScheme.OVERWRITE);
        this.assertRequestNotEquals(req1, req2);
        req2.setNamingScheme(req1.getNamingScheme());
        this.assertRequestEquals(req1, req2);
        req2.setProductRoot(new File("/some/where/else"));
        this.assertRequestNotEquals(req1, req2);
        req2.setProductRoot(req1.getProductRoot());
        this.assertRequestEquals(req1, req2);
    }

    private Request serializeDeserialize(Request req) throws LTDLException, CPLException, ParameterValueException, SAXException, IOException {
        try {
            ByteArrayOutputStream ostrm = new ByteArrayOutputStream();
            req.write(ostrm);
            ostrm.close();
            byte[] buffer = ostrm.toByteArray();
            this.validateConfig(new ByteArrayInputStream(buffer));
            ByteArrayInputStream istrm = new ByteArrayInputStream(buffer);
            return new Request(istrm, new LibraryLoader());
        }
        catch (IOException e2) {
            throw new AssertionError();
        }
    }

    private void assertRequestEquals(Request req1, Request req2) throws CPLException {
        Recipe rec1 = req1.getRecipe();
        Recipe rec2 = req2.getRecipe();
        RequestTest.assertTrue(rec1.getName() != null);
        RequestTest.assertEquals(rec1.getName(), rec2.getName());
        RequestTest.assertEquals(rec1.getAuthor(), rec2.getAuthor());
        RequestTest.assertEquals(rec1.getVersion(), rec2.getVersion());
        Parameter[] par1 = req1.getParameters();
        Parameter[] par2 = req2.getParameters();
        int npar = par1.length;
        RequestTest.assertTrue(npar > 0);
        RequestTest.assertEquals(npar, par2.length);
        for (int i = 0; i < npar; ++i) {
            Parameter p1 = par1[i];
            Parameter p2 = par2[i];
            RequestTest.assertEquals(p1.getName(), p2.getName());
            RequestTest.assertEquals(p1.getValue(), p2.getValue());
        }
        MarkedFrameList fl1 = req1.getInputFrames();
        MarkedFrameList fl2 = req2.getInputFrames();
        int nf = fl1.size();
        RequestTest.assertEquals(nf, fl2.size());
        for (int i = 0; i < nf; ++i) {
            RequestTest.assertEquals(fl1.get(i), fl2.get(i));
        }
        File root1 = req1.getProductRoot();
        File root2 = req2.getProductRoot();
        RequestTest.assertEquals(root1 == null ? new File(".") : root1, root2 == null ? new File(".") : root2);
        NamingScheme namer1 = req1.getNamingScheme();
        NamingScheme namer2 = req2.getNamingScheme();
        RequestTest.assertEquals(namer1, namer2);
    }

    private void assertRequestNotEquals(Request req1, Request req2) throws CPLException {
        boolean equal;
        try {
            this.assertRequestEquals(req1, req2);
            equal = true;
        }
        catch (AssertionFailedError e2) {
            equal = false;
        }
        if (equal) {
            RequestTest.fail("Requests shouldn't have been equal, but were");
        }
    }

    private void validateConfig(InputStream strm) throws SAXException, IOException {
        SAXParser parser;
        String decl = new StringBuffer().append("<?xml version='1.0'?>\n").append("<!DOCTYPE request SYSTEM '").append(this.getClass().getResource("/org/eso/cpl/cpl-state.dtd")).append("'>\n").toString();
        SequenceInputStream dstrm = new SequenceInputStream(new ByteArrayInputStream(decl.getBytes()), strm);
        try {
            SAXParserFactory sfact = SAXParserFactory.newInstance();
            sfact.setValidating(true);
            parser = sfact.newSAXParser();
        }
        catch (ParserConfigurationException e2) {
            throw new AssertionFailedError(e2.getMessage());
        }
        RequestTest.assertTrue(parser.isValidating());
        DefaultHandler handler = new DefaultHandler(){

            @Override
            public void warning(SAXParseException e2) {
                Assert.fail(e2.getMessage());
            }

            @Override
            public void error(SAXParseException e2) {
                Assert.fail(e2.getMessage());
            }

            @Override
            public void fatalError(SAXParseException e2) {
                Assert.fail(e2.getMessage());
            }
        };
        parser.parse((InputStream)dstrm, new DefaultHandler(){

            @Override
            public void warning(SAXParseException e2) throws SAXException {
                this.rethrow(e2);
            }

            @Override
            public void error(SAXParseException e2) throws SAXException {
                this.rethrow(e2);
            }

            @Override
            public void fatalError(SAXParseException e2) throws SAXException {
                this.rethrow(e2);
            }

            private void rethrow(SAXParseException e2) throws SAXException {
                throw new SAXException("Parse error in " + e2.getSystemId() + " at line " + e2.getLineNumber() + " column " + e2.getColumnNumber(), e2);
            }
        });
    }

    public static TestSuite suite() {
        return new TestSuite(RequestTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(RequestTest.suite());
    }

    class TeeInputStream
    extends FilterInputStream {
        public TeeInputStream(InputStream strm) {
            super(strm);
        }

        @Override
        public int read() throws IOException {
            int i = super.read();
            System.out.print((char)i);
            return i;
        }

        @Override
        public int read(byte[] b2) throws IOException {
            int i = super.read(b2);
            System.out.print(new String(b2));
            return i;
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            int i = super.read(b2, off, len);
            System.out.print(new String(b2, off, len));
            return i;
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

