/*
 * Decompiled with CFR 0.152.
 */
package org.eso.dfs.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MemMappedFileReader
extends Reader {
    private static final int MAPPING_SIZE = Integer.MAX_VALUE;
    private ByteBuffer buffer;
    private FileChannel fc;
    private long size;
    private long offset;

    public MemMappedFileReader(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        this.fc = fis.getChannel();
        this.size = this.fc.size();
        this.offset = 0L;
        try {
            long size2 = Math.min(this.size, Integer.MAX_VALUE);
            this.buffer = this.fc.map(FileChannel.MapMode.READ_ONLY, this.offset, size2);
        }
        catch (IOException e2) {
            this.fc.close();
            throw e2;
        }
    }

    @Override
    public int read(char[] arg0, int arg1, int arg2) throws IOException {
        int i;
        if (!this.buffer.hasRemaining() && !this.getNextBuffer()) {
            return -1;
        }
        if (this.buffer.hasRemaining()) {
            for (i = 0; i != arg2; ++i) {
                if (!this.buffer.hasRemaining() && !this.getNextBuffer()) {
                    return -1;
                }
                arg0[i + arg1] = (char)this.buffer.get();
                if (this.buffer.hasRemaining()) continue;
                break;
            }
        } else {
            i = -1;
        }
        return i;
    }

    private boolean getNextBuffer() {
        try {
            this.offset += Integer.MAX_VALUE;
            if (this.offset <= this.size) {
                long size2 = Math.min(this.size - this.offset, Integer.MAX_VALUE);
                this.closeDirectBuffer(this.buffer);
                this.buffer = this.fc.map(FileChannel.MapMode.READ_ONLY, this.offset, size2);
                return true;
            }
            return false;
        }
        catch (IOException e2) {
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        this.fc.close();
        this.closeDirectBuffer(this.buffer);
    }

    @Override
    public void mark(int arg0) throws IOException {
        throw new IOException("MemMappedFileRead does not support marking.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get();
        }
        if (this.getNextBuffer()) {
            if (this.buffer.hasRemaining()) {
                return this.buffer.get();
            }
            return -1;
        }
        return -1;
    }

    @Override
    public int read(char[] arg0) throws IOException {
        return this.read(arg0, 0, arg0.length);
    }

    @Override
    public boolean ready() throws IOException {
        return true;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset TBI");
    }

    @Override
    public long skip(long arg0) throws IOException {
        int remainingBytes = this.buffer.capacity() - this.buffer.position();
        if (arg0 > (long)remainingBytes) {
            long skipped = -2147483647L;
            int i = -1;
            while ((long)i < (arg0 - (long)remainingBytes) / Integer.MAX_VALUE) {
                skipped += Integer.MAX_VALUE;
                if (!this.getNextBuffer()) {
                    this.buffer.position(this.buffer.capacity());
                    return remainingBytes;
                }
                ++i;
            }
            this.buffer.position((int)(arg0 - skipped - (long)remainingBytes));
            return arg0;
        }
        this.buffer.position(this.buffer.position() + (int)arg0);
        return arg0;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Please list files on command line.");
        } else {
            for (int i = 0; i < args.length; ++i) {
                File f = new File(args[i]);
                try {
                    int c2;
                    MemMappedFileReader r = new MemMappedFileReader(f);
                    while ((c2 = ((Reader)r).read()) != -1) {
                        System.out.print((char)c2);
                    }
                    continue;
                }
                catch (IOException e2) {
                    System.out.println("Error reading file: " + e2.toString());
                }
            }
        }
    }

    private void closeDirectBuffer(ByteBuffer cb) {
        if (!cb.isDirect()) {
            return;
        }
        try {
            Method cleaner = cb.getClass().getMethod("cleaner", new Class[0]);
            cleaner.setAccessible(true);
            Method clean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
            clean.setAccessible(true);
            clean.invoke(cleaner.invoke((Object)cb, new Object[0]), new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cb = null;
    }
}

