/*
 * Decompiled with CFR 0.152.
 */
package org.eso.dfs.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;

public class ZCatReader
extends BufferedReader {
    private static String zcatCommand = "zcat";
    private Process proc;

    public static ZCatReader createZCatReader(String dataAddress) throws IOException {
        String command = new String(zcatCommand + " " + dataAddress);
        Runtime r = Runtime.getRuntime();
        Process p = r.exec(command);
        return new ZCatReader((Reader)new InputStreamReader(p.getInputStream()), p);
    }

    private ZCatReader(Reader in, Process p) {
        super(in);
        this.proc = p;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.proc.destroy();
    }

    public static String getZcatCommand() {
        return zcatCommand;
    }

    public static void setZcatCommand(String zcatCommand) {
        ZCatReader.zcatCommand = zcatCommand;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Please include .Z files to cat");
        } else {
            for (int i = 0; i < args.length; ++i) {
                try {
                    Date start = new Date();
                    ZCatReader r = ZCatReader.createZCatReader(args[i]);
                    BufferedReader rdr = new BufferedReader(r);
                    char[] rec = new char[80];
                    while (rdr.read(rec) >= 0) {
                    }
                    System.out.println("Read " + args[i] + " in: " + (new Date().getTime() - start.getTime()) + "ms.");
                    rdr.close();
                    continue;
                }
                catch (IOException e2) {
                    System.out.println("Error catting file: " + args[i] + ": " + e2.toString());
                }
            }
        }
    }
}

