/*
 * Decompiled with CFR 0.152.
 */
package org.eso.dfs.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.eso.dfs.io.MemMappedFileInputStream;
import org.eso.dfs.io.MemMappedFileReader;
import org.eso.dfs.io.ZCatReader;
import org.eso.dfs.util.KeywordListener;
import org.eso.dfs.util.KeywordToken;

public class FitsTokenizer {
    private static boolean memoryMappingEnabled = true;
    public static String COMMENT_TOKEN = " / ";
    public static final String EXTENDSTART = "XTENSION";
    public static final String SIMPLESTART = "SIMPLE";
    public static final String NAXIS = "NAXIS";
    public static final String AXIS = "NAXIS";
    public static final String BITPIX = "BITPIX";
    private static boolean useMemoryMapping = true;
    public static final int FITS_REC_LENGTH = 80;
    public static final int BOUNDARY = 2880;
    public static final String endToken = "END";
    private List keywordListeners = new Vector();
    private boolean readExtensions = true;
    private Reader otherReader;
    private String fileAddress;

    public FitsTokenizer(String fileAddr, boolean readExt) {
        this.readExtensions = readExt;
        this.fileAddress = fileAddr;
    }

    public FitsTokenizer(Reader rdr, boolean readExt) {
        this.readExtensions = readExt;
        this.otherReader = rdr;
    }

    public void addKeywordListener(KeywordListener kwl) {
        if (!this.keywordListeners.contains(kwl)) {
            this.keywordListeners.add(kwl);
        }
    }

    public boolean removeKeywordListener(KeywordListener kwl) {
        return this.keywordListeners.remove(kwl);
    }

    public static void setMemoryMappingEnabled(boolean b2) {
        memoryMappingEnabled = b2;
    }

    public boolean isReadExtensions() {
        return this.readExtensions;
    }

    public void read() throws IOException, FileNotFoundException {
        int bRead;
        boolean endParsed = false;
        File fitsFile = new File(this.fileAddress);
        boolean isCompressed = false;
        FileReader dataSource = null;
        Reader input = null;
        if (this.otherReader != null) {
            input = this.otherReader;
        } else {
            dataSource = new FileReader(this.fileAddress);
            if (dataSource == null) {
                throw new IOException("Failed to create reader on " + this.fileAddress);
            }
            if (this.fileAddress.endsWith(".fits.Z")) {
                input = this.zcatFile(this.fileAddress);
                isCompressed = true;
                this.readExtensions = false;
            } else if (this.fileAddress.endsWith(".fits.gz")) {
                input = this.gzipFile(this.fileAddress);
                isCompressed = true;
                this.readExtensions = false;
            } else {
                if (memoryMappingEnabled && useMemoryMapping) {
                    input = this.memMapFile(this.fileAddress);
                }
                if (input == null) {
                    input = new BufferedReader(dataSource);
                }
            }
        }
        char[] cbuf = new char[80];
        int bBuffered = 0;
        int totalRead = 0;
        int currentExtension = 0;
        int currentKeywordIndex = 0;
        boolean hasExtensions = false;
        long requiredToSkip = 0L;
        int requiredToRead = 80;
        Hashtable<String, KeywordToken> naxisKeys = new Hashtable<String, KeywordToken>();
        while ((bRead = input.read(cbuf, bBuffered, requiredToRead - bBuffered)) >= 0) {
            totalRead += bRead;
            if ((bBuffered += bRead) != requiredToRead) continue;
            String rec = new String(cbuf);
            if (endParsed && (rec.startsWith(EXTENDSTART) || rec.startsWith(SIMPLESTART))) {
                endParsed = false;
                ++currentExtension;
                currentKeywordIndex = 0;
            } else if (rec.startsWith(endToken)) {
                endParsed = true;
                if (!this.readExtensions) break;
                if (!hasExtensions) {
                    hasExtensions = true;
                }
                long bytesToNextHeader = FitsTokenizer.calculateByteOffsetToNextHeader(naxisKeys);
                naxisKeys = new Hashtable();
                if (!hasExtensions || bytesToNextHeader < 0L) break;
                long bytesToEndOfBlock = totalRead % 2880;
                bytesToEndOfBlock = bytesToEndOfBlock > 0L ? 2880L - bytesToEndOfBlock : 0L;
                FitsTokenizer.seek(input, bytesToNextHeader += bytesToEndOfBlock);
                totalRead = (int)((long)totalRead + bytesToNextHeader);
            }
            KeywordToken k = this.parseKeyword(rec, currentExtension, currentKeywordIndex);
            if (k != null) {
                if (k.getName().equalsIgnoreCase(BITPIX) || k.getName().startsWith("NAXIS")) {
                    ((Dictionary)naxisKeys).put(k.getName(), k);
                }
                Iterator i = this.keywordListeners.iterator();
                boolean stopReading = false;
                while (i.hasNext()) {
                    stopReading = stopReading || ((KeywordListener)i.next()).tokenRead(k);
                }
                if (stopReading) break;
                ++currentKeywordIndex;
            }
            bBuffered = 0;
        }
        if (this.otherReader == null) {
            input.close();
        }
        dataSource.close();
    }

    private Reader gzipFile(String dataAddress) throws IOException, FileNotFoundException {
        BufferedReader buffRed = null;
        File f = new File(dataAddress);
        InputStream is = null;
        try {
            is = new MemMappedFileInputStream(f);
        }
        catch (IOException e2) {
            System.out.println("Error memory mapping file: " + e2.getMessage());
        }
        if (is == null) {
            is = new FileInputStream(f);
        }
        buffRed = new BufferedReader(new InputStreamReader(new GZIPInputStream(is)));
        return buffRed;
    }

    private Reader zcatFile(String dataAddress) throws IOException {
        return new BufferedReader(ZCatReader.createZCatReader(dataAddress));
    }

    private Reader memMapFile(String dataAddress) {
        MemMappedFileReader rc = null;
        try {
            File f = new File(dataAddress);
            rc = new MemMappedFileReader(f);
        }
        catch (IOException e2) {
            System.out.println("Error memory mapping file: " + e2.getMessage());
        }
        return rc;
    }

    public static boolean isUseMemoryMapping() {
        return useMemoryMapping;
    }

    public static void setUseMemoryMapping(boolean useMemoryMapping) {
        FitsTokenizer.useMemoryMapping = useMemoryMapping;
    }

    private KeywordToken parseKeyword(String s, int currentExtension, int currentIndex) {
        String name = null;
        String value = null;
        KeywordToken rc = null;
        int eqPos = s.indexOf(61);
        if (eqPos <= 0) {
            return rc;
        }
        try {
            name = s.substring(0, eqPos);
            name = name.trim();
        }
        catch (StringIndexOutOfBoundsException e2) {
            return rc;
        }
        int commPos = s.indexOf(COMMENT_TOKEN, eqPos);
        if (commPos < 0) {
            commPos = s.length();
        }
        try {
            value = s.substring(eqPos + 1, commPos);
            value = value.trim();
        }
        catch (StringIndexOutOfBoundsException e3) {
            return rc;
        }
        rc = new KeywordToken(name, value, currentExtension, currentIndex);
        return rc;
    }

    protected static void seek(Reader rdr, long skip) throws IOException {
        long skipped = 0L;
        try {
            while (skip > 0L) {
                skipped = rdr.skip(skip);
                if (skipped <= 0L) {
                    System.out.println("Skipped <= 0: exit");
                    break;
                }
                skip -= skipped;
            }
        }
        catch (IllegalArgumentException e2) {
            throw new IOException(e2.getMessage());
        }
    }

    public static long calculateByteOffsetToNextHeader(Dictionary naxisKeys) {
        int naxis;
        long pixelSize = 0L;
        long[] axis = null;
        KeywordToken k = (KeywordToken)naxisKeys.get(BITPIX);
        if (k != null) {
            pixelSize = FitsTokenizer.stringToLong(k.getValue(), 0L);
        }
        if ((k = (KeywordToken)naxisKeys.get("NAXIS")) != null && (long)(naxis = (int)FitsTokenizer.stringToLong(k.getValue(), -1L)) > 0L) {
            axis = new long[naxis];
        }
        if (axis != null) {
            for (int i = 0; i < axis.length; ++i) {
                long axisVal = -1L;
                k = (KeywordToken)naxisKeys.get("NAXIS" + (i + 1));
                if (k != null) {
                    axisVal = FitsTokenizer.stringToLong(k.getValue(), -1L);
                }
                if (axisVal < 0L) {
                    pixelSize = 0L;
                    break;
                }
                axis[i] = axisVal;
            }
        }
        long rc = -1L;
        if (axis != null || pixelSize != 0L) {
            pixelSize = Math.abs(pixelSize);
            long imageSize = 0L;
            for (int i = 0; axis != null && i < axis.length; ++i) {
                if (imageSize == 0L) {
                    imageSize = 1L;
                }
                imageSize *= axis[i];
            }
            if (imageSize >= 0L) {
                long byteUsedInLastBlock = (imageSize = pixelSize / 8L * imageSize) % 2880L;
                long unusedBytesInBlock = byteUsedInLastBlock > 0L ? 2880L - byteUsedInLastBlock : 0L;
                rc = imageSize + unusedBytesInBlock;
            }
        }
        return rc;
    }

    private static long stringToLong(String in, long errorValue) {
        long rc;
        try {
            rc = Long.parseLong(in);
        }
        catch (NumberFormatException e2) {
            rc = errorValue;
        }
        return rc;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: <file path to fits file> [all]");
            return;
        }
        boolean doAll = false;
        String filePath = args[0];
        if (args.length >= 2 && args[1].equalsIgnoreCase("all")) {
            doAll = true;
        }
        try {
            FitsTokenizer ft = new FitsTokenizer(filePath, doAll);
            ft.addKeywordListener(new KeywordListener(){

                @Override
                public boolean tokenRead(KeywordToken kwt) {
                    System.out.println("Ext: " + kwt.getExtension() + "\tidx:" + kwt.getIndexInExtension() + "\t" + kwt.getName() + "\t" + kwt.getValue());
                    return false;
                }
            });
            ft.read();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

