/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano;

import jal.String.Sorting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.eso.gasgano.GasganoDisplay;
import org.eso.gasgano.gui.DFSFileTreeTable;

public class ScriptDirBoard
extends JFrame
implements ActionListener,
TreeSelectionListener,
ComponentListener {
    private boolean isBeingShown = false;
    private JFileChooser fc = null;
    private ScriptBoardModel scriptTableModel = null;
    private JTable scriptTable = null;
    private JPanel scriptPanel = null;
    private JPanel buttonPanel = null;
    private JPanel radioPanel = null;
    private JButton dismissButton = null;
    private JButton overrideButton = null;
    private JRadioButton confirmButton = null;
    private JRadioButton classificationSupplyButton = null;
    private JRadioButton backGroundButton = null;
    private boolean confirmExec = true;
    private boolean classificationSupply = false;
    private boolean backGround = false;
    private JScrollPane scrollPane = null;
    private String[] fileList = null;
    private String selectedDir = null;
    private String baseDir = null;
    private String instrumentName = null;
    private File scriptDir = null;
    private Dimension recordedBounds = null;
    private GasganoDisplay gasganoDisplay = null;
    private DFSFileTreeTable fsTree = null;
    private boolean showingDefault = false;

    public ScriptDirBoard(String baseDir, GasganoDisplay gasganoDisplay, DFSFileTreeTable fsTree) {
        super("Gasgano Script Directory Board");
        this.baseDir = baseDir;
        this.gasganoDisplay = gasganoDisplay;
        this.fsTree = fsTree;
        this.selectedDir = baseDir;
        if (this.selectedDir == null) {
            System.out.println("User selected null file?");
            return;
        }
        this.scriptDir = new File(this.selectedDir);
        this.instrumentName = "";
        this.fileList = this.scriptDir.list(new NoDirsFilter());
        this.scriptTableModel = new ScriptBoardModel(this.fileList);
        this.scriptTable = new JTable(this.scriptTableModel);
        this.scriptTable.setCellSelectionEnabled(true);
        this.scriptTable.setSelectionMode(1);
        this.scriptTable.setAutoResizeMode(4);
        this.scriptTable.setPreferredScrollableViewportSize(new Dimension(240, 100));
        this.scriptTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    Point pt = evt.getPoint();
                    int rowIndex = ScriptDirBoard.this.scriptTable.rowAtPoint(pt);
                    int columnIndex = ScriptDirBoard.this.scriptTable.columnAtPoint(pt);
                    if (rowIndex == -1 || columnIndex == -1) {
                        System.out.println("Clicked outside table");
                    } else {
                        String commandString = new String(ScriptDirBoard.this.selectedDir + File.separator + (String)ScriptDirBoard.this.scriptTable.getModel().getValueAt(rowIndex, columnIndex));
                        String completeCommandPath = new File(commandString).getAbsolutePath();
                        ScriptDirBoard.this.gasganoDisplay.selectedFilesToCommand(completeCommandPath, ScriptDirBoard.this.confirmExec, ScriptDirBoard.this.classificationSupply, ScriptDirBoard.this.backGround);
                    }
                }
            }
        });
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.setSize(this.dismissButton.getMinimumSize());
        this.dismissButton.addActionListener(this);
        this.overrideButton = new JButton("use default scripts");
        this.overrideButton.setSize(this.overrideButton.getMinimumSize());
        this.overrideButton.addActionListener(this);
        this.confirmButton = new JRadioButton("confirm");
        this.confirmButton.setSelected(this.confirmExec);
        this.confirmButton.addActionListener(this);
        this.classificationSupplyButton = new JRadioButton("Supply classification");
        this.classificationSupplyButton.addActionListener(this);
        this.classificationSupplyButton.setSelected(this.classificationSupply);
        this.backGroundButton = new JRadioButton("Run in background");
        this.backGroundButton.addActionListener(this);
        this.backGroundButton.setEnabled(false);
        this.backGroundButton.setSelected(this.backGround);
        this.scriptPanel = new JPanel(new BorderLayout());
        this.buttonPanel = new JPanel(new BorderLayout());
        this.radioPanel = new JPanel(new GridBagLayout());
        this.scrollPane = new JScrollPane(this.scriptTable);
        this.scriptPanel.add((Component)this.scrollPane, "Center");
        this.scriptPanel.setBorder(new TitledBorder(new EtchedBorder(), "Double-click to execute"));
        this.radioPanel.add(this.confirmButton);
        this.radioPanel.add(this.classificationSupplyButton);
        this.radioPanel.add(this.backGroundButton);
        this.radioPanel.setBorder(new EmptyBorder(2, 5, 2, 5));
        this.buttonPanel.add((Component)this.dismissButton, "East");
        this.buttonPanel.add((Component)this.overrideButton, "West");
        this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.scriptPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "North");
        this.getContentPane().add((Component)this.radioPanel, "South");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ScriptDirBoard.this.setVisible(false);
            }
        });
        this.pack();
        this.addComponentListener(this);
        this.displayScripts();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.overrideButton) {
            this.showingDefault = !this.showingDefault;
            this.displayScripts();
        }
        if (ae.getSource() == this.dismissButton) {
            this.setVisible(false);
        }
        if (ae.getSource() == this.confirmButton) {
            this.confirmExec = this.confirmButton.isSelected();
        }
        if (ae.getSource() == this.classificationSupplyButton) {
            this.classificationSupply = this.classificationSupplyButton.isSelected();
        }
        if (ae.getSource() == this.backGroundButton) {
            this.backGround = this.backGroundButton.isSelected();
        }
    }

    private void configureScriptButton() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScriptDirBoard.this.overrideButton.setEnabled(ScriptDirBoard.this.instrumentName != null);
                String name = "";
                if (ScriptDirBoard.this.instrumentName != null) {
                    name = ScriptDirBoard.this.showingDefault ? "Show " + ScriptDirBoard.this.instrumentName + " Scripts" : "Show Default Scripts";
                }
                ScriptDirBoard.this.overrideButton.setText(name);
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent e2) {
        if (this.fsTree.getSelectedOBComponents().size() == 0) {
            return;
        }
        this.displayScripts();
    }

    public void displayScripts() {
        this.instrumentName = this.fsTree.getSelectedInstrument();
        if (!this.canDisplayInstrumentScripts()) {
            this.instrumentName = null;
        }
        if (this.showingDefault || this.instrumentName == null) {
            this.displayDefaultScripts();
        } else {
            this.displayInstrumentScripts();
        }
        this.configureScriptButton();
    }

    private boolean canDisplayInstrumentScripts() {
        if (this.instrumentName == null) {
            return false;
        }
        String dir = this.baseDir + File.separator + this.instrumentName;
        File scrDir = new File(dir);
        return scrDir.exists() && scrDir.isDirectory();
    }

    private void displayInstrumentScripts() {
        this.selectedDir = this.baseDir + File.separator + this.instrumentName;
        this.scriptDir = new File(this.selectedDir);
        this.scriptPanel.setBorder(new TitledBorder(new EtchedBorder(), "Double-click to execute (" + this.instrumentName + ")"));
        if (this.isVisible()) {
            this.showBoard();
            this.scriptTableModel.fireTableStructureChanged();
            this.scriptTable.sizeColumnsToFit(-1);
        }
        this.showingDefault = false;
    }

    private void displayDefaultScripts() {
        this.selectedDir = this.baseDir;
        this.scriptDir = new File(this.selectedDir);
        this.scriptPanel.setBorder(new TitledBorder(new EtchedBorder(), "Double-click to execute "));
        if (this.isVisible()) {
            this.showBoard();
            this.scriptTableModel.fireTableStructureChanged();
            this.scriptTable.sizeColumnsToFit(-1);
        }
        this.showingDefault = true;
    }

    public void showBoard() {
        this.setVisible(true);
        this.scriptTableModel.loadFiles(this.scriptDir.list(new NoDirsFilter()));
        if (this.recordedBounds != null) {
            this.setSize(this.recordedBounds);
        }
    }

    public void hideBoard() {
        this.setVisible(false);
    }

    @Override
    public void componentResized(ComponentEvent e2) {
        this.recordedBounds = this.getSize();
    }

    @Override
    public void componentMoved(ComponentEvent e2) {
    }

    @Override
    public void componentShown(ComponentEvent e2) {
    }

    @Override
    public void componentHidden(ComponentEvent e2) {
    }

    private static class ScriptBoardModel
    extends AbstractTableModel {
        private final int maxOneCol = 10;
        private int columns = 0;
        private int rows = 0;
        private int old_columns;
        private int old_rows = 0;
        private Vector fileListLabel = new Vector();

        public ScriptBoardModel(String[] fileList) {
            this.loadFiles(fileList);
        }

        @Override
        public int getColumnCount() {
            return this.columns;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.fileListLabel.elementAt(row * this.columns + col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            return new String("");
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }

        public void removeRow(int rowNum) {
        }

        public void insertRow(int rowNum) {
        }

        public void loadFiles(String[] fileList) {
            int i;
            Sorting.sort(fileList, 0, fileList.length);
            if (fileList.length < 10) {
                this.columns = 1;
                this.rows = fileList.length;
            } else {
                this.columns = Math.min((int)Math.sqrt(fileList.length), 6);
                this.rows = fileList.length / this.columns;
                if (this.rows * this.columns < fileList.length) {
                    ++this.rows;
                }
            }
            this.fileListLabel.removeAllElements();
            this.fileListLabel.setSize(this.rows * this.columns);
            for (i = 0; i < fileList.length; ++i) {
                this.fileListLabel.setElementAt(fileList[i], i);
            }
            for (i = fileList.length; i < this.rows * this.columns; ++i) {
                this.fileListLabel.setElementAt("", i);
            }
            this.fireTableDataChanged();
            if (this.old_columns != this.columns || this.old_rows != this.rows) {
                this.fireTableStructureChanged();
            }
            this.old_columns = this.columns;
            this.old_rows = this.rows;
        }
    }

    private static class NoDirsFilter
    implements FilenameFilter {
        private NoDirsFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.startsWith(".")) {
                return false;
            }
            return !new File(dir.toString() + File.separator + name).isDirectory();
        }
    }
}

