/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.eso.gasgano.datamodel.filesystem.DFSTextFile;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.BaseName;

public class ReductionBlock
extends DFSTextFile {
    private Vector inputFiles;
    private Vector masterCalibFiles;
    private String productBaseName;
    private String productDirectory;
    public static final int PRODUCT_LINE_NUMBER = 5;
    public static final int NUM_LEFT_BRACES_BEFORE_CAL_FILES = 2;
    public static final String RB_EXEC_ERR_1 = ".rZ";
    public static final String RB_EXEC_ERR_2 = ".rY";
    public static final String RB_EXEC_OK = ".rX";
    public static final String RB_NOT_EXEC = ".rb";

    public ReductionBlock(String a2) {
        super(a2);
    }

    public Vector getInputFileNames() {
        return this.inputFiles;
    }

    public Vector getMasterCalibFileNames() {
        return this.masterCalibFiles;
    }

    public String getProductBaseName() {
        return this.productBaseName;
    }

    public String getProductDirectory() {
        return this.productDirectory;
    }

    @Override
    public int readFile() {
        int lineNo = 0;
        int braceCount = 0;
        boolean readingCalibFiles = false;
        boolean readProductFile = false;
        this.setStatus(3);
        this.inputFiles = new Vector();
        this.masterCalibFiles = new Vector();
        this.productBaseName = new String("");
        this.productDirectory = new String("");
        File theFile = new File(this.getAddress());
        FileReader dataSource = null;
        try {
            dataSource = new FileReader(this.getAddress());
        }
        catch (FileNotFoundException ex) {
            System.out.println("File not found: " + this.getAddress());
            this.setStatus(1);
            return this.getStatus();
        }
        if (dataSource == null) {
            this.setStatus(2);
            return this.getStatus();
        }
        StringBuffer buff = new StringBuffer();
        BufferedReader br = new BufferedReader(dataSource);
        try {
            while (true) {
                String s = br.readLine();
                ++lineNo;
                if (s != null) {
                    if (s.startsWith("/") && readProductFile) {
                        int spacePlace = s.indexOf(" ");
                        String fileName = null;
                        fileName = spacePlace != -1 ? s.substring(0, spacePlace) : s;
                        File file = new File(fileName);
                        fileName = file.getCanonicalPath();
                        if (readingCalibFiles) {
                            this.masterCalibFiles.addElement(fileName);
                        } else {
                            this.inputFiles.addElement(fileName);
                        }
                    } else if (s.startsWith("{")) {
                        if (++braceCount == 2) {
                            readingCalibFiles = true;
                        }
                    } else if (lineNo == 5) {
                        if (s.startsWith("priority")) {
                            buff.append(s + "\n");
                            s = br.readLine();
                            ++lineNo;
                            buff.append(s + "\n");
                            s = br.readLine();
                            ++lineNo;
                        }
                        File product = new File(s);
                        this.productBaseName = BaseName.extractProductBaseName(s, '/');
                        this.productDirectory = product.getParent();
                        if (this.productDirectory == null || this.productDirectory.equals("")) {
                            if (PropertyDB.getInstance().isDebug(1)) {
                                System.err.println("Reduction Block " + this.getAddress() + " is invalid, no path in product specification");
                            }
                            this.setStatus(2);
                        }
                        readProductFile = true;
                    }
                    buff.append(s + "\n");
                    continue;
                }
                break;
            }
        }
        catch (IOException e2) {
            this.setStatus(2);
        }
        try {
            dataSource.close();
        }
        catch (IOException e3) {
            // empty catch block
        }
        this.setData(buff.toString());
        return this.getStatus();
    }
}

