/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.database;

import org.eso.gasgano.tools.SortedHashtable;

public class DBContainer
extends SortedHashtable {
    private DBContainer father = null;
    private int filesCount = 0;
    private String desc = null;
    private char containerType = (char)97;

    public DBContainer() {
    }

    public DBContainer(char type, String label) {
        super(label);
        this.setDescription(label);
        this.containerType = type;
    }

    public void setFather(DBContainer f) {
        this.father = f;
    }

    public DBContainer getFather() {
        return this.father;
    }

    public boolean isProgram() {
        return this.containerType == 'p';
    }

    public boolean isTelescope() {
        return this.containerType == 't';
    }

    public boolean isObservation() {
        return this.containerType == 'o';
    }

    public void setDescription(String s) {
        this.desc = s;
    }

    @Override
    public String toString() {
        return this.desc;
    }

    public String getId() {
        return super.toString();
    }

    public void setVirtualSize(int size) {
        this.filesCount = size;
    }

    public int virtualSize() {
        if (this.filesCount < super.size()) {
            return super.size();
        }
        return this.filesCount;
    }
}

