/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.filesystem;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eso.dfs.services.ServiceException;
import org.eso.dfs.services.data.AssociationHandler;
import org.eso.dfs.services.data.AssociationNode;
import org.eso.dfs.services.data.FileAssociationNode;
import org.eso.gasgano.datamodel.DataModelChangeNotifier;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.datamodel.FileDescription;
import org.eso.gasgano.datamodel.FrameInfo;
import org.eso.gasgano.datamodel.InterContainer;
import org.eso.gasgano.datamodel.OBComponentFilter;
import org.eso.gasgano.datamodel.Observation;
import org.eso.gasgano.datamodel.ObservationDescription;
import org.eso.gasgano.datamodel.Program;
import org.eso.gasgano.datamodel.ProgramDescription;
import org.eso.gasgano.datamodel.ReductionBlockCommon;
import org.eso.gasgano.datamodel.filesystem.DFSFile;
import org.eso.gasgano.datamodel.filesystem.FileSelectionModel;
import org.eso.gasgano.datamodel.filesystem.ServiceFileSet;
import org.eso.gasgano.datamodel.gui.DFSTextFileOBComponent;
import org.eso.gasgano.datamodel.gui.FitsFileOBComponent;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.datamodel.gui.ReductionBlockOBComponent;
import org.eso.gasgano.datamodel.gui.TFitsFileOBComponent;
import org.eso.gasgano.datamodel.gui.VirtualReductionBlockOBComponent;
import org.eso.gasgano.properties.GasProp;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.SortedHashtable;
import org.eso.oca.parser.ASTStart;
import org.eso.oca.parser.OcaParser;
import org.eso.oca.parser.ParseException;

public class DFSDataModel
extends DataModelChangeNotifier
implements AssociationHandler {
    private Vector fileSelectionModels = new Vector();
    private ServiceFileSet serviceFileModel = new ServiceFileSet();
    private OBComponentFilter fileFilter;
    private static final boolean useArcNameIndex = true;
    private SortedHashtable programs;
    private SortedHashtable directories;
    private SortedHashtable telescopes;
    private ProgramDescription progDescFactory;
    public static final String UNKNOWN_PROGRAM_ID = "Unknown Program";
    public static final String UNKNOWN_OBSERVATION_ID = "Unknown Observation";
    public static final String UNKNOWN_TELESCOPE_ID = "Unknown Telescope";
    private int totalFilesInSet = 0;
    private int numberOfFilesUpdated = 0;
    private Hashtable[] indexes;
    private static final int NUMBER_OF_INDEXES = 6;
    private static final int NAME_INDEX = 0;
    private static final int BASE_NAME_INDEX = 1;
    private static final int ARC_NAME_INDEX = 2;
    private static final int FS_BASE_NAME_INDEX = 3;
    private static final int MD5_INDEX = 4;
    private static final int VRB_INDEX = 5;
    private ASTStart classifier;
    private static DFSDataModel theDataModel;
    private final int eventTolerance = 30;
    private boolean dataModelUpdating = false;

    private DFSDataModel() {
        this.fileSelectionModels.add(this.serviceFileModel);
        this.programs = new SortedHashtable();
        this.directories = new SortedHashtable();
        this.telescopes = new SortedHashtable();
        this.indexes = new Hashtable[6];
        for (int i = 0; i < 6; ++i) {
            this.indexes[i] = new Hashtable();
        }
    }

    public void displayHashtableSizes() {
        System.out.println("");
        System.out.println(" Hashtables for names : " + this.indexes[0].size() + " " + this.indexes[1].size() + " " + this.indexes[2].size() + " " + this.indexes[3].size());
        System.out.println(" Telescopes: " + this.telescopes.size() + " Directories " + this.directories.size() + " programs " + this.programs.size());
        System.out.println("");
    }

    public void setDefaultProgramDescription(ProgramDescription p) {
        this.progDescFactory = p;
    }

    public ProgramDescription getDefaultProgramDescription() {
        return this.progDescFactory;
    }

    public void setDefaultObservationDescription(ObservationDescription p) {
        Program.setDefaultObservationDescription(p);
    }

    public ObservationDescription getDefaultObservationDescription() {
        return Program.getDefaultObservationDescription();
    }

    public void setDefaultFileDescription(FileDescription fd) {
        OBComponent.setDefaultFileDescription(fd);
    }

    public FileDescription getDefaultFileDescription() {
        return OBComponent.getDefaultFileDescription();
    }

    public static synchronized DFSDataModel getDataModel() {
        if (theDataModel == null) {
            theDataModel = new DFSDataModel();
        }
        return theDataModel;
    }

    public void addFileSelectionModel(FileSelectionModel m) {
        this.fileSelectionModels.add(m);
    }

    public void removeFileSelectionModel(FileSelectionModel m) {
        this.fileSelectionModels.remove(m);
    }

    public OBComponent getObComponentByFilesystemBaseName(String name) {
        OBComponent rc = null;
        if (name != null) {
            rc = (OBComponent)this.indexes[3].get(name);
        }
        return rc;
    }

    public Vector getObComponentByBaseName(String name) {
        Vector rc = (Vector)this.indexes[1].get(name);
        return rc;
    }

    public Vector getObComponentByBaseName(String name, String dirName) {
        Vector baseMatch = this.getObComponentByBaseName(name);
        Vector<OBComponent> rc = new Vector<OBComponent>();
        if (baseMatch != null && (dirName = DFSFile.getCanonicalPath(dirName)) != null) {
            Enumeration e2 = baseMatch.elements();
            while (e2.hasMoreElements()) {
                OBComponent obc = (OBComponent)e2.nextElement();
                String directory = obc.getSourceFile().getPath().getParent();
                if (!directory.equals(dirName)) continue;
                rc.addElement(obc);
            }
        }
        return rc;
    }

    public OBComponent getObComponentByName(String name) {
        OBComponent rc = null;
        if ((name = DFSFile.getCanonicalPath(name)) != null) {
            rc = (OBComponent)this.indexes[0].get(name);
        }
        return rc;
    }

    public OBComponent getObComponentByFakeName(String name) {
        OBComponent rc = null;
        if (name != null) {
            rc = (OBComponent)this.indexes[0].get(name);
        }
        return rc;
    }

    public OBComponent getObComponentBySignature(String sig) {
        OBComponent rc = null;
        if (sig != null) {
            rc = (OBComponent)this.indexes[4].get(sig);
        }
        return rc;
    }

    public OBComponent getObComponentByArcname(String name) {
        OBComponent rc = null;
        String backName = new String(name);
        if ((name = DFSFile.getCanonicalPath(name)) != null && (rc = (OBComponent)this.indexes[2].get(name)) == null) {
            return this.getObComponentByName(backName);
        }
        return rc;
    }

    private void addObComponentToIndexes(OBComponent obc) {
        String signature;
        this.indexes[0].put(obc.getId(), obc);
        if (obc instanceof FitsFileOBComponent && !obc.isPipeProduct()) {
            FitsFileOBComponent ffoc = (FitsFileOBComponent)obc;
            this.indexes[2].put(ffoc.getArcfile(), obc);
        }
        this.indexes[3].put(DFSFile.getFileName(obc.getId()), obc);
        String baseName = DFSFile.extractBaseName(obc.getId());
        Vector<OBComponent> v = this.getObComponentByBaseName(baseName);
        if (v == null) {
            v = new Vector<OBComponent>();
            this.indexes[1].put(baseName, v);
        }
        v.addElement(obc);
        if (obc instanceof KeywordContainerOBComponent && !(signature = ((KeywordContainerOBComponent)obc).getSignature()).equals("")) {
            this.indexes[4].put(signature, obc);
        }
    }

    private void removeObComponentFromIndexes(OBComponent obc) {
        this.indexes[0].remove(obc.getId());
        if (obc instanceof FitsFileOBComponent && !obc.isPipeProduct()) {
            FitsFileOBComponent ffoc = (FitsFileOBComponent)obc;
            this.indexes[2].remove(ffoc.getArcfile());
        }
        this.indexes[3].remove(DFSFile.getFileName(obc.getId()));
        String baseName = DFSFile.extractBaseName(obc.getId());
        Vector v = this.getObComponentByBaseName(baseName);
        if (v != null) {
            v.removeElement(obc);
            if (v.isEmpty()) {
                this.indexes[1].remove(baseName);
            }
        }
    }

    public SortedHashtable getProgramSet() {
        return this.programs;
    }

    public SortedHashtable getTelescopesSet() {
        return this.telescopes;
    }

    public SortedHashtable getDirectory(String dir) {
        return (SortedHashtable)this.directories.get(dir);
    }

    public SortedHashtable getDirectoryAt(int i) {
        return (SortedHashtable)this.directories.elementAt(i);
    }

    public int getDirectoryIndex(Object dir) {
        return this.directories.indexOf(dir);
    }

    public int getDirectoryCount() {
        return this.directories.size();
    }

    public Enumeration getDirectories() {
        return this.directories.elements();
    }

    public SortedHashtable getTelescope(String tel) {
        return (SortedHashtable)this.telescopes.get(tel);
    }

    public SortedHashtable getObservationSet(String programId) {
        return this.getObservationSet(this.programs, programId);
    }

    private SortedHashtable getObservationSet(SortedHashtable progSet, String programId) {
        SortedHashtable rc = null;
        Program p = (Program)progSet.get(programId);
        if (p != null) {
            rc = p.getObservationSet();
        }
        return rc;
    }

    public Hashtable getFilesByName() {
        return this.indexes[0];
    }

    public int getTotalFilesInSet() {
        return this.totalFilesInSet;
    }

    public int getNumberOfFilesUpdated() {
        return this.numberOfFilesUpdated;
    }

    public Vector getFileSet() {
        Vector<Vector> rc = new Vector<Vector>(this.fileSelectionModels.size());
        Enumeration fileSelections = this.fileSelectionModels.elements();
        int total = 0;
        while (fileSelections.hasMoreElements()) {
            FileSelectionModel fileSelection = (FileSelectionModel)fileSelections.nextElement();
            Vector fileList = fileSelection.getFileList();
            total += fileList.size();
            rc.addElement(fileList);
        }
        this.totalFilesInSet = total;
        this.numberOfFilesUpdated = 0;
        return rc;
    }

    public void update() {
        this.update(this.getFileSet());
    }

    public synchronized void update(Vector vectorOfFileVectors) {
        DataModelEvent modelChangedEvent = null;
        this.dataModelUpdating = true;
        Hashtable tempIndex = (Hashtable)this.indexes[0].clone();
        Vector<OBComponent> updateSet = new Vector<OBComponent>();
        Enumeration fileLists = vectorOfFileVectors.elements();
        while (fileLists.hasMoreElements()) {
            Vector fileList = (Vector)fileLists.nextElement();
            Enumeration files = fileList.elements();
            while (files.hasMoreElements()) {
                String fileName = (String)files.nextElement();
                ++this.numberOfFilesUpdated;
                OBComponent comp = (OBComponent)tempIndex.remove(fileName);
                if (comp == null) {
                    int rc = this.addFile(fileName);
                    if (rc != 3 && rc != 4) {
                        if (!PropertyDB.getInstance().isDebug(1)) continue;
                        System.out.println("" + fileName + ": " + DFSFile.getStringStatus(rc) + ", ignored.");
                        continue;
                    }
                    modelChangedEvent = new DataModelEvent(1, this.getObComponentByName(fileName));
                    this.fireDataModelChangeEvent(modelChangedEvent);
                    continue;
                }
                updateSet.addElement(comp);
            }
        }
        Enumeration compToRemove = tempIndex.elements();
        int eCount = tempIndex.size();
        while (compToRemove.hasMoreElements()) {
            OBComponent c2 = (OBComponent)compToRemove.nextElement();
            if (eCount < 30) {
                modelChangedEvent = new DataModelEvent(0, c2);
                this.fireDataModelChangeEvent(modelChangedEvent);
                continue;
            }
            this.removeObComponent(c2);
        }
        Enumeration updateList = updateSet.elements();
        while (updateList.hasMoreElements()) {
            OBComponent c3 = (OBComponent)updateList.nextElement();
            c3.update();
        }
        tempIndex.clear();
        tempIndex = null;
        this.dataModelUpdating = false;
    }

    public boolean isUpdating() {
        return this.dataModelUpdating;
    }

    private int addFile(String fileName) {
        int rc = 2;
        OBComponent comp = null;
        if (fileName.endsWith(".fits") || fileName.endsWith(".fit") || fileName.endsWith(".FIT") || fileName.endsWith(".fits.Z") || fileName.endsWith(".fits.gz")) {
            comp = new FitsFileOBComponent(fileName);
        } else if (fileName.endsWith(".tfits")) {
            comp = new TFitsFileOBComponent(fileName);
        } else if (fileName.endsWith(".rX") || fileName.endsWith(".rY") || fileName.endsWith(".rZ") || fileName.endsWith(".rb")) {
            comp = new ReductionBlockOBComponent(fileName);
        } else if (PropertyDB.getInstance().getProperty("TEXTFILE_EXTENSIONS") != null) {
            Vector extTmp = GasProp.stringScanner(PropertyDB.getInstance().getProperty("TEXTFILE_EXTENSIONS"), ';');
            for (int i = 0; i < extTmp.size(); ++i) {
                if (!fileName.endsWith((String)extTmp.elementAt(i))) continue;
                comp = new DFSTextFileOBComponent(fileName);
                break;
            }
        }
        if (comp == null && PropertyDB.getInstance().isDebug(1)) {
            System.out.println(fileName + ": not recognized");
        }
        if (comp != null) {
            KeywordContainerOBComponent tmpHeader = null;
            if (comp instanceof KeywordContainerOBComponent) {
                tmpHeader = (KeywordContainerOBComponent)comp;
                if (tmpHeader.containsRbInfo() && this.getAssociatedVRB(DFSFile.extractBaseName(tmpHeader.getId())) == null) {
                    VirtualReductionBlockOBComponent vrb = new VirtualReductionBlockOBComponent(tmpHeader);
                    comp.addAssociatedReductionBlock(vrb);
                    this.addDataModelChangeListener(vrb);
                    this.addAssociatedVRB(DFSFile.extractBaseName(tmpHeader.getId()), vrb);
                }
                tmpHeader.freeHeaderMemory();
            }
            rc = comp.getStatus();
        }
        if (rc == 3 && PropertyDB.getInstance().isDebug(1)) {
            System.out.println(fileName + ": added.");
        }
        return rc;
    }

    public void reclassify() {
        Enumeration files = this.indexes[0].elements();
        long startTime = 0L;
        int filesClassified = 0;
        if (PropertyDB.getInstance().isDebug(5)) {
            startTime = System.currentTimeMillis();
        }
        while (files.hasMoreElements()) {
            OBComponent obc = (OBComponent)files.nextElement();
            if (!(obc instanceof FitsFileOBComponent)) continue;
            FitsFileOBComponent ffobc = (FitsFileOBComponent)obc;
            ffobc.classify();
            ++filesClassified;
        }
        if (PropertyDB.getInstance().isDebug(5)) {
            startTime = System.currentTimeMillis() - startTime;
            System.out.println("Reclassified " + filesClassified + " files in " + startTime + " milliseconds.");
        }
    }

    public void resetDescription() {
        Enumeration files = this.indexes[0].elements();
        long startTime = 0L;
        int filesReset = 0;
        if (PropertyDB.getInstance().isDebug(5)) {
            startTime = System.currentTimeMillis();
        }
        while (files.hasMoreElements()) {
            OBComponent obc = (OBComponent)files.nextElement();
            if (!(obc instanceof KeywordContainerOBComponent)) continue;
            KeywordContainerOBComponent hhobc = (KeywordContainerOBComponent)obc;
            hhobc.resetDescription();
            ++filesReset;
        }
        if (PropertyDB.getInstance().isDebug(5)) {
            startTime = System.currentTimeMillis() - startTime;
            System.out.println("Description Reset " + filesReset + " files in " + startTime + " milliseconds.");
        }
    }

    public ASTStart getClassifier() {
        return this.classifier;
    }

    public void setClassifier(ASTStart classifier) {
        this.classifier = classifier;
    }

    public static ASTStart createClassifier(InputStream inputStream) throws ParseException {
        return new OcaParser(inputStream).Start();
    }

    public void setFileFilter(OBComponentFilter f) {
        this.fileFilter = f;
    }

    public OBComponentFilter getFileFilter() {
        return this.fileFilter;
    }

    public void applyFilter() {
        Enumeration files = this.indexes[0].elements();
        DataModelEvent modelChangedEvent = null;
        while (files.hasMoreElements()) {
            OBComponent obc = (OBComponent)files.nextElement();
            if (this.passFilter(obc)) continue;
            modelChangedEvent = new DataModelEvent(0, obc);
            this.fireDataModelChangeEvent(modelChangedEvent);
        }
    }

    public boolean passFilter(OBComponent comp) {
        boolean rc = true;
        if (this.fileFilter != null) {
            rc = this.fileFilter.accept(comp);
        }
        return rc;
    }

    public SortedHashtable addTelescope(String telName) {
        DataModelEvent modelChangedEvent = null;
        SortedHashtable rc = this.findTelescope(telName);
        if (rc == null) {
            rc = new SortedHashtable(telName);
            this.telescopes.put(telName, rc);
            modelChangedEvent = new DataModelEvent(10, rc);
            modelChangedEvent.setTreeType(2);
            this.fireDataModelChangeEvent(modelChangedEvent);
        }
        if (PropertyDB.getInstance().isDebug(1)) {
            System.out.println("Added Telescope: " + telName);
        }
        return rc;
    }

    public SortedHashtable findTelescope(String telName) {
        return (SortedHashtable)this.telescopes.get(telName);
    }

    public void removeTelescope(String telName) {
        DataModelEvent modelChangedEvent = null;
        modelChangedEvent = new DataModelEvent(9, this.findTelescope(telName));
        modelChangedEvent.setTreeType(2);
        this.telescopes.remove(telName);
        this.fireDataModelChangeEvent(modelChangedEvent);
        if (PropertyDB.getInstance().isDebug(1)) {
            System.out.println("Removed Telescope: " + telName);
        }
    }

    public SortedHashtable addDirectory(String dirName) {
        DataModelEvent modelChangedEvent = null;
        SortedHashtable rc = this.findDirectory(dirName);
        if (rc == null) {
            rc = new SortedHashtable(dirName);
            this.directories.put(dirName, rc);
            modelChangedEvent = new DataModelEvent(8, this.findDirectory(dirName));
            modelChangedEvent.setTreeType(1);
            this.fireDataModelChangeEvent(modelChangedEvent);
        }
        return rc;
    }

    public SortedHashtable findDirectory(String dirName) {
        return (SortedHashtable)this.directories.get(dirName);
    }

    public void removeDirectory(String dirName) {
        DataModelEvent modelChangedEvent = null;
        modelChangedEvent = new DataModelEvent(7, this.findDirectory(dirName));
        modelChangedEvent.setTreeType(1);
        this.directories.remove(dirName);
        this.fireDataModelChangeEvent(modelChangedEvent);
    }

    public Program addProgram(String id, OBComponent obc) {
        return this.addProgram(this.programs, id, obc);
    }

    private Program addProgram(SortedHashtable progSet, String id, OBComponent obc) {
        DataModelEvent modelChangedEvent = null;
        Program rc = this.findProgram(progSet, id);
        if (rc == null) {
            rc = new Program(id);
            if (this.progDescFactory != null) {
                this.progDescFactory.setDescription(rc, obc);
            }
            progSet.put(id, rc);
            modelChangedEvent = new DataModelEvent(4, rc);
            if (progSet == this.programs) {
                modelChangedEvent.setTreeType(0);
            } else if (this.findDirectory(progSet.toString()) != null) {
                rc.setDirectory(progSet);
                modelChangedEvent.setTreeType(1);
            } else if (this.findTelescope(progSet.toString()) != null) {
                rc.setTelescope(progSet);
                modelChangedEvent.setTreeType(2);
            } else {
                System.out.println("Unidentified progSet " + progSet);
            }
            this.fireDataModelChangeEvent(modelChangedEvent);
            if (PropertyDB.getInstance().isDebug(1)) {
                System.out.println("Added Prog: " + id + " to " + (progSet == this.programs ? "programs" : progSet.toString()));
            }
        }
        return rc;
    }

    public Program findProgram(String id) {
        return this.findProgram(this.programs, id);
    }

    public Program findProgram(SortedHashtable progSet, String id) {
        return (Program)progSet.get(id);
    }

    public void removeProgram(String id) {
        this.removeProgram(this.programs, id);
    }

    private void removeProgram(SortedHashtable progSet, String id) {
        DataModelEvent modelChangedEvent = null;
        Program tmpProgram = null;
        tmpProgram = this.findProgram(progSet, id);
        if (tmpProgram != null) {
            modelChangedEvent = new DataModelEvent(3, tmpProgram);
            if (progSet == this.programs) {
                modelChangedEvent.setTreeType(0);
            } else if (this.findDirectory(progSet.toString()) != null) {
                modelChangedEvent.setTreeType(1);
            } else if (this.findTelescope(progSet.toString()) != null) {
                modelChangedEvent.setTreeType(2);
            } else {
                System.out.println("DataModel::removeProgram: Unidentified progSet " + progSet);
            }
            progSet.remove(id);
            this.fireDataModelChangeEvent(modelChangedEvent);
        }
        if (PropertyDB.getInstance().isDebug(1)) {
            System.out.println("Removed Prog: " + id + " from " + (progSet == this.programs ? "programs" : progSet.toString()));
        }
    }

    public Observation addObservationAndFire(Program prog, String obId, OBComponent obc) {
        DataModelEvent modelChangedEvent = null;
        Observation obs = null;
        if (prog.findObservation(obId) == null) {
            obs = prog.addObservation(obId, obc);
            obs.setProgram(prog);
            modelChangedEvent = new DataModelEvent(6, obs);
            if (prog.getTelescope() != null) {
                modelChangedEvent.setTreeType(2);
            } else if (prog.getDirectory() != null) {
                modelChangedEvent.setTreeType(1);
            } else if (this.findProgram(prog.getId()) != null) {
                modelChangedEvent.setTreeType(0);
            } else {
                System.out.println("DataModel::addObservation: Unidentified progSet " + prog);
                this.displayHashKeys(this.programs);
                System.out.flush();
                System.out.println("%%%%%%%%%%%%%%%%");
                return obs;
            }
            this.fireDataModelChangeEvent(modelChangedEvent);
        } else {
            obs = prog.addObservation(obId, obc);
        }
        return obs;
    }

    public InterContainer addIntermediate(Observation obs, OBComponent obc, int treeModelMode, String name) {
        InterContainer rc = null;
        DataModelEvent modelChangedEvent = null;
        rc = obs.findIntermediate(name);
        if (rc == null) {
            rc = obs.addIntermediate(name);
            modelChangedEvent = new DataModelEvent(12, rc);
            Program prog = obs.getProgram();
            if (prog.getTelescope() != null) {
                modelChangedEvent.setTreeType(2);
            } else if (prog.getDirectory() != null) {
                modelChangedEvent.setTreeType(1);
            } else if (this.findProgram(prog.getId()) != null) {
                modelChangedEvent.setTreeType(0);
            } else {
                System.out.println("DataModel::addIntermediate: Unidentified progSet " + prog);
                this.displayHashKeys(this.programs);
                System.out.flush();
                System.out.println("%%%%%%%%%%%%%%%%");
                return rc;
            }
        }
        rc.addObComponent(obc);
        obc.setObservation(rc, treeModelMode);
        rc.setObservation(obs);
        if (modelChangedEvent != null) {
            this.fireDataModelChangeEvent(modelChangedEvent);
        }
        return rc;
    }

    public void removeIntermediate(Observation obs, InterContainer inter, int treeModelMode) {
        DataModelEvent modelChangedEvent = new DataModelEvent(11, inter);
        modelChangedEvent.setTreeType(treeModelMode);
        obs.removeIntermediate(inter);
        inter.cleanup();
        this.fireDataModelChangeEvent(modelChangedEvent);
    }

    public void addObComponent(String progId, String obId, String directoryName, String telName, OBComponent obc) {
        boolean debug = false;
        boolean interMediate = false;
        String interMediateName = null;
        if (this.getObComponentByName(obc.getId()) == null) {
            InterContainer inter;
            if (obc instanceof KeywordContainerOBComponent) {
                interMediate = ((KeywordContainerOBComponent)obc).hasIntermediate();
                interMediateName = obc.getIntermediateGrouping();
            }
            this.addObComponentToIndexes(obc);
            if (debug) {
                System.out.println("********* Prog/OB Tree");
                System.out.flush();
            }
            Program prog = this.addProgram(progId, obc);
            Observation obs = this.addObservationAndFire(prog, obId, obc);
            if (interMediate) {
                InterContainer inter2 = this.addIntermediate(obs, obc, 0, interMediateName);
            } else {
                obs.addObComponent(obc);
                obc.setObservation(obs, 0);
            }
            if (debug) {
                System.out.println("********* Directory/ Prog/OB Tree");
                System.out.flush();
            }
            SortedHashtable progSet = this.addDirectory(directoryName);
            prog = this.addProgram(progSet, progId, obc);
            obs = this.addObservationAndFire(prog, obId, obc);
            if (interMediate) {
                inter = this.addIntermediate(obs, obc, 1, interMediateName);
            } else {
                obs.addObComponent(obc);
                obc.setObservation(obs, 1);
            }
            if (debug) {
                System.out.println("********* Telescope /Prog /OB Tree");
                System.out.flush();
            }
            progSet = this.addTelescope(telName);
            prog = this.addProgram(progSet, progId, obc);
            obs = this.addObservationAndFire(prog, obId, obc);
            if (interMediate) {
                inter = this.addIntermediate(obs, obc, 2, interMediateName);
            } else {
                obs.addObComponent(obc);
                obc.setObservation(obs, 2);
            }
            if (PropertyDB.getInstance().isDebug(1)) {
                System.out.println("Added: " + obc.getId() + " to: " + progId + " " + obId);
            }
        }
    }

    public void removeObComponent(String name) {
        OBComponent obc = this.getObComponentByName(name);
        this.removeObComponent(obc);
    }

    public void obsProgSummary() {
        Enumeration progE = null;
        Enumeration obsE = null;
        Enumeration dirE = this.directories.elements();
        while (dirE.hasMoreElements()) {
            SortedHashtable dir = (SortedHashtable)dirE.nextElement();
            System.out.println(dir + ":");
            progE = dir.elements();
            while (progE.hasMoreElements()) {
                Program prog = (Program)progE.nextElement();
                System.out.println("\t" + prog);
                obsE = prog.getObservationSet().elements();
                while (obsE.hasMoreElements()) {
                    Observation obs = (Observation)obsE.nextElement();
                    System.out.println("\t\t<" + obs + "> " + obs.getComponentCount() + " components");
                }
            }
        }
    }

    public void removeObComponent(OBComponent obc) {
        Observation obs = null;
        InterContainer inter = null;
        Program prog = null;
        SortedHashtable telescope = null;
        SortedHashtable directory = null;
        boolean interMediate = false;
        DataModelEvent modelChangedEvent = null;
        int delay = 0;
        this.removeObComponentFromIndexes(obc);
        if (obc instanceof KeywordContainerOBComponent) {
            interMediate = ((KeywordContainerOBComponent)obc).hasIntermediate();
        }
        if (interMediate) {
            inter = (InterContainer)obc.getObservation(1);
            obs = inter.getObservation();
        } else {
            obs = obc.getObservation(1);
        }
        prog = obs.getProgram();
        if (prog != null) {
            directory = prog.getDirectory();
            if (directory != null) {
                if (obs != null) {
                    if (interMediate) {
                        if (inter != null) {
                            inter.removeObComponent(obc);
                            if (inter.isEmpty()) {
                                this.removeIntermediate(obs, inter, 1);
                            }
                            if (obs.isEmpty()) {
                                modelChangedEvent = new DataModelEvent(5, obs);
                                modelChangedEvent.setTreeType(1);
                                prog.removeObservation(obs.getId());
                                obs.cleanup();
                                this.fireDataModelChangeEvent(modelChangedEvent);
                            }
                        }
                    } else {
                        obs.removeObComponent(obc);
                        if (obs.isEmpty()) {
                            modelChangedEvent = new DataModelEvent(5, obs);
                            modelChangedEvent.setTreeType(1);
                            prog.removeObservation(obs.getId());
                            obs.cleanup();
                            this.fireDataModelChangeEvent(modelChangedEvent);
                        }
                    }
                }
                if (prog.isEmpty()) {
                    DFSDataModel.sleep(delay);
                    this.removeProgram(directory, prog.getId());
                    prog.cleanup();
                }
            }
            if (directory.isEmpty()) {
                this.removeDirectory(directory.toString());
            }
        }
        if (interMediate) {
            inter = (InterContainer)obc.getObservation(2);
            obs = inter.getObservation();
        } else {
            obs = obc.getObservation(2);
        }
        prog = obs.getProgram();
        if (prog != null) {
            telescope = prog.getTelescope();
            if (telescope != null) {
                if (obs != null) {
                    if (interMediate) {
                        if (inter != null) {
                            inter.removeObComponent(obc);
                            if (inter.isEmpty()) {
                                this.removeIntermediate(obs, inter, 2);
                            }
                            if (obs.isEmpty()) {
                                modelChangedEvent = new DataModelEvent(5, obs);
                                modelChangedEvent.setTreeType(2);
                                prog.removeObservation(obs.getId());
                                obs.cleanup();
                                this.fireDataModelChangeEvent(modelChangedEvent);
                            }
                        }
                    } else {
                        obs.removeObComponent(obc);
                        if (obs.isEmpty()) {
                            modelChangedEvent = new DataModelEvent(5, obs);
                            modelChangedEvent.setTreeType(2);
                            prog.removeObservation(obs.getId());
                            obs.cleanup();
                            this.fireDataModelChangeEvent(modelChangedEvent);
                        }
                    }
                }
                if (prog.isEmpty()) {
                    prog.cleanup();
                    DFSDataModel.sleep(delay);
                    this.removeProgram(telescope, prog.getId());
                }
            }
            if (telescope.isEmpty()) {
                this.removeTelescope(telescope.toString());
            }
        }
        if (interMediate) {
            inter = (InterContainer)obc.getObservation(0);
            obs = inter.getObservation();
        } else {
            obs = obc.getObservation(0);
        }
        prog = obs.getProgram();
        if (prog != null) {
            if (obs != null) {
                if (interMediate) {
                    if (inter != null) {
                        inter.removeObComponent(obc);
                        if (inter.isEmpty()) {
                            this.removeIntermediate(obs, inter, 0);
                        }
                        if (obs.isEmpty()) {
                            modelChangedEvent = new DataModelEvent(5, obs);
                            modelChangedEvent.setTreeType(0);
                            prog.removeObservation(obs.getId());
                            this.fireDataModelChangeEvent(modelChangedEvent);
                        }
                    }
                } else {
                    obs.removeObComponent(obc);
                    if (obs.isEmpty()) {
                        modelChangedEvent = new DataModelEvent(5, obs);
                        modelChangedEvent.setTreeType(0);
                        prog.removeObservation(obs.getId());
                        this.fireDataModelChangeEvent(modelChangedEvent);
                    }
                }
            }
            if (prog.isEmpty()) {
                DFSDataModel.sleep(delay);
                this.removeProgram(prog.getId());
            }
            obc.cleanup();
            if (PropertyDB.getInstance().isDebug(1)) {
                System.out.println("Removed: " + obc.getId());
            }
        }
    }

    private static void sleep(int x) {
        try {
            Thread.sleep(x);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Program getProgramAt(int i) {
        return (Program)this.programs.elementAt(i);
    }

    public int getIndexOfProgram(Program prog) {
        return this.programs.indexOf(prog);
    }

    public int getProgramCount() {
        return this.programs.size();
    }

    public void getAssociatedFiles(OBComponent obc, Vector inputFiles, Vector masterCalibFiles, Vector reductionBlocks, Vector productFiles) {
        Vector associatedRbs = obc.getAssociatedReductionBlocks();
        if (associatedRbs != null) {
            Enumeration e2 = associatedRbs.elements();
            while (e2.hasMoreElements()) {
                ReductionBlockCommon rbComp = (ReductionBlockCommon)e2.nextElement();
                DFSDataModel.copyVector(rbComp.getInputFileNames(), inputFiles);
                DFSDataModel.copyVector(rbComp.getMasterCalibFileNames(), masterCalibFiles);
                reductionBlocks.addElement(rbComp.getId());
                DFSDataModel.copyVector(rbComp.getProductFileNames(), productFiles);
            }
        }
    }

    public VirtualReductionBlockOBComponent getAssociatedVRB(String productBaseName) {
        VirtualReductionBlockOBComponent rc = null;
        rc = (VirtualReductionBlockOBComponent)this.indexes[5].get(productBaseName);
        return rc;
    }

    private void addAssociatedVRB(String productBaseName, VirtualReductionBlockOBComponent vrb) {
        this.indexes[5].put(productBaseName, vrb);
    }

    public void removeAssociatedVRB(String productBaseName) {
        this.indexes[5].remove(productBaseName);
    }

    private static void copyVector(Vector from, Vector to) {
        if (from == null || from.isEmpty() || to == null) {
            return;
        }
        Enumeration e2 = from.elements();
        while (e2.hasMoreElements()) {
            Object obj = e2.nextElement();
            if (obj == null || to.contains(obj)) continue;
            to.addElement(obj);
        }
    }

    private void displayHashKeys(SortedHashtable ht) {
        Enumeration myEnum = ht.elements();
        System.out.println("( ");
        while (myEnum.hasMoreElements()) {
            String tmpString = myEnum.nextElement().toString();
            System.out.print(tmpString + " ");
        }
        System.out.println(")");
    }

    public boolean isModelEmpty() {
        boolean rc = false;
        Vector tmpVector = this.getFileSet();
        if (tmpVector.size() == 0 || ((Vector)tmpVector.elementAt(0)).size() == 0 && tmpVector.size() == 1) {
            rc = true;
        }
        return rc;
    }

    public void provideFrameInfo(KeywordContainerOBComponent hhoc, FrameInfo fi) {
        if (hhoc.hasIntermediate()) {
            InterContainer inter = (InterContainer)hhoc.getObservation(0);
            fi.obsId = inter.getObservation().getId();
            fi.programId = inter.getObservation().getProgram().getId();
            inter = (InterContainer)hhoc.getObservation(2);
            fi.telescopeId = inter.getObservation().getProgram().getTelescope().toString();
        } else {
            Observation tmpObs = hhoc.getObservation(0);
            fi.obsId = tmpObs.getId();
            fi.programId = tmpObs.getProgram().getId();
            tmpObs = hhoc.getObservation(2);
            fi.telescopeId = tmpObs.getProgram().getTelescope().toString();
        }
    }

    public String getClassificationForName(String comp) {
        FitsFileOBComponent ffoc;
        String rc = null;
        OBComponent obc = this.getObComponentByFakeName(comp);
        rc = obc instanceof FitsFileOBComponent ? ((ffoc = (FitsFileOBComponent)obc) != null ? ffoc.getClassification() : new String("*ERROR*")) : new String("NO-HEADER");
        return rc;
    }

    @Override
    public void processNodes(AssociationNode[] nodes) throws ServiceException {
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            FileAssociationNode fnode;
            File address;
            OBComponent obc;
            AssociationNode node = nodes[i];
            if (!(node instanceof FileAssociationNode) || (obc = this.getObComponentByName((address = (fnode = (FileAssociationNode)node).getAddress()).getPath())) == null || !(obc instanceof KeywordContainerOBComponent)) continue;
            this.classifyFileAssociationNode(fnode, (KeywordContainerOBComponent)obc);
        }
    }

    private void classifyFileAssociationNode(FileAssociationNode node, KeywordContainerOBComponent ffoc) {
        node.setClassification(new String[]{ffoc.getClassification()});
        node.setInstrumentName(ffoc.getInstrument());
        node.setGrouping(new String[]{ffoc.getIntermediateGrouping()});
        node.setCategory(ffoc.isCalibFrame() ? "CALIB" : "RAW");
    }

    @Override
    public void addFiles(File[] files) throws ServiceException {
        for (int i = 0; i < files.length; ++i) {
            this.serviceFileModel.addFile(files[i]);
        }
        this.update();
    }

    @Override
    public void removeFiles(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.serviceFileModel.removeFile(files[i]);
        }
        this.update();
    }
}

