/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.eso.gasgano.datamodel.FileDescription;
import org.eso.gasgano.datamodel.database.DBContainer;
import org.eso.gasgano.datamodel.gui.FitsFileDisplay;
import org.eso.gasgano.datamodel.gui.FitsTableModel;
import org.eso.gasgano.gui.GUIUtils;
import org.eso.gasgano.keyword.ClassificationRule;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.keyword.KeywordBlock;
import org.eso.gasgano.keyword.KeywordSet;
import org.eso.gasgano.keyword.RuleTable;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.RADECConverter;
import org.eso.gasgano.tools.SortedHashtable;

public class DBOBComponent
implements KeywordSet {
    private static final double threeMil = 3600000.0;
    private SortedHashtable hTable = null;
    private Vector keywordArray = null;
    private SortedHashtable program = null;
    private SortedHashtable ob = null;
    private String telescope = null;
    private DBContainer[] obs = new DBContainer[3];
    private String fileName = null;
    private static Vector keywordFilter;
    private static FileDescription descFactory;
    private String classification = null;
    private boolean isPipeProduct = false;
    private static Keyword[] defaultKeywordQuery;
    private static final int numberIdKeys = 3;
    private String[] columnDisplayData = null;
    private Font labelFont = null;
    private static JLabel rawLabel;

    public DBOBComponent() {
        this.hTable = new SortedHashtable();
        this.keywordArray = new Vector(0);
    }

    public void init() {
        if (defaultKeywordQuery == null) {
            DBOBComponent.setDefaultKeywordQuery(null);
        }
        this.fileName = this.getKeyword("ARCFILE").getValue();
        this.classify();
        this.addKeyword(new Keyword("CLASSIFICATION", this.getClassification()));
        this.fillDefaultKeywords();
        this.setDescription();
        this.setTelescope(this.getKeyword("TELESCOP").getValue());
    }

    public String toString() {
        return this.fileName;
    }

    public String getId() {
        return this.toString();
    }

    public KeywordBlock getHeaderKeywordBlock() {
        return new KeywordBlock(this.keywordArray, this.hTable);
    }

    private void fillDefaultKeywords() {
        for (int z = 0; z < defaultKeywordQuery.length; ++z) {
            Keyword tmpKey = this.getKeyword(defaultKeywordQuery[z].getName());
            defaultKeywordQuery[z].setValue(tmpKey == null ? "" : tmpKey.getValue());
        }
    }

    public void setDescription() {
        if (DBOBComponent.getDefaultFileDescription() != null) {
            DBOBComponent.getDefaultFileDescription().setDescription(this);
        }
    }

    public static void setDefaultFileDescription(FileDescription d2) {
        descFactory = d2;
    }

    public static FileDescription getDefaultFileDescription() {
        return descFactory;
    }

    public static Keyword[] getDefaultKeywordQuery() {
        return defaultKeywordQuery;
    }

    public static void setDefaultKeywordQuery(Keyword[] k) {
        int klen = 0;
        if (k != null) {
            klen = k.length;
        }
        defaultKeywordQuery = new Keyword[3 + klen];
        DBOBComponent.defaultKeywordQuery[0] = new Keyword("OBS.PROG.ID", null);
        DBOBComponent.defaultKeywordQuery[1] = new Keyword("OBS.ID", null);
        DBOBComponent.defaultKeywordQuery[2] = new Keyword("ARCFILE", null);
        if (k != null) {
            System.arraycopy(k, 0, defaultKeywordQuery, 3, k.length);
        }
    }

    public static void addToDefaultKeywordQuery(Keyword[] k) {
        if (defaultKeywordQuery == null) {
            DBOBComponent.setDefaultKeywordQuery(k);
        } else if (k != null) {
            Keyword[] temp = defaultKeywordQuery;
            defaultKeywordQuery = new Keyword[temp.length + k.length];
            System.arraycopy(temp, 0, defaultKeywordQuery, 0, temp.length);
            System.arraycopy(k, 0, defaultKeywordQuery, temp.length, k.length);
        }
    }

    public String[] getDisplayData() {
        return this.columnDisplayData;
    }

    public void setDisplayData(String[] cols) {
        this.columnDisplayData = cols;
    }

    public void setProgram(SortedHashtable p) {
        this.program = p;
    }

    public void setTelescope(String tel) {
        this.telescope = tel;
    }

    public void setObservation(DBContainer o, int mode) {
        this.obs[mode] = o;
    }

    public DBContainer getObservation(int mode) {
        return this.obs[mode];
    }

    public SortedHashtable getProgram() {
        return this.program;
    }

    public String getTelescope() {
        if (this.telescope != null && !this.telescope.equals(new String(""))) {
            return this.telescope;
        }
        return "Unknown Telescope";
    }

    public Vector getVector() {
        return this.keywordArray;
    }

    public void classify() {
        System.err.println("DBOBComponent::classify() is not available any more.");
    }

    public void classify(RuleTable t) {
        long startTime = 0L;
        if (PropertyDB.getInstance().isDebug(5)) {
            startTime = System.currentTimeMillis();
        }
        this.classification = null;
        if (t != null) {
            Enumeration e2 = null;
            Keyword instrument = this.getKeyword("INSTRUME");
            e2 = instrument != null ? t.elements(instrument.getValue()) : t.elements();
            while (e2.hasMoreElements()) {
                ClassificationRule rule = (ClassificationRule)e2.nextElement();
                if (rule == null || !rule.match(this)) continue;
                this.classification = rule.getClassification();
                break;
            }
        }
        if (this.classification == null) {
            this.classification = "UNCLASSIFIED";
        }
    }

    public String getClassification() {
        return this.classification;
    }

    public static void setKeywordFilter(Vector kwv) {
        keywordFilter = kwv;
    }

    public static Vector getKeywordFilter() {
        return keywordFilter;
    }

    public JComponent getTreeCellComponent() {
        JLabel cell = null;
        Color foreGround = null;
        cell = rawLabel;
        foreGround = GUIUtils.dataBaseColor;
        cell.setText(this.toString());
        cell.setForeground(foreGround);
        cell.setFont(this.getLabelFont());
        return cell;
    }

    public Font getLabelFont() {
        if (this.labelFont == null) {
            String fontString = PropertyDB.getInstance().getProperty("COMPONENT_FONT");
            String fontName = fontString.substring(0, fontString.indexOf(":", 0));
            String fontSize = fontString.substring(fontString.indexOf(":", 0) + 1, fontString.length());
            this.labelFont = new Font(fontName, 0, Integer.parseInt(fontSize));
        }
        return this.labelFont;
    }

    public JComponent getDisplayComponent() {
        FitsFileDisplay rc = null;
        String title = null;
        title = this.toString() + " " + this.getClassification();
        rc = new FitsFileDisplay(title, new FitsTableModel(this));
        return rc;
    }

    @Override
    public Keyword getKeyword(String name) {
        Keyword rc = null;
        rc = (Keyword)this.hTable.get(name);
        return rc;
    }

    @Override
    public void addKeyword(Keyword k) {
        if (k != null) {
            double tmp;
            if (k.getName().equals("RA")) {
                tmp = Double.valueOf(k.getValue());
                k.setValue(RADECConverter.RAconvert(String.valueOf(tmp /= 3600000.0)));
            }
            if (k.getName().equals("DEC")) {
                tmp = Double.valueOf(k.getValue());
                k.setValue(RADECConverter.DECconvert(String.valueOf(tmp /= 3600000.0)));
            }
            try {
                this.hTable.put(k.getName(), k);
            }
            catch (NullPointerException ex) {
                System.out.println("error:" + ex.toString());
            }
            this.keywordArray.addElement(k);
        }
    }

    @Override
    public void removeKeyword(String k) {
    }

    @Override
    public void replaceKeyword(Keyword k) {
    }

    public void freeHeaderMemory() {
        this.hTable.clear();
        this.keywordArray.removeAllElements();
    }

    static {
        descFactory = null;
        defaultKeywordQuery = null;
        rawLabel = new JLabel(new ImageIcon(Object.class.getResource("/org/eso/gasgano/gui/icons/rawfits.gif")), 0);
    }
}

