/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Cursor;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import org.eso.gasgano.datamodel.DataModelChangeListener;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.datamodel.OBComponentFilter;
import org.eso.gasgano.datamodel.database.DBContainer;
import org.eso.gasgano.datamodel.database.DBDataModel;
import org.eso.gasgano.datamodel.gui.DBOBComponent;
import org.eso.gasgano.gui.AbstractTreeTableModel;
import org.eso.gasgano.gui.TreeTableModel;
import org.eso.gasgano.properties.GasProp;

public class DBTreeTableModel
extends AbstractTreeTableModel
implements DataModelChangeListener,
TreeExpansionListener {
    private Vector treeListeners = null;
    private DBDataModel dm = null;
    private RootNode root = new RootNode();
    private Vector displayCols = null;
    private int groupDataByLevel = 0;
    protected Vector allTheLeaves = new Vector();
    private JTree theTree = null;

    public DBTreeTableModel(DBDataModel d2) {
        this.init(d2);
    }

    private void init(DBDataModel d2) {
        this.dm = d2;
        this.treeListeners = new Vector();
        this.setRootLabel(null);
        this.dm.addDataModelChangeListener(this);
        this.displayCols = GasProp.getProperties().dbDisplayColumns;
    }

    public void setTree(JTree tree) {
        this.theTree = tree;
    }

    public int getGroupDataByLevel() {
        return this.groupDataByLevel;
    }

    public void setGroupDataByLevel(int gbLevel) {
        if (this.groupDataByLevel != gbLevel) {
            this.groupDataByLevel = gbLevel;
            this.setRootLabel(null);
            this.updateTree();
        }
    }

    public void setRootLabel(String name) {
        if (name == null) {
            String suffix = null;
            String filterStr = null;
            OBComponentFilter filter = this.dm.getFileFilter();
            filterStr = filter != null ? new String("Filter: " + filter.getDescription()) : new String("Unfiltered");
            if (this.groupDataByLevel == 0) {
                suffix = new String("");
            }
            if (this.groupDataByLevel == 2) {
                suffix = new String(" grouped by telescope.");
            }
            name = new String("Displaying " + this.dm.getProgramCount() + " programs " + suffix + " " + filterStr + ".");
        }
        this.root.setLabel(name);
    }

    public String getRootLabel() {
        String rc = null;
        if (this.root != null) {
            this.root.getLabel();
        }
        return rc;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object rc = null;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getProgramAt(index);
            }
            if (this.groupDataByLevel == 2) {
                rc = this.dm.getTelescopesSet().elementAt(index);
            }
        } else if (parent instanceof DBContainer) {
            DBContainer tmpContainer = (DBContainer)parent;
            rc = tmpContainer.elementAt(index);
        } else {
            rc = null;
        }
        return rc;
    }

    @Override
    public int getChildCount(Object parent) {
        int rc = 0;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getProgramCount();
            }
            if (this.groupDataByLevel == 2) {
                rc = this.dm.getTelescopesSet().size();
            }
        } else {
            rc = parent instanceof DBContainer ? ((DBContainer)parent).virtualSize() : 0;
        }
        return rc;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int rc = -1;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getIndexOfProgram((DBContainer)child);
            }
            if (this.groupDataByLevel == 2) {
                rc = this.dm.getTelescopesSet().indexOf(child);
            }
        } else {
            rc = parent instanceof DBContainer ? ((DBContainer)parent).indexOf(child) : -1;
        }
        return rc;
    }

    @Override
    public int getColumnCount() {
        return this.displayCols.size() + 1;
    }

    @Override
    public String getColumnName(int column) {
        String rc = null;
        rc = column == 0 ? "File" : (String)this.displayCols.elementAt(column - 1);
        return rc;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        Object rc = null;
        if (column > 0) {
            if (node instanceof DBOBComponent) {
                String[] colData = null;
                colData = ((DBOBComponent)node).getDisplayData();
                if (colData != null && colData.length >= column) {
                    rc = colData[column - 1];
                }
            }
        } else {
            rc = node;
        }
        return rc;
    }

    public void toggleColumn() {
        this.displayCols = GasProp.getProperties().dbDisplayColumns;
    }

    @Override
    public Class getColumnClass(int column) {
        Class rc = null;
        rc = column == 0 ? TreeTableModel.class : String.class;
        return rc;
    }

    @Override
    public Object getRoot() {
        if (this.root == null) {
            this.setRootLabel(null);
        }
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean rc = false;
        if (node instanceof DBOBComponent) {
            rc = true;
        }
        return rc;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void dataModelChanged(DataModelEvent e2) {
        this.setRootLabel(null);
        boolean debug = false;
        int eType = 0;
        Object[] path = null;
        Object[] ancestors = null;
        Object child = e2.getFile();
        eType = e2.getEvent();
        if (child == null) {
            System.err.println("DataModelChange Event sent with no OBComponent/Program/Observatio");
            return;
        }
        path = this.getPathToRoot(child);
        ancestors = new Object[path.length - 1];
        for (int z = 0; z < ancestors.length; ++z) {
            ancestors[z] = path[z];
        }
        if ((eType == 9 || eType == 10) && this.getGroupDataByLevel() != 3) {
            return;
        }
        if ((eType == 7 || eType == 8) && this.getGroupDataByLevel() != 2) {
            return;
        }
        if (debug) {
            System.err.print(">>> firing ");
            switch (eType) {
                case 3: {
                    System.err.print("PROGRAM_DELETED");
                    break;
                }
                case 4: {
                    System.err.print("PROGRAM_ADDED");
                    break;
                }
                case 5: {
                    System.err.print("OBSERVATION_DELETED");
                    break;
                }
                case 6: {
                    System.err.print("OBSERVATION_ADDED");
                    break;
                }
                case 7: {
                    System.err.print("DIRECTORY_DELETED");
                    break;
                }
                case 8: {
                    System.err.print("DIRECTORY_ADDED");
                    break;
                }
                case 10: {
                    System.err.print("TELESCOPE_ADDED");
                    break;
                }
                case 9: {
                    System.err.print("TELESCOPE_DELETED");
                    break;
                }
                case 1: {
                    System.err.print("FILE_ADDED");
                    break;
                }
                case 0: {
                    System.err.print("FILE_DELETED");
                }
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Reloader(ancestors));
        } else {
            try {
                SwingUtilities.invokeAndWait(new Reloader(ancestors));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (debug) {
            System.err.flush();
            System.err.print(" [ ");
            for (int i = 0; i < path.length; ++i) {
                System.err.print(path[i] + ", ");
                if (path[i] != null) continue;
                System.err.println("\nChild " + child + " has a null element in path");
            }
            System.err.print("]\n");
        }
    }

    public void updateTree() {
        this.setRootLabel(null);
        Object[] path = new Object[]{this.root};
        this.fireTreeStructureChanged(this, path, null, null);
        this.theTree.expandPath(new TreePath(this.root));
    }

    protected Enumeration getChildren(Object parent) {
        Object rc = null;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getProgramSet();
            }
            if (this.groupDataByLevel == 2) {
                rc = this.dm.getTelescopesSet();
            }
        } else if (parent instanceof DBContainer) {
            rc = ((DBContainer)parent).elements();
            if (rc == null) {
                System.err.println("No children");
            }
        } else {
            rc = null;
        }
        return (Enumeration)rc;
    }

    public Object[] getPathToRoot(Object child) {
        Object child2;
        Object[] path = null;
        if (child instanceof DBOBComponent) {
            child2 = (DBOBComponent)child;
            if (this.groupDataByLevel == 0) {
                path = new Object[4];
                path[3] = child2;
                path[2] = ((DBOBComponent)child2).getObservation(0);
                path[1] = ((DBContainer)path[2]).getFather();
                path[0] = this.getRoot();
            }
            if (this.groupDataByLevel == 2) {
                path = new Object[5];
                path[4] = child2;
                path[3] = ((DBOBComponent)child2).getObservation(2);
                path[2] = ((DBContainer)path[3]).getFather();
                path[1] = ((DBContainer)path[2]).getFather();
                path[0] = this.getRoot();
            }
        }
        if (child instanceof DBContainer) {
            if (this.groupDataByLevel == 0) {
                child2 = (DBContainer)child;
                if (((DBContainer)child2).isProgram()) {
                    path = new Object[]{this.getRoot(), child};
                } else {
                    path = new Object[3];
                    path[0] = this.getRoot();
                    path[2] = child;
                    path[1] = ((DBContainer)child2).getFather();
                }
            }
            if (this.groupDataByLevel == 2) {
                child2 = (DBContainer)child;
                if (((DBContainer)child2).isTelescope()) {
                    path = new Object[]{this.getRoot(), child};
                } else if (((DBContainer)child2).isProgram()) {
                    path = new Object[3];
                    path[0] = this.getRoot();
                    path[2] = child;
                    path[1] = ((DBContainer)child2).getFather();
                } else {
                    path = new Object[4];
                    path[0] = this.getRoot();
                    path[3] = child;
                    path[2] = ((DBContainer)child2).getFather();
                    path[1] = ((DBContainer)path[2]).getFather();
                }
            }
        }
        if (child instanceof RootNode) {
            path = new Object[]{child};
        }
        return path;
    }

    public Vector getAllTheLeaves(Object father) {
        this.allTheLeaves.removeAllElements();
        this.rec_traverse(father);
        return this.allTheLeaves;
    }

    public void rec_traverse(Object father) {
        if (this.isLeaf(father)) {
            this.allTheLeaves.addElement(father);
            return;
        }
        Enumeration e2 = this.getChildren(father);
        while (e2.hasMoreElements()) {
            this.rec_traverse(e2.nextElement());
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        DBContainer tmpCont = null;
        if (event.getPath().getLastPathComponent() instanceof DBContainer) {
            tmpCont = (DBContainer)event.getPath().getLastPathComponent();
            this.dm.collapseContainer(tmpCont);
        }
    }

    @Override
    public void treeExpanded(final TreeExpansionEvent event) {
        final Cursor tmpCursor = this.theTree.getCursor();
        this.theTree.setCursor(new Cursor(3));
        Runnable expanderRun = new Runnable(){

            @Override
            public void run() {
                DBContainer tmpCont = null;
                if (event.getPath().getLastPathComponent() instanceof DBContainer) {
                    tmpCont = (DBContainer)event.getPath().getLastPathComponent();
                    DBTreeTableModel.this.dm.expandContainer(tmpCont);
                }
                DBTreeTableModel.this.theTree.setCursor(tmpCursor);
            }
        };
        expanderRun.run();
    }

    public void expandAllTheNodes(int row) {
        final TreePath tp = this.theTree.getPathForRow(row);
        Runnable recExpander = new Runnable(){

            @Override
            public void run() {
                Cursor tmpCursor = DBTreeTableModel.this.theTree.getCursor();
                DBTreeTableModel.this.recExpand(tp);
                DBTreeTableModel.this.theTree.setCursor(tmpCursor);
            }
        };
        new Thread(recExpander).start();
    }

    private void recExpand(TreePath tp) {
        if (tp == null) {
            return;
        }
        Object parent = tp.getLastPathComponent();
        this.theTree.expandPath(tp);
        if (this.isLeaf(parent)) {
            return;
        }
        Enumeration e2 = this.getChildren(parent);
        while (e2.hasMoreElements()) {
            Object tmpObj = e2.nextElement();
            this.recExpand(tp.pathByAddingChild(tmpObj));
        }
    }

    public boolean isPopupSuitable(Object container) {
        if (!(container instanceof DBContainer)) {
            return false;
        }
        return ((DBContainer)container).isProgram();
    }

    public boolean periodSelectionChanged() {
        return this.dm.init();
    }

    public void addSingleProgram(String program) {
        Cursor tmpCursor = this.theTree.getCursor();
        this.dm.addSingleProgram(program);
        this.theTree.setCursor(tmpCursor);
    }

    class RootNode {
        private String label = null;

        RootNode() {
        }

        public String toString() {
            return this.label;
        }

        void setLabel(String s) {
            this.label = s;
        }

        String getLabel() {
            return this.label;
        }
    }

    class Reloader
    implements Runnable {
        Object[] path = null;

        public Reloader(Object[] path) {
            this.path = path;
        }

        @Override
        public void run() {
            DBTreeTableModel.this.fireTreeStructureChanged(DBTreeTableModel.this, this.path, null, null);
        }
    }
}

