/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.keyword;

import org.eso.gasgano.keyword.DefaultBoolKeywordExpr;
import org.eso.gasgano.keyword.ExpressionEvaluationException;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.keyword.KeywordExpression;
import org.eso.gasgano.keyword.KeywordSet;

public abstract class BinaryKeywordExpr
extends DefaultBoolKeywordExpr {
    static final long serialVersionUID = 4273027700686012321L;
    private Object lhs = null;
    private Object rhs = null;
    private boolean neverEvalAsFloatExpr = false;
    private boolean neverEvalAsStringExpr = false;

    public BinaryKeywordExpr(Object l, Object r) {
        this.lhs = l;
        this.rhs = r;
        this.setAllowsChildren(false);
    }

    public boolean isStringCompatible(Object arg) {
        boolean rc = false;
        if (arg instanceof String) {
            this.neverEvalAsFloatExpr = true;
            rc = true;
        } else if (arg instanceof Keyword) {
            rc = true;
        }
        return rc;
    }

    public boolean isFloatCompatible(Object arg) {
        boolean rc = false;
        if (arg instanceof Float) {
            this.neverEvalAsStringExpr = true;
            rc = true;
        } else if (arg instanceof Keyword) {
            Keyword k = (Keyword)arg;
            try {
                Float f = k.getNumericValue();
                rc = true;
            }
            catch (NumberFormatException e2) {
                rc = false;
            }
        }
        return rc;
    }

    public Float getFloat(Object arg) throws ExpressionEvaluationException {
        Float rc = null;
        if (arg instanceof Float) {
            rc = (Float)arg;
        } else if (arg instanceof Keyword) {
            Keyword k = (Keyword)arg;
            try {
                rc = k.getNumericValue();
            }
            catch (NumberFormatException e2) {
                throw new ExpressionEvaluationException(e2.getMessage());
            }
        } else {
            throw new ExpressionEvaluationException("argument is not a Float: " + arg.toString());
        }
        return rc;
    }

    public static String getString(Object arg) throws ExpressionEvaluationException {
        String rc = null;
        if (arg instanceof String) {
            rc = (String)arg;
            rc = rc.toUpperCase();
        } else if (arg instanceof Keyword) {
            Keyword k = (Keyword)arg;
            rc = k.getValue();
        } else {
            throw new ExpressionEvaluationException("argument is not a String: " + arg.toString());
        }
        return rc;
    }

    public void resolveKeyword(Object arg, KeywordSet s) {
        if (arg instanceof Keyword && s != null) {
            Keyword k = (Keyword)arg;
            Keyword val = s.getKeyword(k.getName());
            if (val == null) {
                k.setValue("");
            } else {
                k.setValue(val.getValue().toUpperCase());
            }
        }
    }

    public abstract boolean eval(float var1, float var2);

    public abstract boolean eval(String var1, String var2);

    @Override
    public boolean evaluate(KeywordSet s) throws ExpressionEvaluationException {
        boolean rc = false;
        this.resolveKeyword(this.lhs, s);
        this.resolveKeyword(this.rhs, s);
        if (!this.neverEvalAsFloatExpr && this.isFloatCompatible(this.lhs) && this.isFloatCompatible(this.rhs)) {
            rc = this.eval(this.getFloat(this.lhs).floatValue(), this.getFloat(this.rhs).floatValue());
        } else if (!this.neverEvalAsStringExpr && this.isStringCompatible(this.lhs) && this.isStringCompatible(this.rhs)) {
            rc = this.eval(BinaryKeywordExpr.getString(this.lhs), BinaryKeywordExpr.getString(this.rhs));
        } else {
            Keyword tmpKey;
            StringBuffer tmpString = new StringBuffer("Expression arguments are not compatible");
            if (this.lhs instanceof Keyword && ((Keyword)this.lhs).getValue() == "") {
                tmpString = new StringBuffer("Keyword " + ((Keyword)this.lhs).getName() + " not included");
                return false;
            }
            if (this.lhs instanceof Keyword) {
                tmpKey = (Keyword)this.lhs;
                tmpString.append(tmpKey.getName() + " (" + tmpKey.getValue() + ")");
            } else {
                tmpString.append(this.lhs);
            }
            if (this.rhs instanceof Keyword) {
                tmpKey = (Keyword)this.rhs;
                tmpString.append(" " + tmpKey.getName() + " (" + tmpKey.getValue() + ")");
            } else {
                tmpString.append(this.rhs);
            }
            throw new ExpressionEvaluationException(tmpString.toString());
        }
        return rc;
    }

    @Override
    public abstract String getOpString();

    @Override
    public String toString() {
        String rc = new String(KeywordExpression.valueToString(this.lhs) + " " + this.getOpString() + " " + KeywordExpression.valueToString(this.rhs));
        return rc;
    }

    public Object getLeftValue() {
        return this.lhs;
    }

    public Object getRightValue() {
        return this.rhs;
    }
}

